
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk_post.c 2185 2007-06-05 09:25:21Z mschwerin $
 *
 * This file is part of the odk system.
 *
 */

#include "config.h"

#include <assert.h>
#include <xine.h>

#include "heap.h"
#include "i18n.h"
#include "logger.h"
#include "odk_private.h"
#include "utils.h"

#define DEFAULT_DEINTERLACER "tvtime:method=LinearBlend,cheap_mode=1,pulldown=0,use_progressive_frame_flag=1"


#if 0
static char *
odk_post_plugin_type_get_name (int plugin_type)
{
    switch (plugin_type) {
    case XINE_POST_TYPE_VIDEO_FILTER:
        return _("video filter");
    case XINE_POST_TYPE_VIDEO_VISUALIZATION:
        return _("video visualization");
    case XINE_POST_TYPE_VIDEO_COMPOSE:
        return _("video compose");
    case XINE_POST_TYPE_AUDIO_FILTER:
        return _("audio filter");
    case XINE_POST_TYPE_AUDIO_VISUALIZATION:
        return _("audio visualization");
    default:
        break;
    }

    return _("unknown post plugin type");
}
#endif


void
odk_post_init (odk_t * odk)
{
    int plugin_type;
    const char *const *plugin;

    /* Print information about available post plugins. */
#if 0
    int plugin_types[] = {
        XINE_POST_TYPE_VIDEO_FILTER,
        XINE_POST_TYPE_VIDEO_VISUALIZATION,
        XINE_POST_TYPE_VIDEO_COMPOSE,
        XINE_POST_TYPE_AUDIO_FILTER,
        XINE_POST_TYPE_AUDIO_VISUALIZATION
    };
    int p = 0;
    for (p = 0; p < 5; p++) {
        plugin_type = plugin_types[p];
        debug ("post plugins (%s)",
               odk_post_plugin_type_get_name (plugin_types[p]));
        if ((plugin = xine_list_post_plugins_typed (odk->xine, plugin_type))) {
            int i = 0;
            for (i = 0; plugin[i]; i++) {
                debug ("  plugin[%d] = '%s'", i, plugin[i]);
            }
        }
    }
#endif

    /* Audio visualization post plugin */
    plugin_type = XINE_POST_TYPE_AUDIO_VISUALIZATION;
    if ((plugin = xine_list_post_plugins_typed (odk->xine, plugin_type))) {
        int i = 0;
        for (i = 0; plugin[i]; i++);

        char **plugins = (char **) ho_malloc (sizeof (char **) * (i + 1));
        for (i = 0; plugin[i]; i++) {
            plugins[i] = ho_strdup (plugin[i]);
        }
        plugins[i] = NULL;

        config_register_enum ("visual_anim.post_plugin", 0, plugins,
                              _("post plugin type"));

        for (i = 0; plugins[i]; i++) {
            ho_free (plugins[i]);
        }
        ho_free (plugins);
    }

    /* Video deinterlacer post plugin */
#if 0
    {
        xine_config_register_string (odk->xine, "gui.deinterlace_plugin",
                                     DEFAULT_DEINTERLACER,
                                     _("Deinterlace plugin."),
                                     _("Plugin (with optional parameters) to "
                                       "use when deinterlace is used (plugin "
                                       "separator is ';')."), 10, NULL, NULL);
    }
#endif

    odk->novideo_post = NULL;
}


static void
pplugin_audio_unwire (odk_t * odk)
{
    xine_audio_port_t *audio_port = odk->audio_ports.ports[0];
    xine_post_out_t *out = xine_get_audio_source (odk->main_stream);
    xine_post_wire_audio_port (out, audio_port);
}


#if 0
static void
pplugin_video_unwire (odk_t * odk)
{
    xine_post_out_t *out = xine_get_video_source (odk->stream);
    xine_post_wire_video_port (out, odk->win->video_port);
}
#endif


void
odk_post_audio_rewire (odk_t * odk)
{
    xine_cfg_entry_t centry;
    xine_config_lookup_entry (odk->xine, "visual_anim.post_plugin", &centry);
    const char *plugin_name = centry.enum_values[centry.num_value];

    xine_audio_port_t *audio_port = odk->audio_ports.ports[0];
    xine_video_port_t *video_port = odk->win->video_port;

    xine_post_t *plugin = xine_post_init (odk->xine, plugin_name, 0,
                                          &audio_port, &video_port);

    if (!plugin) {
        error (_("Failed to initialize post plugin '%s'!"), plugin_name);
        return;
    }

    xine_post_out_t *output = xine_get_audio_source (odk->main_stream);
    if (!output) {
        xine_post_dispose (odk->xine, plugin);
        error (_("Failed to retrieve audio output from current stream!"));
        return;
    }
    xine_post_in_t *input = xine_post_input (plugin, "audio in");
    if (!input) {
        xine_post_dispose (odk->xine, plugin);
        error (_("Failed to retrieve post plugin input '%s'!"));
        return;
    }
    if (!xine_post_wire (output, input)) {
        xine_post_dispose (odk->xine, plugin);
        error (_("Failed to rewire post plugin!"));
        return;
    }

    odk->novideo_post = plugin;
}


void
odk_post_audio_unwire (odk_t * odk)
{
    assert (odk->novideo_post);

    pplugin_audio_unwire (odk);
    xine_post_dispose (odk->xine, odk->novideo_post);

    odk->novideo_post = NULL;
}
