
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_window.h 1788 2007-02-02 21:00:54Z mschwerin $
 *
 */

#ifndef HAVE_OTK_WINDOW_H
#define HAVE_OTK_WINDOW_H
#ifdef __cplusplus
extern "C" {
#endif

otk_widget_t *otk_window_new (otk_t * otk, int x, int y, int w, int h);

void otk_window_keep (otk_widget_t * window, bool keep);
void otk_window_destroy (otk_widget_t * window);

void otk_window_append (otk_widget_t * window, otk_widget_t * widget);
void otk_window_remove (otk_widget_t * window, otk_widget_t *widget);

void otk_window_focus_pointer_set (otk_widget_t * window, otk_widget_t *widget);
otk_widget_t *otk_window_focus_pointer_get (otk_widget_t * window);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_OTK_WINDOW_H */
