//
// C++ Implementation: aptpackages
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <assert.h>

#include <qstring.h>

#include <apt-pkg/error.h>
#include <apt-pkg/pkgrecords.h>	// for packageNamesToShortDescr
#include <apt-pkg/indexfile.h>	//

#include "helpers.h"

#include "aptpackages.h"

// _config is a global Config* provided by the apt library


CacheAccess::CacheAccess()
{
	_config->Set("quiet",0);
	_config->Set("help",false); 

	if (pkgInitConfig(*_config) == false ||
			pkgInitSystem(*_config,_system) == false)
		cerr << "Error initializing apt-pkg library"<<endl;

	// Open the cache file
	
	_pSrcList = new pkgSourceList;
	_pSrcList->ReadMainList();

	// Generate it and map it
	OpProgress Prog;
	pkgMakeStatusCache(*_pSrcList,Prog,&_pMap,true);

	if (_error->PendingError() == true)
		cerr << "Error after pkgMakeStatusCache"<<endl;

	_pCache = new pkgCache(_pMap);

	if (_error->PendingError() == true)
		cerr << "Error after creating new Cache"<<endl;
}

CacheAccess::~CacheAccess()
{
	/// @todo do we have to delete _pMap here?
	delete _pSrcList;
	delete _pCache;
}


AptPackages::AptPackages(const CacheAccess& ca)
{
	_pMap = ca.pMap();
	_pGCache = ca.pCache();
}


AptPackages::~AptPackages()
{
}


#include <stdlib.h>

// LocalitySort - Sort a version list by package file locality		/*{{{*/
// ---------------------------------------------------------------------
/* */
int LocalityCompare(const void *a, const void *b)
{
   pkgCache::VerFile *A = *(pkgCache::VerFile **)a;
   pkgCache::VerFile *B = *(pkgCache::VerFile **)b;
   
   if (A == 0 && B == 0)
      return 0;
   if (A == 0)
      return 1;
   if (B == 0)
      return -1;
   
   if (A->File == B->File)
      return A->Offset - B->Offset;
   return A->File - B->File;
}

void LocalitySort(pkgCache::VerFile **begin,
		  unsigned long Count,size_t Size)
{   
   qsort(begin,Count,Size,LocalityCompare);
}

bool AptPackages::search(Tagcoll::OpSet<string>& result, const string& pattern, bool searchDescr)
{
	/// @todo this function must nearly match the overloaded one - copy it when the other one is finished
// the code of this function is mainly taken from apt-cache - the serach section. I do not really understand
// it so it might not do what it should all the time.
// WARNING: this code does not conform with my naming scheme as it was mostly copied from apt-cache, so do
// not be confused by this.
	cerr << "Warning AptPackages::search(Tagcoll::OpSet<string>& result, const string& pattern, bool searchDescr) "
	<< "not yet implemented."<<endl;
	return false;
}



bool AptPackages::search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const vector<string>& patterns, bool searchDescr)
{
// the code of this function is mainly taken from apt-cache - the search section. I do not really understand
// it so it might not do what it should all the time.
// WARNING: this code does not conform with my naming scheme as it was mostly copied from apt-cache, so do
// not be confused by this.
	assert(_pGCache);
	pkgCache &Cache = *_pGCache;
	
	pkgDepCache::Policy Plcy;
	
	// Create the text record parser
	pkgRecords Recs(Cache);
	if (_error->PendingError() == true)
	{
		return false;
	}
	
	ExVerFile *VFList = new ExVerFile[Cache.HeaderP->PackageCount+1];
   memset(VFList,0,sizeof(*VFList)*Cache.HeaderP->PackageCount+1);	// set all pointer to be 0
	
	cerr << "upperString "<< patterns[0]<< endl;
	vector<string> lowerPatterns;
	// create lowerCase strings
	transform(patterns.begin(), patterns.end(), back_inserter(lowerPatterns), toLower);
	cerr << "first lowerString "<< lowerPatterns[0] << endl;
	// Map versions that we want to write out onto the VerList array.
	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
	{
		string pkgName(P.Name());
		makeLower(pkgName);	// make the package name lower case
		{	// search in package names for the given patterns
			bool matchedAll = true;	// check if all patterns where found in the package name
			for (vector<string>::const_iterator it=patterns.begin(); it!= patterns.end(); ++it)
			{
				if (pkgName.find(*it)== string::npos)
				{
					matchedAll= false;
					break;
				}
				VFList[P->ID].NameMatch = true;
			}
			if (matchedAll)

		}
		// Doing names only, drop any that dont match..
		if ( !searchDescr && VFList[P->ID].NameMatch == false)
			continue;
		// Find the proper version to use. 
		pkgCache::VerIterator V = Plcy.GetCandidateVer(P);
		if (V.end() == false)
			VFList[P->ID].Vf = V.FileList();
	}
	// Include all the packages that _provide_ matching names too
	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
	{
		if (VFList[P->ID].NameMatch == false)
			continue;
		for (pkgCache::PrvIterator Prv = P.ProvidesList() ; Prv.end() == false; Prv++)
		{
			pkgCache::VerIterator V = Plcy.GetCandidateVer(Prv.OwnerPkg());
			if (V.end() == false)
			{
				VFList[Prv.OwnerPkg()->ID].Vf = V.FileList();
				VFList[Prv.OwnerPkg()->ID].NameMatch = true;
			}
		}
	}
	// I do not really understand this -> I guess it sorts the packages according to their Vf member,
	// important is that members with Vf==0 are moved to the end of the array
   LocalitySort(&VFList->Vf, Cache.HeaderP->PackageCount, sizeof(*VFList));	// BM sort using quicksort

	// Iterate over all the version records and check them
	for (ExVerFile *J = VFList; J->Vf != 0; J++)
	{
		pkgRecords::Parser &P = Recs.Lookup(pkgCache::VerFileIterator(Cache,J->Vf));
		bool match = true;	
		if (J->NameMatch == false)
		{
			string LongDesc = P.LongDesc();
			if ( QString(LongDesc.c_str()).contains(pattern.c_str(),false) )
				match = true;
			else
				match = false;
		}
		if (match)	// if the package matched the apt search
		{
			result.insert( handleMaker.getHandle( P.Name() ) );
		}
	}
	delete [] VFList;
	return result.empty();
}


bool AptPackages::pkgNamesToShortDesc(map<int, string>& result, Tagcoll::HandleMaker<string>& handleMaker)
{
	assert(_pGCache);
	pkgCache &Cache = *_pGCache;
	
	pkgDepCache::Policy Plcy;
	
	// Create the text record parser
	pkgRecords Recs(Cache);
	if ( _GetErrorObj()->PendingError() == true )	// this is the global error object from APT
	{
		string err;
		_GetErrorObj()->PopMessage(err);
		throw AptException(err);
		return false;
	}
	
	// Map versions that we want to write out onto the VerList array.
	for (pkgCache::PkgIterator P = Cache.PkgBegin(); P.end() == false; P++)
	{
//		string shortDescr;
		// Find the proper version to use. 
		pkgCache::VerIterator V = Plcy.GetCandidateVer(P);
		if ( !V.end())	// if we could find a valid version
		{
			pkgRecords::Parser &P = Recs.Lookup( V.FileList() );	// V.FileList() gets us a VerFileIterator
			result[ handleMaker.getHandle(P.Name()) ] = P.ShortDesc();
		}
	}
	return true;
}
