//
// C++ Implementation: filenameplugincontainer
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qobject.h>
#include <qaction.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>

#include <unistd.h>		// for getuid and geteuid
#include <sys/types.h>	//

#include "filenameplugincontainer.h"

#include <applicationfactory.h>
#include <runcommand.h>

#include <iprovider.h>
#include "filenameplugin.h"

#include <iostream>

using namespace std;

extern "C" 
{ 
	NPlugin::PluginContainer* new_filenameplugin() 
	{
		return new NPlugin::FilenamePluginContainer;; 
	} 
	
	NPlugin::PluginInformation get_pluginInformation()
	{
		return NPlugin::PluginInformation("filenameplugin", "1.2", "Benjamin Mesing");
	} 
}


namespace NPlugin 
{

FilenamePluginContainer::FilenamePluginContainer()
{
	addPlugin("FilenamePlugin");
	_pCommand = 0;
	_pAptFileUpdateAction = new QAction("Apt-File Update", 0, this, "AptFileUpdateAction");
	_pAptFileUpdateAction->setStatusTip( tr("This updates the database for the files used by "
		"the filename subsystem") );
	_pAptFileUpdateAction->setWhatsThis(
		tr("This updates the database of files contained in the different "
		"packages. This information is used in the filename search and information section.<br>"
		"It simply launches <tt>apt-file update</tt>.")
	);
	connect( _pAptFileUpdateAction, SIGNAL(activated()), SLOT(onAptFileUpdate()) );
}


FilenamePluginContainer::~FilenamePluginContainer()
{
	delete _pCommand;
}


/////////////////////////////////////////////////////
// Plugin Container Interface
/////////////////////////////////////////////////////

bool FilenamePluginContainer::init(IProvider* pProvider)
{
	BasePluginContainer::init(pProvider, FilenamePluginFactory::getInstance());
	_pAptFileUpdateAction->addTo(provider()->systemMenu());
	requestPlugin("FilenamePlugin");
	return true;
}

QString FilenamePluginContainer::title() const
{
	return QObject::tr("Filename Plugins");
}

vector< pair<QString, QAction*> > FilenamePluginContainer::actions()
{
	vector< pair<QString, QAction*> > result;
	result.push_back(make_pair("System", _pAptFileUpdateAction));
	return result;
}

/////////////////////////////////////////////////////
// Helper Methods
/////////////////////////////////////////////////////


void FilenamePluginContainer::onAptFileUpdate()
{
	if ( geteuid() != 0 )	// check if the user have super user priviledges
	{
		QMessageBox::information( provider()->mainWindow(), tr("Need Root Priviledges"), 
			tr("You need super user priviledges to execute this command.\n"
			  "Please start the application as root and try again."));
		return;
	}
	provider()->setEnabled(false);
	NApplication::ApplicationFactory fac;
	_pCommand = fac.getRunCommand("AptFileUpdateProcess");	// get a suitable user interface for the update
	connect(_pCommand, SIGNAL(quit()), SLOT(onAptFileUpdateFinished()) );
	_pCommand->addArgument("apt-file");
	_pCommand->addArgument("update");
	if ( !_pCommand->start() )
	{
		provider()->reportError( tr("Command not executed"), tr("The command could not be executed.\n"
			"Make sure that /usr/bin/apt-file is installed on your system.") );
		provider()->setEnabled(true);
		delete _pCommand;
		_pCommand = 0;
	}
}

void FilenamePluginContainer::onAptFileUpdateFinished()
{
	if (!_pCommand->processExitedSuccessful())	// if the command was aborted
	{
		provider()->reportWarning(
			tr("Update not successfully completed"), 
			tr("The apt-file update was not completed successfully.<br>"
			"The database might be broken, rerun <tt>apt-file update</tt> to fix this.")
		);
	}
	delete _pCommand;
	_pCommand = 0;
	provider()->setEnabled(true);
}


};
