#include "mycrypt.h"

int coin_toss(const unsigned char *shared_secret, int secret_len, 
              int whoami, int *result)
{
   unsigned char sum, buf[20];
   int x;
   unsigned long z;

   /* get hash of secret */
   z = sizeof(buf);
   if (hash_memory(find_hash("sha1"), shared_secret, secret_len, buf, &z) == CRYPT_ERROR) 
      return CRYPT_ERROR;
 
   /* get the sum */
   for (sum = x = 0; x < 20; x++) sum = (sum + buf[x]) & 255;

   /* win or lose? */
   if (sum<128) {
      *result = (whoami==CF_HOST)?CF_WIN:CF_LOSE;
   } else if (sum >= 128) {
      *result = (whoami==CF_GUEST)?CF_WIN:CF_LOSE;
   }
#ifdef CLEAN_STACK
   zeromem(buf, sizeof(buf));
#endif   
   return CRYPT_OK;
}

static const char *ID_TAG = "coin.c";
 
