// Tell emacs this is really -*- C++ -*-
#ifndef INCLUDE_FILTERHANDLER_H
#define INCLUDE_FILTERHANDLER_H

#include "Filter.h"
#include <list>

class Connection;

class FilterHandler
{
public:
    FilterHandler();
    ~FilterHandler();
    
    char * queryFilter(char *, char *);
    
    // Consumes data from 'in', filters it, appends results to 'out'.
    // 'out' may safely be non-empty.
    // All of 'in' is always consumed.
    void processFilters(Buffer &in, Buffer &out);
    
    // Add a filter to the chain. It is positioned based on f->order().
    // f->input may be non-empty if initial data is pending (for example,
    // when turning on compression).
    void addFilter(Filter *f);
    
    // Remove a filter from the chain. If the filter is not present, nothing
    // happens. If the filter has pending unprocessed input, this is passed on
    // to the next filter in the chain (or the output buffer if there is no
    // next filter).
    void removeFilter(Filter *f);

    // Find a filter by name
    Filter *findFilter(char *name);
    
private:
    // Processes data in the filter chain's input buffer, starting at the
    // given filter (or first filter if start == NULL).
    void processPending(Filter *start);
    
    typedef std::list<Filter*> FilterList;    
    std::list<Filter*> filters;
    
    // Final output buffer that the last filter in the chain writes to.
    // Needed so that removing the last filter in the chain when it has
    // pending input works properly.
    Buffer output;
};

#endif // INCLUDE_FILTERHANDLER_H

