/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PointAttributes.h>
#include <DataNode.h>

// Type map format string
const char *PointAttributes::TypeMapFormatString = "D";

// ****************************************************************************
// Method: PointAttributes::PointAttributes
//
// Purpose: 
//   Constructor for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PointAttributes::PointAttributes() : 
    AttributeSubject(PointAttributes::TypeMapFormatString)
{
    point[0] = 0;
    point[1] = 0;
    point[2] = 0;
}

// ****************************************************************************
// Method: PointAttributes::PointAttributes
//
// Purpose: 
//   Copy constructor for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PointAttributes::PointAttributes(const PointAttributes &obj) : 
    AttributeSubject(PointAttributes::TypeMapFormatString)
{
    point[0] = obj.point[0];
    point[1] = obj.point[1];
    point[2] = obj.point[2];


    SelectAll();
}

// ****************************************************************************
// Method: PointAttributes::~PointAttributes
//
// Purpose: 
//   Destructor for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PointAttributes::~PointAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PointAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PointAttributes& 
PointAttributes::operator = (const PointAttributes &obj)
{
    if (this == &obj) return *this;
    point[0] = obj.point[0];
    point[1] = obj.point[1];
    point[2] = obj.point[2];


    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: PointAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PointAttributes::operator == (const PointAttributes &obj) const
{
    // Compare the point arrays.
    bool point_equal = true;
    for(int i = 0; i < 3 && point_equal; ++i)
        point_equal = (point[i] == obj.point[i]);

    // Create the return value
    return (point_equal);
}

// ****************************************************************************
// Method: PointAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PointAttributes::operator != (const PointAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PointAttributes::TypeName
//
// Purpose: 
//   Type name method for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PointAttributes::TypeName() const
{
    return "PointAttributes";
}

// ****************************************************************************
// Method: PointAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PointAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PointAttributes *tmp = (const PointAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PointAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PointAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PointAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PointAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PointAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PointAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PointAttributes(*this);
    else
        retval = new PointAttributes;

    return retval;
}

// ****************************************************************************
// Method: PointAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PointAttributes::SelectAll()
{
    Select(ID_point, (void *)point, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PointAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PointAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PointAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PointAttributes.
    DataNode *node = new DataNode("PointAttributes");

    if(completeSave || !FieldsEqual(ID_point, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point", point, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PointAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PointAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PointAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("point")) != 0)
        SetPoint(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PointAttributes::SetPoint(const double *point_)
{
    point[0] = point_[0];
    point[1] = point_[1];
    point[2] = point_[2];
    Select(ID_point, (void *)point, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
PointAttributes::GetPoint() const
{
    return point;
}

double *
PointAttributes::GetPoint()
{
    return point;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PointAttributes::SelectPoint()
{
    Select(ID_point, (void *)point, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PointAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PointAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_point: return "point";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PointAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PointAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_point: return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PointAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PointAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_point: return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PointAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PointAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PointAttributes &obj = *((const PointAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_point:
        {  // new scope
        // Compare the point arrays.
        bool point_equal = true;
        for(int i = 0; i < 3 && point_equal; ++i)
            point_equal = (point[i] == obj.point[i]);

        retval = point_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

