//========================================================================
//
// ocfile.cpp
//
// Drop-in replacement for C <stdio.h> FILE 
//
//========================================================================

#include "ocfile.h"
#include <list>
#include <cassert>

// --------------------------------------------------------------------

// This function is from Xpdf. 
// It is here since the file that contained it originally is gone.
char *getLine(char *buf, int size, OCFILE *f)
{
  int c, i;

  i = 0;
  while (i < size - 1) {
    if ((c = fgetc(f)) == EOF) {
      break;
    }
    buf[i++] = (char)c;
    if (c == '\x0a') {
      break;
    }
    if (c == '\x0d') {
      c = fgetc(f);
      if (c == '\x0a' && i < size - 1) {
	buf[i++] = (char)c;
      } else if (c != EOF) {
	ungetc(c, f);
      }
      break;
    }
  }
  buf[i] = '\0';
  if (i == 0) {
    return NULL;
  }
  return buf;
}

// --------------------------------------------------------------------
