# PAC_LIB_PETSC([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of PETSc
AC_DEFUN(PAC_LIB_PETSC,
[
AC_ARG_WITH(petsc, [  --with-petsc                Use PETSc], [PETSC_DIR_TMP=$withval])
if test -n "$PETSC_DIR_TMP"; then
    if test "$PETSC_DIR_TMP" = "yes"; then
        USE_PETSC="yes"
    elif test "$PETSC_DIR_TMP" = "no"; then
        USE_PETSC="no"
    else
        USE_PETSC="yes"
        PETSC_DIR="$PETSC_DIR_TMP"
    fi
fi
if test "$USE_PETSC" = "yes"; then 

if test -z "$PETSC_DIR"; then
  AC_WARN([Missing PETSC_DIR enviroment variable or argument to --with-petsc.])
  ac_cv_lib_petsc=no

else 

ac_cv_lib_petsc=yes
AC_REQUIRE([PAC_ENV_PETSC])
AC_REQUIRE([AC_PATH_XTRA])
LIBS="$LIBS $X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
AC_REQUIRE([PAC_LIB_BLAS])
if test "$ac_cv_lib_blas" = "no"; then
    AC_MSG_ERROR([Unable to locate BLAS!])
fi
AC_REQUIRE([PAC_LIB_LAPACK])
if test "$ac_cv_lib_lapack" = "no"; then
    AC_MSG_ERROR([Unable to locate LAPACK!])
fi
AC_REQUIRE([PAC_LIB_MPI])
if test "$ac_cv_lib_mpi" = "no"; then
    PAC_LIB_MPI_UNI
fi
if test "$ac_cv_lib_mpi" = "no"; then
    AC_MSG_ERROR([Unable to locate MPI!])
fi
AC_CHECK_LIB(m, sin)
AC_CHECK_LIB(dl, dlopen)

ac_save_LDFLAGS="$LDFLAGS"
LDFLAGS="$LDFLAGS -L$PETSC_DIR/lib/lib$BOPT/$PETSC_ARCH"
AC_CHECK_LIB(petsc, PetscInitialize, , , [
    $X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS])
if test "$ac_cv_lib_petsc_PetscInitialize" = "no"; then
  ac_cv_lib_petsc=no
fi

AC_CHECK_LIB(petscvec, VecDestroy, , , )
if test "$ac_cv_lib_petscvec_VecDestroy" = "no"; then
  ac_cv_lib_petscvec=no
fi

AC_CHECK_LIB(petscmat, MatDestroy, , , )
if test "$ac_cv_lib_petscmat_MatDestroy" = "no"; then
  ac_cv_lib_petscmat=no
fi

AC_CHECK_LIB(petscbilinear, BilinearDestroy, , , )
if test "$ac_cv_lib_petscbilinear_BilinearDestroy" = "no"; then
  ac_cv_lib_petscbilinear=no
fi

AC_CHECK_LIB(petscdm, AODestroy, , , )
if test "$ac_cv_lib_petscdm_AODestroy" = "no"; then
  ac_cv_lib_petscdm=no
fi

AC_CHECK_LIB(petscsles, SLESDestroy, , , )
if test "$ac_cv_lib_petscsles_SLESDestroy" = "no"; then
  ac_cv_lib_petscsles=no
fi

AC_CHECK_LIB(petscsnes, SNESDestroy, , , )
if test "$ac_cv_lib_petscsnes_SNESDestroy" = "no"; then
  ac_cv_lib_petscsnes=no
fi

AC_CHECK_LIB(petscts, TSDestroy, , , )
if test "$ac_cv_lib_petscts_TSDestroy" = "no"; then
  ac_cv_lib_petscts=no
fi

AC_CHECK_LIB(petscmesh, MeshDestroy, , , )
if test "$ac_cv_lib_petscmesh_MeshDestroy" = "no"; then
  ac_cv_lib_petscmesh=no
fi

AC_CHECK_LIB(petscgrid, GridDestroy, , , )
if test "$ac_cv_lib_petscgrid_GridDestroy" = "no"; then
  ac_cv_lib_petscgrid=no
fi

AC_CHECK_LIB(petscgsolver, GSNESDestroy, , , )
if test "$ac_cv_lib_petscgsolver_GSNESDestroy" = "no"; then
  ac_cv_lib_petscgsolver=no
fi

fi

save_CPPFLAGS="$CPPFLAGS -I$PETSC_DIR/include -I$PETSC_DIR/bmake/$PETSC_ARCH"
CPPFLAGS="$save_CPPFLAGS $MPI_INCLUDE"
#AC_CHECK_HEADER(petsc.h, , AC_MSG_ERROR([Could not find $PETSC_DIR/include/petsc.h!]))
CPPFLAGS="$save_CPPFLAGS"

if test "$ac_cv_lib_petsc" = "yes"; then
    ifelse([$1], , :, [$1])
else
    LDFLAGS="$ac_save_LDFLAGS"
    ifelse([$2], , :, [$2])
fi

else
    ac_cv_lib_petsc=no
    ifelse([$2], , :, [$2])
fi
]
)
# end of PAC_LIB_PETSC
#
# PAC_ENV_PETSC()
#
# Check for the existence of PETSc defines and set them to defaults
AC_DEFUN(PAC_ENV_PETSC,
[
if test -n "$PETSC_DIR"; then
    if test -z "$BOPT"; then
        BOPT="g"
    fi
    if test -z "$PETSC_ARCH"; then
        PETSC_ARCH=`$PETSC_DIR/bin/petscarch`
    fi
fi
]
)
# end of PAC_ENV_PETSC
#
# PAC_LIB_TRIANGLE([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of Triangle
AC_DEFUN(PAC_LIB_TRIANGLE,
[
AC_ARG_WITH(triangle, [  --with-triangle             Use the Triangle package], [USE_TRIANGLE="yes" TRIANGLE_DIR="$withval"])
AC_ARG_WITH(triangle-inc, [  --with-triangle-inc=dir     Specify Triangle include directories], TRIANGLE_INCLUDE="$withval")
AC_ARG_WITH(triangle-lib, [  --with-triangle-lib=liblist Specify Triangle library list], TRIANGLE_LIB="$withval")
if test "$USE_TRIANGLE" = "yes"; then
    if test -n "$TRIANGLE_DIR" && test ! "$TRIANGLE_DIR" = "yes"; then
        AC_CONFIG_SUBDIRS($TRIANGLE_DIR)
    else
        TRIANGLE_DIR="$(dir $(TRIANGLE_LIB))"
    fi

    dnl Check for header
    if test -z "$TRIANGLE_INCLUDE"; then
        TRIANGLE_INCLUDE="-I$TRIANGLE_DIR/include"
    fi
    save_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS $TRIANGLE_INCLUDE"
    AC_CHECK_HEADER(triangle.h, , AC_MSG_WARN([Could not find $TRIANGLE_INCLUDE/triangle.h!])
        TRIANGLE_INCLUDE="")
    CPPFLAGS="$save_CPPFLAGS"

    dnl Check for library
    dnl I put the Petsc memory stuff in Triangle, so we have to do some magic
    AC_MSG_CHECKING([triangulate in -ltriangle])
    save_LDFLAGS="$LDFLAGS"
    save_DYLIBPATH="$DYLIBPATH"
    if test -z "$TRIANGLE_LIB"; then
        LDFLAGS="$LDFLAGS -L$TRIANGLE_DIR/lib/lib$BOPT/$PETSC_ARCH"
        DYLIBPATH="$DYLIBPATH:$TRIANGLE_DIR/lib/lib$BOPT/$PETSC_ARCH"
        TRIANGLE_LIB="-ltriangle"
    else
        DYLIBPATH="$DYLIBPATH:$PARMETIS_DIR"
    fi
    save_LIBS="$LIBS"
    LIBS="$TRIANGLE_LIB $LIBS"
    AC_TRY_LINK([void *PetscTrMalloc(unsigned int size,int line,char*func,char*file,char*dir) {return (void *) malloc(size);}
                 int PetscTrFree(void *ptr) {free(ptr); return 0;}
                 char *triangulate();],
                 [triangulate();],
                 AC_MSG_RESULT([yes])
                 ac_cv_lib_triangle_triangulate="yes",
                 AC_MSG_RESULT([no])
                 ac_cv_lib_triangle_triangulate="no")
    LIBS="$save_LIBS"
    if test "$ac_cv_lib_triangle_triangulate" = "yes"; then
        EXTRA_LIBS="$TRIANGLE_LIB $EXTRA_LIBS"
    else
        LDFLAGS="$save_LDFLAGS"
        DYLIBPATH="$save_DYLIBPATH"
        TRIANGLE_LIB=""
    fi

    dnl Indicate package availability
    if test "$ac_cv_header_triangle_h" = "yes" -a "$ac_cv_lib_triangle_triangulate" = "yes"; then
        AC_DEFINE(PETSC_HAVE_TRIANGLE)
        ifelse([$1], , [
            AC_SUBST(TRIANGLE_INCLUDE)
            AC_SUBST(TRIANGLE_LIB)], [$1])
    else
        ifelse([$2], , [
            :
            AC_SUBST(TRIANGLE_INCLUDE)
            AC_SUBST(TRIANGLE_LIB)], [$2])
    fi
else
    TRIANGLE_INCLUDE=""
    TRIANGLE_LIB=""
    ifelse([$2], , [
        :
        AC_SUBST(TRIANGLE_INCLUDE)
        AC_SUBST(TRIANGLE_LIB)], [$2])
fi
]
)
# end of PAC_LIB_TRIANGLE
#
# PAC_LIB_PARMETIS([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of ParMetis
AC_DEFUN(PAC_LIB_PARMETIS,
[
AC_ARG_WITH(parmetis, [  --with-parmetis             Use the ParMetis package], [USE_PARMETIS="yes" PARMETIS_DIR="$withval"])
AC_ARG_WITH(parmetis-inc, [  --with-parmetis-inc=dir     Specify ParMetis include directories], PARMETIS_INCLUDE="$withval")
AC_ARG_WITH(parmetis-lib, [  --with-parmetis-lib=liblist Specify ParMetis library list], PARMETIS_LIB="$withval")
if test "$USE_PARMETIS" = "yes"; then
    AC_REQUIRE([PAC_LIB_MPI])
    if test -n "$PARMETIS_DIR" && test ! "$PARMETIS_DIR" = "yes"; then
        AC_CONFIG_SUBDIRS($PARMETIS_DIR)
    else
        PARMETIS_DIR="$(dir $(PARMETIS_LIB))"
    fi

    dnl Check for header
    if test -z "$PARMETIS_INCLUDE"; then
        PARMETIS_INCLUDE="-I$PARMETIS_DIR/include"
    fi
    save_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS $PARMETIS_INCLUDE"
    AC_CHECK_HEADER(parmetis.h, , AC_MSG_WARN([Could not find $PARMETIS_INCLUDE/parmetis.h!])
        PARMETIS_INCLUDE="")
    CPPFLAGS="$save_CPPFLAGS"

    dnl Check for library
    save_LDFLAGS="$LDFLAGS"
    save_DYLIBPATH="$DYLIBPATH"
    if test -z "$PARMETIS_LIB"; then
        LDFLAGS="$LDFLAGS -L$PARMETIS_DIR/lib/lib$BOPT/$PETSC_ARCH"
        DYLIBPATH="$DYLIBPATH:$PARMETIS_DIR/lib/lib$BOPT/$PETSC_ARCH"
        PARMETIS_LIB="-lparmetis -lmetis"
    else
        DYLIBPATH="$DYLIBPATH:$PARMETIS_DIR"
    fi
    save_LIBS="$LIBS"
    AC_CHECK_LIB(parmetis, PARKMETIS, , , [$PARMETIS_LIB $MPI_LIB])
    LIBS="$save_LIBS"
    if test "$ac_cv_lib_parmetis_PARKMETIS" = "yes"; then
        EXTRA_LIBS="$PARMETIS_LIB $EXTRA_LIBS"
    else
        LDFLAGS="$save_LDFLAGS"
        DYLIBPATH="$save_DYLIBPATH"
        PARMETIS_LIB=""
    fi

    dnl Indicate package availability
    if test "$ac_cv_header_parmetis_h" = "yes" -a "$ac_cv_lib_parmetis_PARKMETIS" = "yes"; then
        AC_DEFINE(PETSC_HAVE_PARMETIS)
        ifelse([$1], , [
            AC_SUBST(PARMETIS_INCLUDE)
            AC_SUBST(PARMETIS_LIB)], [$1])
    else
        ifelse([$2], , [
            :
            AC_SUBST(PARMETIS_INCLUDE)
            AC_SUBST(PARMETIS_LIB)], [$2])
    fi
else
    PARMETIS_INCLUDE=""
    PARMETIS_LIB=""
    ifelse([$2], , [
        :
        AC_SUBST(PARMETIS_INCLUDE)
        AC_SUBST(PARMETIS_LIB)], [$2])
fi
]
)
# end of PAC_LIB_PARMETIS
#
# PAC_LIB_PLAPACK([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of PLAPACK
AC_DEFUN(PAC_LIB_PLAPACK,
[
AC_ARG_WITH(plapack, [  --with-plapack              Use the PLAPACK package], [USE_PLAPACK="yes" PLAPACK_DIR="$withval"])
AC_ARG_WITH(plapack-inc, [  --with-plapack-inc=dir      Specify PLAPACK include directories], PLAPACK_INCLUDE="$withval")
AC_ARG_WITH(plapack-lib, [  --with-plapack-lib=liblist  Specify PLAPACK library list], PLAPACK_LIB="$withval")
if test "$USE_PLAPACK" = "yes"; then
    AC_REQUIRE([PAC_LIB_BLAS])
    AC_REQUIRE([PAC_LIB_LAPACK])
    AC_REQUIRE([PAC_LIB_MPI])
    if test -n "$PLAPACK_DIR" && test ! "$PLAPACK_DIR" = "yes"; then
        AC_CONFIG_SUBDIRS($PLAPACK_DIR)
    else
        PLAPACK_DIR="$(dir $(PLAPACK_LIB))"
    fi

    dnl Check for header
    if test -z "$PLAPACK_INCLUDE"; then
        PLAPACK_INCLUDE="-I$PLAPACK_DIR/INCLUDE"
    fi
    save_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS $PLAPACK_INCLUDE $MPI_INCLUDE"
    AC_CHECK_HEADER(PLA.h, , AC_MSG_WARN([Could not find $PLAPACK_INCLUDE/PLA.h!])
        PLAPACK_INCLUDE="")
    CPPFLAGS="$save_CPPFLAGS"

    dnl Check for library
    save_LDFLAGS="$LDFLAGS"
    save_DYLIBPATH="$DYLIBPATH"
    if test -z "$PLAPACK_LIB"; then
        LDFLAGS="$LDFLAGS -L$PLAPACK_DIR/lib/lib$BOPT/$PETSC_ARCH"
        DYLIBPATH="$DYLIBPATH:$PLAPACK_DIR/lib/lib$BOPT/$PETSC_ARCH"
        PLAPACK_LIB="-lPLAPACK_SOLVERS -lPLAPACK -lMMPI"
    else
        DYLIBPATH="$DYLIBPATH:$PARMETIS_DIR"
    fi
    save_LIBS="$LIBS"
    AC_CHECK_LIB(PLAPACK_SOLVERS, PLA_QR, , , [$PLAPACK_LIB $MPI_LIB $LAPACK_LIB $BLAS_LIB])
    LIBS="$save_LIBS"
    if test "$ac_cv_lib_PLAPACK_SOLVERS_PLA_QR" = "yes"; then
        EXTRA_LIBS="$PLAPACK_LIB $EXTRA_LIBS"
    else
        LDFLAGS="$save_LDFLAGS"
        DYLIBPATH="$save_DYLIBPATH"
        PLAPACK_LIB=""
    fi

    dnl Indicate package availability
    if test "$ac_cv_header_PLA_h" = "yes" -a "$ac_cv_lib_PLAPACK_SOLVERS_PLA_QR" = "yes"; then
        AC_DEFINE(PETSC_HAVE_PLAPACK)
        ifelse([$1], , [
            AC_SUBST(PLAPACK_INCLUDE)
            AC_SUBST(PLAPACK_LIB)], [$1])
    else
        ifelse([$2], , [
            :
            AC_SUBST(PLAPACK_INCLUDE)
            AC_SUBST(PLAPACK_LIB)], [$2])
    fi
else
    PLAPACK_INCLUDE=""
    PLAPACK_LIB=""
    ifelse([$2], , [
        :
        AC_SUBST(PLAPACK_INCLUDE)
        AC_SUBST(PLAPACK_LIB)], [$2])
fi
]
)
# end of PAC_LIB_PLAPACK
#
# PAC_LIB_ADIC([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of ADIC
AC_DEFUN(PAC_LIB_ADIC,
[
AC_ARG_WITH(adic, [  --with-adic                 Use the ADIC package], [USE_ADIC="yes"])
AC_ARG_WITH(adic-cc, [  --with-adic-cc=program      Specify the ADIC compiler], [ADIC_CC="$withval"])
AC_ARG_WITH(adic-grad-max, [  --with-adic-grad-max=num    Specify the number of colors], [ADIC_GRAD_MAX="$withval"])
if test "$USE_ADIC" = "yes"; then
    AC_REQUIRE([PAC_LIB_BLAS])
    AC_REQUIRE([PAC_LIB_LAPACK])

    dnl Check for compiler
    AC_PATH_PROGS(ADIC_CC_CANONICAL, `echo $ADIC_CC | sed -e 's/\ .*//'`)

    dnl Indicate package availability
    if test -n "$ADIC_CC_CANONICAL"; then
        AC_DEFINE(PETSC_HAVE_ADIC)
        if test -n "$ADIC_GRAD_MAX"; then
            ADIC_DEFINES="-Dad_GRAD_MAX=$ADIC_GRAD_MAX"
        fi
        ifelse([$1], , [
            AC_SUBST(ADIC_DEFINES)
            AC_SUBST(ADIC_CC)], [$1])
    else
        ifelse([$2], , [
            :
            AC_SUBST(ADIC_DEFINES)
            AC_SUBST(ADIC_CC)], [$2])
    fi
else
    ADIC_DEFINES=""
    ADIC_CC=""
    ifelse([$2], , [
        :
        AC_SUBST(ADIC_DEFINES)
        AC_SUBST(ADIC_CC)], [$2])
fi
]
)
# end of PAC_LIB_ADIC
#
# PAC_LIB_MPI_AUX()
#
# Check for auxilliary information about MPI
AC_DEFUN(PAC_LIB_MPI_AUX,
[
if test "$USE_MPI" = "yes"; then
    # Get sizeof MPI_Comm
    save_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS -I$MPI_INCLUDE_DIR"
    PAC_CHECK_SIZEOF(MPI_Comm, , "mpi.h")
    CPPFLAGS="$save_CPPFLAGS"

    PAC_CHECK_SIZEOF(MPI_Fint, , "mpi.h")

    # Figure out conversions to Fortran
    save_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS -I$MPI_INCLUDE_DIR"
    save_LIBS="$LIBS"
    LIBS="$LIBS $MPI_LIB"
    AC_MSG_CHECKING([MPI_Comm_f2c in -l$MPI_LIB_NAME])
    AC_TRY_LINK([#include "mpi.h"],
                [MPI_Comm_f2c(MPI_COMM_WORLD);],
                AC_MSG_RESULT([yes])
                AC_DEFINE(HAVE_MPI_COMM_F2C)
                ac_cv_lib_mpi_MPI_Comm_f2c="yes",
                AC_MSG_RESULT([no])
                ac_cv_lib_mpi_MPI_Comm_f2c="no")
    AC_MSG_CHECKING([MPI_Comm_c2f in -l$MPI_LIB_NAME])
    AC_TRY_LINK([#include "mpi.h"],
                [MPI_Comm_c2f(MPI_COMM_WORLD);],
                AC_MSG_RESULT([yes])
                AC_DEFINE(HAVE_MPI_COMM_C2F)
                ac_cv_lib_mpi_MPI_Comm_c2f="yes",
                AC_MSG_RESULT([no])
                ac_cv_lib_mpi_MPI_Comm_c2f="no")
    LIBS="$save_LIBS"
    CPPFLAGS="$save_CPPFLAGS"
fi
]
)
# end of PAC_LIB_MPI_AUX
#
# PAC_LIB_MPI([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of MPI
AC_DEFUN(PAC_LIB_MPI,
[
AC_ARG_WITH(mpi, [  --with-mpi[=LIB]            Choose MPI implementation], [MPI_LIB=$withval])
AC_ARG_WITH(mpi-include, [  --with-mpi-include=DIR      Choose MPI include directory], [MPI_INCLUDE_DIR=$withval])
if test -n "$MPI_LIB"; then
    if test "$MPI_LIB" = "yes"; then
        USE_MPI="yes"
        MPI_LIB="mpich"
    elif test "$MPI_LIB" = "no"; then
        USE_MPI="no"
        MPI_LIB="mpich"
    else
        USE_MPI="yes"
    fi
fi
if test "$USE_MPI" = "yes"; then
    ac_cv_lib_mpi=no
    save_LIBS="$LIBS"

    if test -n "$MPI_LIB" && test ! "$MPI_LIB" = "yes"; then
        MPI_LIB_DIR=`dirname $MPI_LIB`
        if test ! "$MPI_LIB_DIR" = "."; then
            if test ! -f "$MPI_LIB" ; then
                AC_MSG_ERROR([MPI library $MPI_LIB does not exist!])
            fi
            # We need to strip off the /lib level
            MPI_DIR=`dirname $MPI_LIB_DIR`
        else
            # The user only gave the library name, not location
            MPI_DIR="/usr"
        fi
        temp_LIB=`basename $MPI_LIB .a`
        MPI_LIB=`basename $temp_LIB .so | sed -e 's/^lib//'`
        MPIRUN="$MPI_DIR/bin/mpirun"
        if test -z "$MPI_INCLUDE_DIR"; then
            MPI_INCLUDE_DIR="$MPI_DIR/include"
        fi
    else
        MPI_LIB=mpich
    fi

    # We can't use SEARCH_LIBS in this macro since it caches the value
    save_LDFLAGS="$LDFLAGS"
    LDFLAGS="$LDFLAGS -L$MPI_LIB_DIR"
    AC_CHECK_LIB($MPI_LIB, MPI_Init)
    MPI_LIB_CANONICAL=`echo $MPI_LIB | sed 'y%./+-%__p_%'`
    if eval "test \"`echo '$''{ac_cv_lib_'$MPI_LIB_CANONICAL'_MPI_Init}'`\" = no"; then
        MPI_LIB=mpi
        AC_CHECK_LIB(mpi, MPI_Init)
        # If we did not find the provided library name MPI_LIB, then hereafter we assume mpich/mpi
    else
        ac_cv_lib_mpi_MPI_Init=yes
    fi
    LDFLAGS="$save_LDFLAGS"

    # Try using MPILIBPATH and MPIINCLUDEPATH
    if test "$ac_cv_lib_mpi_MPI_Init" = "no"; then
        unset ac_cv_lib_mpich_MPI_Init
        save_LDFLAGS="$LDFLAGS"
        LDFLAGS="$LDFLAGS -L$MPILIBPATH"
        MPI_LIB=mpich
        AC_CHECK_LIB(mpich, MPI_Init)
        if test "$ac_cv_lib_mpich_MPI_Init" = "no"; then
            unset ac_cv_lib_mpi_MPI_Init
            MPI_LIB=mpi
            AC_CHECK_LIB(mpi, MPI_Init)
        else
            ac_cv_lib_mpi_MPI_Init=yes
        fi

        if test "$ac_cv_lib_mpi_MPI_Init" = "yes" ; then
            MPI_INCLUDE_DIR="$MPIINCLUDEPATH"
            MPI_LIB_DIR="$MPILIBPATH"
        fi
        LDFLAGS="$save_LDFLAGS"
    fi

    # Try using MPI_DIR
    if test "$ac_cv_lib_mpi_MPI_Init" = "no" ; then
        unset ac_cv_lib_mpich_MPI_Init
        save_LDFLAGS="$LDFLAGS"
        LDFLAGS="$LDFLAGS -L$MPILIBPATH"
        MPI_LIB=mpich
        AC_CHECK_LIB(mpich, MPI_Init, , , [-L$MPI_DIR/lib])
        if test "$ac_cv_lib_mpich_MPI_Init" = "no"; then
            unset ac_cv_lib_mpi_MPI_Init
            MPI_LIB=mpi
            AC_CHECK_LIB(mpi, MPI_Init, , , [-L$MPI_DIR/lib])
        else
            ac_cv_lib_mpi_MPI_Init=yes
        fi

        if test "$ac_cv_lib_mpi_MPI_Init" = "yes" ; then
            MPI_INCLUDE_DIR="$MPI_DIR/include"
            MPI_LIB_DIR="$MPI_DIR/lib"
        fi
        LDFLAGS="$save_LDFLAGS"
    fi

    if test "$ac_cv_lib_mpi_MPI_Init" = "yes"; then
        # Here we assume that a user who provided the library will want an error if the header is missing
        save_CPPFLAGS="$CPPFLAGS"
        CPPFLAGS="$CPPFLAGS -I$MPI_INCLUDE_DIR"
        AC_CHECK_HEADER(mpi.h, , AC_MSG_ERROR([Could not find $MPI_INCLUDE_DIR/mpi.h!]))
        CPPFLAGS="$save_CPPFLAGS"
        ac_cv_lib_mpi=yes
    fi

    if test "$ac_cv_lib_mpi" = "yes"; then
        MPI_LIB_NAME="$MPI_LIB"
        LIBS="$save_LIBS"
        if test -z "$MPIRUN"; then
            MPIRUN="$MPI_DIR/bin/mpirun"
        fi
        if test -n "$MPI_LIB_DIR"; then
            LDFLAGS="$LDFLAGS -L$MPI_LIB_DIR"
            DYLIBPATH="$DYLIBPATH:$MPI_LIB_DIR"
        fi
        MPI_INCLUDE="-I$MPI_INCLUDE_DIR"
        MPI_LIB="-l$MPI_LIB"
        EXTRA_LIBS="$MPI_LIB $EXTRA_LIBS"

        PAC_LIB_MPI_AUX

        ifelse([$1], , [
               AC_DEFINE(HAVE_MPI)
               AC_SUBST(MPI_LIB)
               AC_SUBST(MPIRUN)
               AC_SUBST(MPI_INCLUDE)]
               , [$1])
    else
        ifelse([$2], , :, [$2])
    fi
else
    ac_cv_lib_mpi=no
    ifelse([$2], , :, [$2])
fi
]
)
# end of PAC_LIB_MPI
#
# PAC_LIB_MPI_UNI
#
# If MPI is not yet defined, use the uniprocessor MPI
AC_DEFUN(PAC_LIB_MPI_UNI,
[
if test "$ac_cv_lib_mpi" = "no"; then
    MPI_LIB="-lmpiuni"
    MPI_INCLUDE="-I$PETSC_DIR/src/sys/src/mpiuni"
    MPIRUN="$PETSC_DIR/src/sys/src/mpiuni/mpirun"

#    save_CPPFALGS="$CPPFLAGS"
#    CPPFLAGS="$MPI_INCLUDE"
#    AC_CHECK_HEADER(mpi.h, ,[
#        AC_MSG_WARN([configure expected to find PETSc's mpi.h (for running in single processor mode) in
#                     $PETSC_DIR/src/sys/src/mpiuni/mpi.h. Check that you have PETSC_DIR set correctly
#                     and that the PETSc source tree has been correctly unpacked (for example, check that
#                     the extraction was not terminated due to low disk space).])
#        AC_MSG_ERROR([Could not find PETSc's mpi.h file!])]
#    )
#    CPPFLAGS="$save_CPPFLAGS"
    ac_cv_lib_mpi=yes
    ac_cv_lib_mpiuni=yes

    PAC_LIB_MPI_AUX

    AC_DEFINE(PETSC_HAVE_MPI_UNI)
    AC_SUBST(MPI_LIB)
    AC_SUBST(MPIRUN)
    AC_SUBST(MPI_INCLUDE)
fi
])
# end of PAC_LIB_MPI_UNI
#
# PAC_LIB_LAPACK([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of LAPACK
AC_DEFUN(PAC_LIB_LAPACK,
[
AC_ARG_WITH(lapack, [  --with-lapack               Choose LAPACK implementation], [LAPACK_LIB=$withval])
if test -n "$LAPACK_LIB"; then
    if test "$LAPACK_LIB" = "yes"; then
        USE_LAPACK="yes"
        LAPACK_LIB="lapack"
    elif test "$LAPACK_LIB" = "no"; then
        USE_LAPACK="no"
        LAPACK_LIB="lapack"
    else
        USE_LAPACK="yes"
    fi
fi
if test "$USE_LAPACK" = "yes"; then 
    AC_REQUIRE([PAC_LIB_BLAS])
    ac_cv_lib_lapack=no;

    if test -n "$LAPACK_LIB" && test ! "$LAPACK_LIB" = "yes"; then
        LAPACK_DIR=`dirname $LAPACK_LIB`
        if test ! "$LAPACK_DIR" = "."; then
            if test -f "$LAPACK_LIB" ; then
                :
            elif test -f "$LAPACK_LIB/lib/lib$BOPT/$PETSC_ARCH/liblapack.a"; then
                LAPACK_LIB="$LAPACK_LIB/lib/lib$BOPT/$PETSC_ARCH/liblapack.a"
                LAPACK_DIR=`dirname $LAPACK_LIB`
            else
                AC_MSG_ERROR([LAPACK library $LAPACK_LIB does not exist!])
            fi
        else
            # The user only gave the library name, not location
            LAPACK_DIR=""
        fi
        temp_LIB=`basename $LAPACK_LIB .a`
        LAPACK_LIB=`basename $temp_LIB .so | sed -e 's/^lib//'`
    else
        LAPACK_LIB=lapack
    fi
    save_LIBS="$LIBS"
    LIBS="$BLAS_LIB $LIBS"

    # Check in LAPACK_LIB
    PAC_CHECK_FORTRAN_LIB($LAPACK_LIB, dtrtrs, [AC_DEFINE(HAVE_LIBLAPACK)], , [-L$LAPACK_DIR])
    LAPACK_LIB_CANONICAL=`echo $LAPACK_LIB | sed 'y%./+-%__p_%'`

    # Check in PETSc distribution
    if eval "test \"`echo '$''{ac_cv_fortran_lib_'$LAPACK_LIB_CANONICAL'_dtrtrs}'`\" = no"; then
        LAPACK_DIR="$PETSC_DIR/../blaslapack/lib/lib$BOPT/$PETSC_ARCH"
        PAC_CHECK_FORTRAN_LIB($LAPACK_LIB, dtrtrs, [AC_DEFINE(HAVE_LIBLAPACK)], , [-L$LAPACK_DIR])
    fi

    # Check in BLAS_LIB since they may be the same
    if eval "test \"`echo '$''{ac_cv_fortran_lib_'$LAPACK_LIB_CANONICAL'_dtrtrs}'`\" = no"; then
        PAC_CHECK_FORTRAN_LIB($BLAS_LIB_NAME, dtrtrs, [AC_DEFINE(HAVE_LIBLAPACK)], , [-L$BLAS_DIR])
        LAPACK_LIB_CANONICAL="$BLAS_LIB_CANONICAL"
    fi
    LIBS="$save_LIBS"

    # End of tests using Fortran symbols from C
    if eval "test \"`echo '$''{ac_cv_fortran_lib_'$LAPACK_LIB_CANONICAL'_dtrtrs}'`\" = yes"; then
        ac_cv_lib_lapack=yes;
    fi

    if test "$ac_cv_lib_lapack" = "yes"; then
        ifelse([$1], , [
            if test -n "$LAPACK_LIB"; then
                LAPACK_LIB="-l$LAPACK_LIB"
                EXTRA_LIBS="$LAPACK_LIB $EXTRA_LIBS"
            fi
            if test -n "$LAPACK_DIR"; then
                LDFLAGS="$LDFLAGS -L$LAPACK_DIR"
                DYLIBPATH="$DYLIBPATH:$LAPACK_DIR"
            fi
            AC_SUBST(LAPACK_DIR) 
            AC_SUBST(LAPACK_LIB)], [$1])
    else
        ifelse([$2], , :, [$2])
    fi

else

    ac_cv_lib_lapack=no
    ifelse([$2], , :, [$2])
fi
]
)
# end of PAC_LIB_LAPACK
#
# PAC_LIB_BLAS([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the existence of BLAS
AC_DEFUN(PAC_LIB_BLAS,
[
AC_ARG_WITH(blas, [  --with-blas                 Choose BLAS implementation], [BLAS_LIB=$withval])
if test -n "$BLAS_LIB"; then
    if test "$BLAS_LIB" = "yes"; then
        USE_BLAS="yes"
        BLAS_LIB="blas"
    elif test "$BLAS_LIB" = "no"; then
        USE_BLAS="no"
        BLAS_LIB="blas"
    else
        USE_BLAS="yes"
    fi
fi
if test "$USE_BLAS" = "yes" ; then 
    AC_REQUIRE([PAC_ENV_PETSC])
    AC_REQUIRE([AC_F77_LIBRARY_LDFLAGS])
    ac_cv_lib_blas=no;

    if test -n "$BLAS_LIB"; then
        BLAS_DIR=`dirname $BLAS_LIB`
        if test ! "$BLAS_DIR" = "."; then
            if test -f "$BLAS_LIB" ; then
                :
            elif test -f "$BLAS_LIB/lib/lib$BOPT/$PETSC_ARCH/libblas.a"; then
                BLAS_LIB="$BLAS_LIB/lib/lib$BOPT/$PETSC_ARCH/libblas.a"
                BLAS_DIR=`dirname $BLAS_LIB`
            else
                AC_MSG_ERROR([BLAS library $BLAS_LIB does not exist!])
            fi
        else
            # The user only gave the library name, not location
            BLAS_DIR=""
        fi
        temp_LIB=`basename $BLAS_LIB .a`
        BLAS_LIB=`basename $temp_LIB .so | sed -e 's/^lib//'`
    else
        BLAS_DIR="."
        BLAS_LIB="blas"
    fi

    # Check in default compiler locations
    PAC_CHECK_FORTRAN_LIB($BLAS_LIB, ddot, [AC_DEFINE(HAVE_LIBBLAS)], , [-L$BLAS_DIR $FLIBS])
    BLAS_LIB_CANONICAL=`echo $BLAS_LIB | sed 'y%./+-%__p_%'`

    # Check in PETSc distribution
    if eval "test \"`echo '$''{ac_cv_fortran_lib_'$BLAS_LIB_CANONICAL'_ddot}'`\" = no"; then
        BLAS_DIR="$PETSC_DIR/../blaslapack/lib/lib$BOPT/$PETSC_ARCH"
        PAC_CHECK_FORTRAN_LIB($BLAS_LIB, ddot, [AC_DEFINE(HAVE_LIBBLAS)], , [-L$BLAS_DIR $FLIBS])
    fi

    # End of tests using Fortran symbols from C
    if eval "test \"`echo '$''{ac_cv_fortran_lib_'$BLAS_LIB_CANONICAL'_ddot}'`\" = yes"; then
        ac_cv_lib_blas=yes;
    fi

    # Check for functions embedded in a system library like sunperf (which needs a stupid link line)
    if test "$ac_cv_lib_blas" = "no"; then
        save_LIBS="$LIBS"
        LIBS="$LIBS -lsunperf -xlic_lib=sunperf"
        AC_CHECK_FUNC(ddot, ac_cv_lib_blas_sunperf=yes, ac_cv_lib_blas_sunperf=no)
        if test "$ac_cv_lib_blas_sunperf" = "yes"; then
            ac_cv_lib_blas=yes
            ac_cv_lib_blas_ddot=yes
            BLAS_LIB="sunperf"
            BLAS_LIB_CANONICAL=`echo $BLAS_LIB | sed 'y%./+-%__p_%'`
            BLAS_DIR=""
            LDFLAGS="$LDFALGS -xlic_lib=sunperf"
        fi
        LIBS="$save_LIBS"
    fi

    if test "$ac_cv_lib_blas" = "yes"; then
        ifelse([$1], , [
            if test -n "$BLAS_LIB"; then
                BLAS_LIB_NAME="$BLAS_LIB"
                BLAS_LIB="-l$BLAS_LIB $FLIBS"
                EXTRA_LIBS="$BLAS_LIB $EXTRA_LIBS"
            fi
            if test -n "$BLAS_DIR"; then
                LDFLAGS="-L$BLAS_DIR $LDFLAGS"
                DYLIBPATH="$DYLIBPATH:$BLAS_DIR"
            fi
            AC_SUBST(BLAS_DIR) 
            AC_SUBST(BLAS_LIB)], [$1])
    else
        ifelse([$2], , :, [$2])
    fi

else

    ac_cv_lib_blas=no
    ifelse([$2], , :, [$2])
fi
]
)
# end of PAC_LIB_BLAS
#
# PAC_C_FORTRAN_NAMES([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# Check for the type of name mangling when linking Fortran functions in C
AC_DEFUN(PAC_C_FORTRAN_NAMES,
[AC_MSG_CHECKING(for Fortran external names)
AC_REQUIRE([AC_PROG_F77])
ac_cv_c_fortran_naming=yes
# First, compile a Fortran program
/bin/rm -f conff.f
cat > conff.f <<EOF
        subroutine d1chk()
        return
        end
EOF
if $FC -c conff.f >/dev/null 2>&1 ; then 
    :
else
    echo "configure: failed program was:" >&AC_FD_CC
    cat conff.f >&AC_FD_CC
    AC_MSG_ERROR([Could not compile Fortran routine!])
fi
# Now, build a C program and try to link with it
cat > conf.c <<EOF
main() {
d1chk_();
return 0;
}
EOF
if $CC -o conf conf.c conff.o $FLIBS >/dev/null 2>&1 ; then
    AC_DEFINE(PETSC_HAVE_FORTRAN_UNDERSCORE)
    ac_cv_c_fortran_naming_underscore=yes
    /bin/rm -f conf conf.c conff.f conff.o conf.o
    AC_MSG_RESULT(trailing underscore)
else
    /bin/rm -f conf conf.c conf.o
    cat > conf.c <<EOF
main() {
d1chk();
return 0;
}
EOF
    if $CC -o conf conf.c conff.o $FLIBS >/dev/null 2>&1 ; then 
        AC_DEFINE(PETSC_HAVE_FORTRAN_NOUNDERSCORE)
        ac_cv_c_fortran_naming_nounderscore=yes
        /bin/rm -f conf conf.c conff.f conff.o conf.o
        AC_MSG_RESULT(no underscore)
    else
        /bin/rm -f conf conf.c conf.o
        cat > conf.c <<EOF
main() {
D1CHK();
return 0;
}
EOF
        if $CC -o conf conf.c conff.o $FLIBS >/dev/null 2>&1 ; then 
            AC_DEFINE(PETSC_HAVE_FORTRAN_CAPS)
            ac_cv_c_fortran_naming_caps=yes
            /bin/rm -f conf conf.c conff.f conff.o conf.o
            AC_MSG_RESULT(uppercase)
        else
            ac_cv_c_fortran_naming=no
            AC_MSG_RESULT(unknown!)
        fi
    fi
fi

# Now check for underscore_underscore version - which is a special case
/bin/rm -f conf conf.c conf.o conff.f conff.o
cat > conf.c <<EOF
main() {
d1_chk__();
return 0;
}
EOF
cat > conff.f <<EOF
        subroutine d1_chk()
        return
        end
EOF
if $FC -c conff.f >/dev/null 2>&1 ; then 
    :
fi
if $CC -o conf conf.c conff.o $FLIBS >/dev/null 2>&1 ; then 
    AC_DEFINE(PETSC_HAVE_FORTRAN_UNDERSCORE_UNDERSCORE)
    ac_cv_c_fortran_naming_underscore_underscore=yes
    /bin/rm -f conf conf.c conff.f conff.o conf.o
    AC_MSG_RESULT(double underscore)
fi

if test "$ac_cv_c_fortran_naming" = "yes"; then
    ifelse([$1], , :, [$1])
else
    ifelse([$2], , :, [$2])
fi
/bin/rm -f conf conf.c conff.f conff.o conf.o
]
)
# end of PAC_C_FORTRAN_NAMES
#
# PAC_CHECK_FORTRAN_LIB(LIBRARY, FUNCTION [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES]]])
#
# Check for Fortran function in C
AC_DEFUN(PAC_CHECK_FORTRAN_LIB,
[AC_REQUIRE([PAC_C_FORTRAN_NAMES])
ac_fortran_lib_var=`echo $1['_']$2 | sed 'y%./+-%__p_%'`
eval ac_cv_fortran_lib_$ac_fortran_lib_var=no
if test "$ac_cv_c_fortran_naming" = "yes"; then
    # We unset the varaiables since the caching will happen at this level
    if test "$ac_cv_c_fortran_naming_nounderscore" = "yes"; then
        unset ac_cv_lib_$ac_fortran_lib_var
        AC_CHECK_LIB($1, $2, $3, $4, $5)
    elif test "$ac_cv_c_fortran_naming_underscore" = "yes"; then
        unset ac_cv_lib_${ac_fortran_lib_var}_
        AC_CHECK_LIB($1, $2_, $3, $4, $5)
    elif test "$ac_cv_c_fortran_naming_underscore_underscore" = "yes"; then
        unset ac_cv_lib_${ac_fortran_lib_var}__
        AC_CHECK_LIB($1, $2__, $3, $4, $5)
    elif test "$ac_cv_c_fortran_naming_caps" = "yes"; then
        ac_fortran_lib_var_caps=`echo $ac_fortran_lib_var | tr a-z A-Z`
        ac_func_caps=`echo $2 | tr a-z A-Z`
        eval unset ac_cv_lib_$ac_fortran_lib_var_caps
        AC_CHECK_LIB($1, $ac_func_caps, $3, $4, $5)
    else
        AC_MSG_ERROR("Invalid Fortran name mangling")
    fi
    if eval "test \"`echo '$''{ac_cv_lib_'$ac_lib_var'}'`\" = yes"; then
        eval ac_cv_fortran_lib_$ac_fortran_lib_var=yes
    fi
else
    AC_MSG_CHECKING([for $2 in -l$1])
    AC_MSG_ERROR([Unknown Fortran name mangling!])
fi
]
)
# end of PAC_CHECK_FORTRAN_LIB
#
# PAC_HELP_SECTION(SECTION-NAME)
#
# Check for Fortran function in C
AC_DEFUN(PAC_HELP_SECTION,
[AC_DIVERT_PUSH(AC_DIVERSION_NOTICE)dnl
ac_help="$ac_help
[$1]:"
AC_DIVERT_POP()
])
# end of PAC_HELP_SECTION
#
# PAC_CHECK_SIZEOF(TYPE, [CROSS-SIZE], [HEADER])
#
# Check the sizeof a type giving an optional header
AC_DEFUN(PAC_CHECK_SIZEOF,
[
changequote(<<, >>)dnl
dnl The name to #define.
define(<<AC_TYPE_NAME>>, translit(sizeof_$1, [a-z *], [A-Z_P]))dnl
dnl The cache variable name.
define(<<AC_CV_NAME>>, translit(ac_cv_sizeof_$1, [ *], [_p]))dnl
changequote([, ])dnl
AC_MSG_CHECKING(size of $1)
AC_CACHE_VAL(AC_CV_NAME,
[AC_TRY_RUN([#include <stdio.h>]
ifelse([$3], , , [#include $3])
[main()
{
  FILE *f=fopen("conftestval", "w");
  if (!f) exit(1);
  fprintf(f, "%d\n", sizeof($1));
  exit(0);
}], AC_CV_NAME=`cat conftestval`, AC_CV_NAME=0, ifelse([$2], , , AC_CV_NAME=$2))])dnl
AC_MSG_RESULT($AC_CV_NAME)
AC_DEFINE_UNQUOTED(AC_TYPE_NAME, $AC_CV_NAME)
undefine([AC_TYPE_NAME])dnl
undefine([AC_CV_NAME])dnl
]
)
# end of PAC_CHECK_SIZEOF
#
# PAC_TYPE_COMPLEX()
#
# Check for the std::complex type
AC_DEFUN(PAC_TYPE_COMPLEX,
[AC_MSG_CHECKING([std::complex type])
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_LINK([#include <complex>],
            [std::complex<double> x;],
            AC_MSG_RESULT([yes])
            ac_cv_type_std_complex="yes",
            AC_MSG_RESULT([no])
            ac_cv_type_std_complex="no")
if test "$ac_cv_type_std_complex" = "yes"; then
     AC_DEFINE(PETSC_USE_COMPLEX)
fi
AC_LANG_RESTORE
])
# end of PAC_TYPE_COMPLEX
#
# PAC_COMPILER_FLAGS()
#
# Retrieves the default flags for each compiler
AC_DEFUN(PAC_COMPILER_FLAGS, [
ac_config_options=$ac_aux_dir/config.options
# C options
CC_PROG=`echo $CC | sed -e 's/\ .*//'`
AC_MSG_CHECKING([for C compiler version])
if PETSC_CFLAGS_v=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CC_PROG v`; then
    c_version=`/bin/sh -c "exec $CC $PETSC_CFLAGS_v 2>&1 | head -1"`
else
    PETSC_CFLAGS_v=""
    c_version="Unknown"
fi
AC_MSG_RESULT([$c_version])
AC_MSG_CHECKING([for debug C compiler options])
if (test -n "$PETSC_CFLAGS_g") || PETSC_CFLAGS_g=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CC_PROG g`; then
    AC_MSG_RESULT([$PETSC_CFLAGS_g])
else
    PETSC_CFLAGS_g=""
    AC_MSG_WARN([can not guess debug options])
    AC_MSG_RESULT([none])
fi
AC_MSG_CHECKING([for optimized C compiler options])
if (test -n "$PETSC_CFLAGS_O") || PETSC_CFLAGS_O=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CC_PROG O`; then
    AC_MSG_RESULT([$PETSC_CFLAGS_O])
else
    PETSC_CFLAGS_O=""
    AC_MSG_WARN([can not guess optimized options])
    AC_MSG_RESULT([none])
fi
# Fortran options
FC_PROG=`echo $FC | sed -e 's/\ .*//'`
AC_MSG_CHECKING([for Fortran compiler version])
if PETSC_FFLAGS_v=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $FC_PROG v`; then
    f_version=`/bin/sh -c "exec $FC $PETSC_FFLAGS_v 2>&1 | head -1"`
else
    PETSC_FFLAGS_v=""
    f_version="Unknown"
fi
AC_MSG_RESULT([$f_version])
AC_MSG_CHECKING([for debug Fortran compiler options])
if (test -n "$PETSC_FFLAGS_g") || PETSC_FFLAGS_g=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $FC_PROG g`; then
    AC_MSG_RESULT([$PETSC_FFLAGS_g])
else
    PETSC_FFLAGS_g=""
    AC_MSG_WARN([can not guess debug options])
    AC_MSG_RESULT([none])
fi
AC_MSG_CHECKING([for optimized Fortran compiler options])
if (test -n "$PETSC_FFLAGS_O") || PETSC_FFLAGS_O=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $FC_PROG O`; then
    AC_MSG_RESULT([$PETSC_FFLAGS_O])
else
    PETSC_FFLAGS_O=""
    AC_MSG_WARN([can not guess optimized options])
    AC_MSG_RESULT([none])
fi
# C++ options
CXX_PROG=`echo $CXX | sed -e 's/\ .*//'`
FC_PROG=`echo $FC | sed -e 's/\ .*//'`
AC_MSG_CHECKING([for C++ compiler version])
if PETSC_CXXFLAGS_v=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CXX_PROG v`; then
    cxx_version=`/bin/sh -c "exec $CXX $PETSC_CXXFLAGS_v 2>&1 | head -1"`
else
    PETSC_CXXFLAGS_v=""
    cxx_version="Unknown"
fi
AC_MSG_RESULT([$c_version])
AC_MSG_CHECKING([for debug C++ compiler options])
if (test -n "$PETSC_CXXFLAGS_g") || PETSC_CXXFLAGS_g=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CXX_PROG g`; then
    AC_MSG_RESULT([$PETSC_CXXFLAGS_g])
else
    PETSC_CXXFLAGS_g=""
    AC_MSG_WARN([can not guess debug options])
    AC_MSG_RESULT([none])
fi
AC_MSG_CHECKING([for optimized C++ compiler options])
if (test -n "$PETSC_CXXFLAGS_O") || PETSC_CXXFLAGS_O=`${CONFIG_SHELL-/bin/sh} $ac_config_options $host $CXX_PROG O`; then
    AC_MSG_RESULT([$PETSC_CXXFLAGS_O])
else
    PETSC_CXXFLAGS_O=""
    AC_MSG_WARN([can not guess optimized options])
    AC_MSG_RESULT([none])
fi
AC_SUBST(PETSC_CFLAGS_g)
AC_SUBST(PETSC_CFLAGS_O)
AC_SUBST(PETSC_FFLAGS_g)
AC_SUBST(PETSC_FFLAGS_O)
AC_SUBST(PETSC_CXXFLAGS_g)
AC_SUBST(PETSC_CXXFLAGS_O)
])
# end of PAC_COMPILER_FLAGS
#
# PAC_COMPILER_CXX_NAMESPACE()
#
# Defines PETSC_HAVE_CXX_NAMESPACE if the C++ compiler supports namespaces
AC_DEFUN(PAC_COMPILER_CXX_NAMESPACE, [
AC_REQUIRE([AC_PROG_CXX])
AC_CACHE_CHECK([that C++ compiler supports namespaces],
ac_cv_compiler_cxx_namespace, [
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE([namespace petsc {int dummy;}], [], ac_cv_compiler_cxx_namespace="yes", ac_cv_compiler_cxx_namespace="no")
if test "$ac_cv_compiler_cxx_namespace" = "yes" ; then
    AC_DEFINE(PETSC_HAVE_CXX_NAMESPACE)
fi
AC_LANG_RESTORE
])
])
# end of PAC_COMPILER_CXX_NAMESPACE
#
# UNTESTED MACROS FROM BILL
#
dnl
dnl Check that a function prototype will work.  This is used to handle
dnl the various variants in such things as "select" and "connect" (!)
dnl The need to do this is one of the reasons that Window NT will win.
dnl
dnl AC_CHECK_PROTOTYPE(foo(int,...),action-if-corrent,action-if-fails)
define(AC_CHECK_PROTOTYPE,[
AC_TRY_COMPILE($1,return 1;,$2,$3)
])
dnl
dnl
dnl PAC_CHECK_COMPILER_OPTION(optionname,action-if-ok,action-if-fail)
dnl This should actually check that compiler doesn't complain about it either,
dnl by compiling the same program with two options, and diff'ing the output.
dnl
define([PAC_CHECK_COMPILER_OPTION],[
AC_MSG_CHECKING([that C compiler accepts option $1])
CFLAGSSAV="$CFLAGS"
CFLAGS="$1 $CFLAGS"
echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} $CFLAGS -c conftest.c 2>&1`"; then
  AC_MSG_RESULT(yes)
  $2
else
  AC_MSG_RESULT(no)
  $3
fi
rm -f conftest*
CFLAGS="$CFLAGSSAV"
])
dnl
dnl PAC_CHECK_FC_COMPILER_OPTION is like PAC_CHECK_COMPILER_OPTION,
dnl except for Fortran 
define([PAC_CHECK_FC_COMPILER_OPTION],[
AC_MSG_CHECKING([that Fortran compiler accepts option $1])
FFLAGSSAV="$FFLAGS"
FFLAGS="$1 $FFLAGS"
cat >conftest.f <<EOF
        program main
        end
EOF
/bin/rm -f conftest1.out conftest2.out
if $FC $FFLAGS -c conftest.f > conftest1.out 2>&1 ; then
    if $FC $FFLAGSSAV -c conftest.f > conftest2.out 2>&1 ; then
        if diff conftest2.out conftest1.out ; then
            AC_MSG_RESULT(yes)
            $2
	else
            AC_MSG_RESULT(no)
            cat conftest2.out >> config.log
            $3
	fi
    else
        AC_MSG_RESULT(no)
        cat conftest2.out >> config.log
        $3
    fi
else
    AC_MSG_RESULT(no)
    cat conftest1.out >> config.log
    $3
fi
rm -f conftest*
FFLAGS="$FFLAGSSAV"
])
dnl PAC_MACRO_NAME_IN_MACRO([action if ok],[action if failed])
dnl
dnl Note that we can't put a pound sign into the msg_checking macro because
dnl it confuses autoconf
AC_DEFUN([PAC_MACRO_NAME_IN_MACRO],
[AC_REQUIRE([AC_PROG_CC])dnl
AC_CACHE_CHECK([that compiler allows recursive definitions],
ac_cv_prog_cpp_recursive,
[AC_TRY_COMPILE([
void a(i,j)int i,j;{}
#define a(b) a(b,__LINE__)],[
a(0);return 0;],ac_cv_prog_cpp_recursive="yes",ac_cv_prog_cpp_recursive="no")])
if test $ac_cv_prog_cpp_recursive = "yes" ; then
    ifelse([$1],,:,[$1])
else
    ifelse([$2],,:,[$2])
fi
])
