#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: grid1d.c,v 1.31 2000/07/16 23:20:01 knepley Exp $";
#endif

/* Implements 1d triangular grids */
#include "petscts.h"
#include "gsolver.h"
#include "src/grid/gridimpl.h"                 /*I "grid.h" I*/
#include "src/mesh/impls/triangular/triimpl.h"
#include "src/grid/impls/triangular/2d/grid2d.h"
#include "src/grid/impls/triangular/2d/elemvec2d.h"
#include "src/grid/impls/triangular/2d/varorder2d.h"
#include "src/gvec/impls/triangular/2d/gvec2d.h"
#include "src/gvec/impls/triangular/2d/gmat2d.h"

static struct _GridOps GOps = {GridSetUp_Triangular_2D,
                               GridSetupBoundary_Triangular_2D,
                               GridSetupConstraints_Triangular_2D,
                               GridSetupGhostScatter_Triangular_2D,
                               PETSC_NULL/* GridSetFromOptions */,
                               PETSC_NULL/* GridDuplicate */,
                               PETSC_NULL/* GridReform */,
                               PETSC_NULL/* GridCopy */,
                               GridDestroy_Triangular_2D,
                               GridView_Triangular_2D,
                               GridGetBoundaryStart_Triangular_2D,
                               GridGetBoundaryNext_Triangular_2D,
                               GridReformMesh_Triangular_2D,
                               GridCreateGMat_Triangular_2D,
                               GridCreateVarOrdering_Triangular_2D,
                               GridCreateLocalVarOrdering_Triangular_2D,
                               GridCreateVarScatter_Triangular_2D,
                               GridVarOrderingConstrain_Triangular_2D,
                               GridCalcElementVecIndices_Triangular_2D,
                               GridCalcElementMatIndices_Triangular_2D,
                               PETSC_NULL/* GridCalcBoundaryElementVecIndices_Triangular_1D */,
                               PETSC_NULL/* GridCalcBoundaryElementMatIndices_Triangular_1D */,
                               GridProjectElementVec_Triangular_2D,
                               GVecGetLocalGVec_Triangular_2D,
                               GVecRestoreLocalGVec_Triangular_2D,
                               0,/* GVecGetWorkGVec */
                               0,/* GVecRestoreWorkGVec */
                               GVecGlobalToLocal_Triangular_2D,
                               GVecLocalToGlobal_Triangular_2D,
                               PETSC_NULL/* GVecView_Triangular_1D */,
                               GridCreateRestriction_Triangular_2D,
                               GVecEvaluateFunction_Triangular_2D,
                               PETSC_NULL/* GVecEvaluateFunctionBoundary_Triangular_1D */,
                               GVecEvaluateFunctionCollective_Triangular_2D,
                               GVecEvaluateFunctionGalerkin_Triangular_2D,
                               GVecEvaluateFunctionGalerkinCollective_Triangular_2D,
                               PETSC_NULL/* GVecEvaluateBoundaryFunctionGalerkin_Triangular_1D */,
                               PETSC_NULL/* GVecEvaluateBoundaryFunctionGalerkinCollective_Triangular_1D */,
                               GVecEvaluateOperatorGalerkin_Triangular_2D,
                               GVecEvaluateNonlinearOperatorGalerkin_Triangular_2D,
                               GVecEvaluateSystemMatrix_Triangular_2D,
                               GVecEvaluateSystemMatrixDiagonal_Triangular_2D,
                               GMatView_Triangular_2D,
                               GMatEvaluateOperatorGalerkin_Triangular_2D,
                               GMatEvaluateALEOperatorGalerkin_Triangular_2D,
                               GMatEvaluateALEConstrainedOperatorGalerkin_Triangular_2D,
                               PETSC_NULL/* GMatEvaluateBoundaryOperatorGalerkin_Triangular_1D */,
                               GridEvaluateRhs_Triangular_2D,
                               GridEvaluateSystemMatrix_Triangular_2D};

EXTERN_C_BEGIN
#undef  __FUNCT__
#define __FUNCT__ "GridCreate_Triangular_1D"
int GridCreate_Triangular_1D(Grid grid) {
  int ierr;

  PetscFunctionBegin;
  ierr = PetscMemcpy(grid->ops, &GOps, sizeof(struct _GridOps));                                          CHKERRQ(ierr);
  /* General grid description */
  grid->dim  = 1;
  grid->data = PETSC_NULL;
  PetscFunctionReturn(0);
}
EXTERN_C_END
