#
# Copyright (C) 2001-2003 Hewlett-Packard Co
# Contributed by Stephane Eranian <eranian@hpl.hp.com>
#
# This file is part of pfmon, a sample tool to measure performance 
# of applications on Linux/ia64.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA
#

#
# This file defines the global compilation settings.
# It is included by every Makefile
#
#

#
# Where should things go in the end. the package will put things in lib and
# bin under this base.
#
# DESTDIR : the root directory used to install the binaries into
# DESTROOT: the root directory once package is installed
#
# Both directories are different when source is built for inclusion into
# a package because typically a fake root is used
#
DESTDIR=/usr/local
DESTROOT=/usr/local

#
# The root directory where to find the perfmon header files and the library (libpfm-3.0).
# Must be an absolute path.
#
# pfmon will look into $(LIBPFMDIR)/include and $(LIBPFMDIR)/lib
#
PFMROOTDIR=/usr/local

#
# PMU support for pfmon
#
CONFIG_PFMON_GENERIC_IA64=y
CONFIG_PFMON_ITANIUM=y
CONFIG_PFMON_ITANIUM2=y

# 
# sampling module configuration
# Note that not all modules work 
# with every possible PMU or events
#
CONFIG_PFMON_SMPL_MOD_RAW_IA64=y
CONFIG_PFMON_SMPL_MOD_COMPACT_IA64=y
CONFIG_PFMON_SMPL_MOD_DET_ITA=y
CONFIG_PFMON_SMPL_MOD_BTB_IA64=y
CONFIG_PFMON_SMPL_MOD_EXAMPLE_IA64=y
CONFIG_PFMON_SMPL_MOD_DET_ITA2=y

#
# pfmon debugging option
# 
# CONFIG_PFMON_DEBUG: enables extraneous debug print
# CONFIG_PFMON_LIBUNWIND: if you have libunwind installed, 
# then you can enable this option for call stack on segv
#
CONFIG_PFMON_DEBUG=y
CONFIG_PFMON_LIBUNWIND=n

#
# optimization settings
#
OPTIM= -O2

#
# linker specific flags
#
# Caution: linking static will cause warnings in pfmon_conf.c due
# to the use of getpwuid() which requires pam; a dynamically loaded library.
# This should work as long as the program is run on the system it was compiled
# from or on a system with the same dynamic loader version
#
# 
LDFLAGS=

#
# you shouldn't have to touch anything beyond this point
#

#
# The entire package can be compiled using 
# ecc the Intel Itanium Compiler (beta 6.0)
#
#CC=icc -Wall
CC=gcc -Wall

CFLAGS=$(OPTIM) -g $(CONFIG_FLAGS) -D_REENTRANT
MKDEP=makedepend

LIBS=
INSTALL=install

PFMINCDIR=$(PFMROOTDIR)/include
PFMLIBDIR=$(PFMROOTDIR)/lib
