# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

"""
Store internally as a string.
Provide validation routines.
"""
import os
import Image
from formField import files_dictionary, Form, ImageReadFileField
from pil import image_open, extract_info_pil
from translation import new
from config import PATHS

def init():
    pass
    
def pil(image):
    return image

class Action(Form):
    all_layers  = False
    pil         = staticmethod(pil)
    author      = 'Stani'
    cache       = False
    dpi         = new('dpi')
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    version     = '0.1'
    tags        = []
    update_size = False
    __doc__     = 'Action base class.'
    
    def values(self,info,pixel_fields={}):
        return self.get_fields(info,convert=True,pixel_fields=pixel_fields)
    
    def apply(self,photo,setting,cache):
        """Can be overwritten always returns the photo"""
        values  = self.values(photo.get_info())
        if self.cache: values['cache'] = cache
        if self.all_layers:
            photo = photo.apply_all_pil(self.pil,**values)
        else:
            photo = photo.apply_pil(self.pil,**values)
        if self.update_size:
            return photo.update_size()
        return photo

    def apply_pil(self,image): 
        return self.pil(image,**self.values(extract_info_pil(image)))
    
    def rename(self,values,old,new):
        values[new] = values[old]
        del values[old]
    
    def is_done(self,photo):
        """Method used for resuming when a batch was interrupted. C
        Check if this image has been done already."""
        #get info
        info                        = photo.get_info_original()
        #check if there are not forbidden tags (new.*)
        try:
            folder, filename, typ   = self.is_done_info(info)
        except KeyError:
            return False
        #check if file exists
        if not os.path.exists(filename):
            return False
        #check if file is valid
        try:
            Image.open(filename)
            return True
        except:
            return False
        
    def is_valid_last_action(self):
        return hasattr(self,'is_done_info')
    
    #---do
    def apply_to_current_layer_image(self,photo,method,*args,**keyw):
        layer       = photo.get_layer()
        layer.image = method(layer.image,*args,**keyw) #PIL Image
        photo.set_size(layer.image.size)
        return photo

    #field classes which are specific to Phatch and do not belong to formField
    class MaskFileField(ImageReadFileField):
        def init_dictionary(self):
            self.dictionary     = files_dictionary(
                paths       = [
                    os.path.join(PATHS["PHATCH_IMAGE_PATH"],'masks'),
                    PATHS["USER_MASKS_PATH"],
                ],
                extensions  = self.extensions)
            
    class WatermarkFileField(ImageReadFileField):
        def init_dictionary(self):
            self.dictionary     = files_dictionary(
                paths       = [
                    PATHS["PHATCH_IMAGE_PATH"],
                    PATHS["USER_WATERMARKS_PATH"],
                ],
                extensions  = self.extensions)
            
