<?php
  /**************************************************************************\
  * phpGroupWare Module (Napster)                                            *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * Based on WebNap Client copyright 2000                                    *
  * Written by Aakash Kambuj <aakash@idearing.com>                           *
  *            Kalpak Kothari <kalpak@idearing.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  * --------------------------------------------                             *
  * Napster is a registered trademark of Napster Inc  http://www.napster.com *
  \**************************************************************************/

  /* $Id: class.songs.inc.php,v 1.1 2001/09/28 22:46:41 milosch Exp $ */

	class Song
	{
		var $user= '';
		var $title= '';
		var $filename= '';
		var $checksum= '';
		var $size=0;
		var $bitrate=0;
		var $frequency=0;
		var $time=0;
		var $nick= '';
		var $nick_ip = '';
		var $conn_speed = 0;
		var $firewall = 0;

		function init_song($str, $type)
		{
			if($type)
			{  // type == 1 => browse response packet
				list($this->nick, $title_noquotes, $info) = explode('"', $str);
				$this->title = '"' . $title_noquotes . '"';

				$info = substr($info, 1);
				list($this->checksum, $this->size, $this->bitrate, $this->frequency, $this->time) = explode(" ", $info);

				$temp = strrchr($this->title, '\\');
				if (!$temp)
				{
					$this->filename = $this->title;
				}
				else
				{
					$this->filename = substr($temp, 1, strlen($temp)-2);
				}

				//      $this->time = (int)(((int)$this->time)/60) . ":" . sprintf("%02d", ((int)$this->time)%60);
				$this->frequency /= 1000;
			}
			else
			{
				//first, get the pathname of the song
				for ($i=(strlen($str)-1);$i>=0 && strcmp($str[$i], '"')!=0;$i--);
				{
					$this->title = substr($str,0,$i+1);
				}

				$info = substr($str, $i+2);
				list($this->checksum, $this->size, $this->bitrate, $this->frequency, $this->time, $this->nick, $this->nick_ip, $this->conn_speed) = explode(" ", $info);

				//now get song name
				$temp = strrchr($this->title, '\\');
				if (!$temp)
				{
					$this->filename = $this->title;
				}
				else
				{
					$this->filename = substr($temp, 1, strlen($temp)-2);
				}

				// $this->time = (int)(((int)$this->time)/60) . ":" . sprintf("%02d", ((int)$this->time)%60);
				$this->frequency /= 1000;
			}
		}

		function shorten($s)
		{
			if((strlen($s)>46) && (!strrchr(substr($s,46), " ")))
			{
				if(strpos(substr($s,46),"_"))
				{
					return shorten(str_replace("_", " ", $s));
				}
				elseif(strlen($s)>46)
				{
					return substr($s, 0, 45) . "-<br>" . substr($s, 45);
				}
				else
				{
					return $s;
				}
			}
			else
			{
				return $s;
			}
		}

		function print_song($type)
		{
			global $napster;
			global $keywords;
			global $FORMPOST;
			/*
			  $max, $nofirewall, $bdlynx;
			*/ 
			$title = urlencode(serialize($this->title));
			$nick = urlencode(serialize($this->nick));
			// $filenamestr = str_replace(" ", "_", $this->filename);

			switch($type)
			{
				case 0: 
					$col0 = $this->print_speed($this->conn_speed);
					$col1 = $this->print_time();
					$col2 = $this->print_size();
					$col3 = $this->bitrate." kbps";
					$col4 = $this->frequency." kHz";
					break;
				case 1: 
					$col2 = $this->print_speed($this->conn_speed);
					$col1 = $this->print_time();
					$col0 = $this->print_size();
					$col3 = $this->bitrate." kbps";
					$col4 = $this->frequency." kHz";
					break;
				case 2: 
					$col1 = $this->print_speed($this->conn_speed);
					$col0 = $this->print_time();
					$col2 = $this->print_size();
					$col3 = $this->bitrate." kbps";
					$col4 = $this->frequency." kHz";
					break;
				case 3: 
					$col3 = $this->print_speed($this->conn_speed);
					$col1 = $this->print_time();
					$col2 = $this->print_size();
					$col0 = $this->bitrate." kbps";
					$col4 = $this->frequency." kHz";
					break;
				case 4: 
					$col4 = $this->print_speed($this->conn_speed);
					$col1 = $this->print_time();
					$col2 = $this->print_size();
					$col3 = $this->bitrate." kbps";
					$col0 = $this->frequency." kHz";
					break;
				default:
					$col0 = $this->print_speed($this->conn_speed);
					$col1 = $this->print_time();
					$col2 = $this->print_size();
					$col3 = $this->bitrate." kbps";
					$col4 = $this->frequency." kHz";
					break;
			}

			if($FORMPOST)
			{
				echo "<td width=\"30\" valign=\"top\"><form method=\"post\" action=\"".$GLOBALS['phpgw']->link("download.php")."\">"
				. "<input type=\"hidden\" name=\"napserver\" value=\"".$napster->napserver."\">"
				. "<input type=\"hidden\" name=\"title\" value=\"$title\">"
				. "<input type=\"hidden\" name=\"nick\" value=\"$nick\">"
				//	 . "<input type=\"hidden\" name=\"pport\" value=\"".$napster->pport."\">"
				. "<input type=\"submit\" value=\"Get\"></td>\n";
			}

			$rurl3= $GLOBALS['phpgw']->link($GLOBALS['phpgw_info']["webserver_url"]
				."/"
				.$GLOBALS['phpgw_info']["server"]["currentapp"]
				."/queue.php","napserver=".$napster->napserver."&nick=$nick&title=$title&mpsize=".$this->size);

			$idrive = $rurl3 . "&affil=1";
			$myplay = $rurl3 . "&affil=2";
			$freedrive = $rurl3 . "&affil=3";

			echo "<td valign=\"center\" width=\"400\">";
			if($FORMPOST)
			{
				echo "</form>";
			}

			//    if($bdlynx)
			//      print("/$filenamestr");
			echo "<a href=\""
				. $GLOBALS['phpgw']->link("download.php",
				"napserver=".$napster->napserver."&nick=$nick&title=$title")
				. "\">".$this->shorten($this->filename)."</a>\n<br>"
				. "<a href=\"$myplay\">[myplay]</a>&nbsp;"
				. "<a href=\"$idrive\">[i-drive]</a>&nbsp;"
				. "<a href=\"$freedrive\">[freedrive]</a>&nbsp;</td>\n"
				. "<td valign=\"center\" width=\"75\" align=\"center\">$col0</td>\n"
				. "<td valign=\"center\" width=\"120\" align=\"center\">\n"
				. "<table width=\"120\" border=\"0\" cellpadding=\"1\" "
				. "cellspacing=\"2\"><tr>\n"
				. "<td width=\"60\" align=\"left\">$col1</td>"
				. "<td width=\"60\" align=\"right\">$col2</td>"
				. "<tr><td width=\"60\" align=\"left\">$col3</td>"
				. "<td width=\"60\" align=\"right\">$col4</td></tr></table>\n"
				. "</td>\n<td valign=\"center\" align=\"center\" width=\"150\">";

			if ($this->firewall)
			{
				echo "<font color=\"red\">";
			}

			echo "<a href=\"".$GLOBALS['phpgw']->link("searchmp3.php",
				"napserver=".$napster->napserver."&nick=".$this->nick
				."&conn_speed=".$this->conn_speed
				."&linespeed=".$napster->linespeed
				."&linktype=".$napster->linktype
				."&nofirewall=".$napster->nofirewall
				."&keywords=$keywords")."\">[".$this->nick."]";

			if ($this->firewall)
			{
				echo "</font>";
				echo "</a></td>";
			}
		}

		function print_time()
		{
			return (int)(((int)$this->time)/60).":".sprintf("%02d", ((int)$this->time)%60);
		}

		function print_size()
		{
			return number_format($this->size);
		}

		function print_speed($a)
		{
			// pretty-print connection speed
			switch($a)
			{
				case 0: return "??";   break;
				case 1: return "14.4K";break;
				case 2: return "28.8K";break;
				case 3: return "33.6K";break;
				case 4: return "56K";  break;
				case 5: return "64K";  break;
				case 6: return "128K"; break;
				case 7: return "Cable";break;
				case 8: return "DSL";  break;
				case 9: return "T1";   break;
				case 10:return "T3";   break;
				default:return "??";   break;
			}
		}
	}
?>
