<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	class syncml_device
	{
		var $name;
		var $capabilities;
		var $server_last_sync;
		var $client_last_sync;
		var $client_next_sync;

		/********************************************************************\
		* Define a new SyncML device                                         *
		\********************************************************************/
		function syncml_device($name)
		{
			global $phpgw;

			$this->name = $name;
			
			/* Read settings from database */
			$phpgw->db->query ('select * from phpgw_syncml_device where device_name = "' . $name . '";');

			if ( $phpgw->db->num_rows() == 0 )
			{
				/* We've never seen this device before, add it */
				$phpgw->db->free();
				$phpgw->db->query ('insert into phpgw_syncml_device (name, owner) values ("' . $name . '", "' . $phpgw_info['user']['userid'] . '");' );
				$phpgw->db->free();
			}
			else
			{
				/* Known device, load it from the database */
				$array = $phpgw->db->next_record();
				$capabilities = unserialize ( $array['capabilities'] );
				$server_last_sync = $array['server_last_sync'];
				$client_last_sync = $array['client_last_sync'];
			}
			$phpgw->db->free();
		
		}
	
		/********************************************************************\
		* Save the device to the database                                    *
		\********************************************************************/
		function save()
		{
			global $phpgw;

			$serial_capabilities = serialize( $this->capabilities);
			
			$query = 'Update phpgw_syncml_device set ' . 
				'capabilities = "' . $serial_capabilities . 
				'" , server_last_sync = "' . $server_last_sync .
				'" , client_last_sync = "' . $client_last_sync . '";';

			$phpgw->db->query ( $query );
			$phpgw->db->free ();
		}
	}

?>
