<?php

$phpgw_info['flags']['currentapp']='wcm';
$phpgw_info['flags']['noheader']=True;
include("../header.inc.php");

$temp_memberships = $phpgw->accounts->memberships($phpgw_info['user']['account_id']);

/**
 * The backbone of the admin side.
 *
 * This is the backbone of the admin side. It includes all files 
 * needed for the admin functions under the "Include Files" section 
 * and all operations are function driven by "The Switch" statement at 
 * the bottom. 
 *
 * @module admin
 * @modulegroup administration
 * @package phpWebSite
 */
$temp_admin = $current_admin;

/**
 * This file is currently used for an uploading feature on the topics
 * page but will soon be replaced with different code.
 */
//require("fileupload.class");

/**
 * Contains configuration variables for phpWebSite.
 */
include("config.php");

//IF mainfile has not been included THEN include it.
if (!IsSet($mainfile)) {
  /**
   * The core function definitions
   */
  include ("mainfile.php");
}

/**
 * Used to authorize the username and password of an incoming
 * administrator.
 */
include("auth.inc.php");
/**
 * Gives all page creation and editing functions for the main page.
 */

include("mainpage.php");
/**
 * Gives all page creation and editing functions for new user pages.
 */
include("./admin/userpage.php");
/**
 * Web Links functions for search engine.
 */
include("./admin/web_links.php");
/**
 * Referrer functions to see who is linking to the site.
 */
include("./admin/referer.php");
/**
 * Functions for creating and editing topics.
 */
include("./admin/topics_admin.php");
/**
 * Functions for editing LEFT, RIGHT, and ADMIN tables/blocks.
 */
include("./admin/blocks.php");
/**
 * Functions for creating and editing news/announcments and comments.
 */
include("./admin/news.php");
/**
 * Used for editing users and administrators for the web site.
 */
include("./admin/user_admin.php");
/**
 * Administration functions for polls/surveys.
 */
include("./admin/poll_admin.php");
/**
 * Used for editing menu items.
 */
include("./admin/menu_edit.php");
/**
 * Banner functions for administration of banners.
 */
include("./admin/banners_admin.php");
/**
 * Used for modification of help.
 */
include("./admin/help_admin.php");

/**
 * Generates the login form.
 *
 * This function takes in the admin username and password and passes
 * them back to admin.php for verification.
 *
 * @author unknown (a phpNuke developer)
 */
function login()
{
  /**
   * Generates the page header
   */
	include ("header.php");

    $box_title = lang("Administrative Login");
	$box_stuff = "<form action=\"admin.php\" method=\"post\">
	" . lang("AdminID") . "&nbsp;&nbsp;
	<input type=\"text\" name=\"current_admin\" size=\"20\" maxlength=\"20\" /><br />
	" . lang("Password") . "&nbsp;&nbsp;
	<input type=\"password\" name=\"pwd\" size=\"20\" maxlength=\"18\" />
	<input type=\"hidden\" name=\"op\" value=\"login\" /><br />
	<input type=\"submit\" value=\"" . lang("Login") . "\" /></form>
	";

	themesidebox($box_title, $box_stuff);
  /**
   * Generates the page footer
   */
	include ("footer.php");
}

/**
 * Displays the admin menu or a link to the admin based on the flag param.

 * @param boolean
 * @author unknown (a phpNuke developer)
 */
function GraphicAdmin($flag)
{
	include ("config.php");
	global $phpgw;
	//Only show icons on MAIN admin page. (increases readability).
	if(!$flag)
	{
		echo "<div style=\"text-align : center\"><a href=\"admin.php\">" . lang("Back to Admin Menu") . "</a></div>";
		if(!$banners) echo "<br />";
		return;
	}

	$box_title = lang("Administration Home");
		$box_title .= help("admin");
	checkversion($notify_version);
	$box_stuff = "
<table cellspacing=\"4\" cellpadding=\"2\" border=\"0\" width=\"99%\">
$notify_version
<tr>
	<td class=\"type5\" valign=\"top\" width=\"33%\">
	<span class=\"onebiggerred\"><b>" . lang("Blocks") . "</b></span><br />
	<a href=\"admin.php?op=main_page_data\">" . lang("Main Page Content") . "</a><br />
	";

	if($banners)
		$box_stuff .= "
	<a href=\"admin.php?op=BannersAdmin\">" . lang("Banners Administration") . "</a><br />
		";

	$box_stuff .= "
	<a href=\"admin.php?op=edit_menu\">" . lang("Edit Main Menu") . "</a><br />
	<a href=\"admin.php?op=lblocks\">" . lang("Left Blocks") ."</a><br />
	<a href=\"admin.php?op=rblocks\">" . lang("Right Blocks") . "</a><br /><br />
	</td>
	<td class=\"type5\" valign=\"top\" width=\"33%\">
	<span class=\"onebiggerred\"><b>" . lang("Content") . "</b></span><br />
	<a href=\"admin.php?op=adminStory\">" . lang("New Article") . "</a><br />
	<a href=\"admin.php?op=topicsmanager\">" . lang("Topics Manager") . "</a><br />
	<a href=\"admin.php?op=get_page_data\">" . lang("Create New Page") . "</a><br />
	<a href=\"admin.php?op=list_user_pages\">" . lang("Edit User Page") . "</a><br />
	<a href=\"admin.php?op=links\">" . lang("Web Links") . "</a><br />
	<a href=\"admin.php?op=create\">" . lang("Surveys/Polls") . "</a><br />
	</td>
	<td class=\"type5\" valign=\"top\" width=\"33%\">
	<span class=\"onebiggerred\"><b>" . lang("Access / Stats") . "</b></span><br />
	<a href=\"admin.php?op=mod_users\">" . lang("Edit Internet Users") ."</a><br />
	<a href=\"top.php\">" . lang("Top 10") ."</a><br />
	<a href=\"stats.php\">" . lang("Client Stats") . "</a><br /><br />
	</td>
</tr>
</table>
	";
themesidebox($box_title, $box_stuff);

//BEGIN CODE FOR PLUG-IN ADMIN

	$phpgw->db->query ("select * from wcm_plugins");

	if ($phpgw->db->num_rows() > 0)
	{
		$count=0;
		$box_title = "Plug-Ins";
		$box_content = "
<table cellspacing=\"4\" cellpadding=\"6\" border=\"0\">
<tr>
		";
		
		while ($phpgw->db->next_record())
		{
			if ($count > 4)
			{
				$box_content .= "</tr><tr>";
				$count = 0;
			}

			extract($row);
			$box_content .= "
	<td align=\"center\" valign=\"bottom\">
	<a href=\"./$source_file?plug_id=$plug_id&amp;op=$admin_inc\">";
	$imagehw = GetImageSize("./plug-ins/$plug_dir/$img");
	$image_size = $imagehw[3];
	$box_content .= "<img src=\"./plug-ins/$plug_dir/$img\" $image_size alt=\"$about\"  border=\"0\" /></a><br />$name
	</td>";
			$count++;
		}
		if ($phpgw->db->num_rows() > 5){
			while ($count < 5){
				$box_content .= "<td>&nbsp;</td>";
				$count++;
			}
		}
		$box_content .= "</tr></table>";
		themesidebox($box_title, $box_content);
	}
//END CODE FOR PLUG-IN ADMIN

}

/**
 * Checks the version and displays if an update is avalable.
 *
 * @param string Reference to result string.
 * @author Jeremy Agee
 */
function checkversion($notify_version)
{
    include("config.php");
    include("version.php");

	if($check_version)
	{
		$file = fopen("http://phpwebsite.appstate.edu/downloads/curent_version.php", "r");

		if (!$file)
		{
			$notify_version = lang("Unable to open the version file at phpwebsite.appstate.edu.");
		}
		else
		{
			while (!feof ($file))
			{
				$line = fgets ($file, 1024);
			}
			$remote_version = split("_", $line);
			$local_version = split("_", $wcm_version);
			if($remote_version[0] <= $local_version[0])
				if($remote_version[1] <= $local_version[1])
					if($remote_version[2] <= $local_version[2])
						$notify_version = "";
			else
				$notify_version = "
<tr>
        <td class=\"type5\" valign=\"top\" width=\"50%\">
        <span class=\"onebiggerred\"><b>". lang("phpWebSite Update") . "</b></span><br />
	" . lang("You are running version") . " $local_version[0].$local_version[1].$local_version[2]<br />
	" . lang("The curent version is") . " $remote_version[0].$remote_version[1].$remote_version[2]<br />
        <a href=\"http://phpwebsite.appstate.edu/content.php?menu=1300&page_id=10\">" . lang("Download update") . "</a><br />
        </td>
        <td class=\"type5\" valign=\"top\" width=\"50%\">
	</td>
</tr>
						"; 
			fclose($file);
		}
	}
}

/**
 * Displays the main admin page.
 *
 * @author unknown (a phpNuke developer)
*/
function adminMain()
{
	global $admintest;
	global $phpgw,$phpgw_info;
	$phpgw->common->phpgw_header();
	include ("header.php");

	$db2 = $phpgw->db;

	GraphicAdmin(1);
	
	$box_title = lang("Article Administration");
	$dummy = 0;
	$phpgw->db->query("SELECT qid, subject, timestamp FROM wcm_queue order by timestamp");
	
	if($phpgw->db->num_rows() < 1)
	$box_stuff = "<span class=\"onebiggerred\">&gt;</span>&nbsp;&nbsp;" . lang("No New Submissions") . "<br />";
	else
	{
		$box_stuff = "<span class=\"onebiggerred\">" .lang("New Submissions!") . "</span><br /><br />
<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"99%\">
		";

		while ($phpgw->db->next_record())
		{
			$qid=$phpgw->db->f('qid');
			$subject=$phpgw->db->f('subject');
			$timestamp=$phpgw->db->f('timestamp');
			$hour = "AM";
			ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $timestamp, $datetime);
			
			if ($datetime[4] > 12)
			$datetime[4] = $datetime[4]-12; $hour = "PM";

			$datetime = date("%A, %B %d @ %T %Z", mktime($datetime[4],$datetime[5],$datetime[6],$datetime[2],$datetime[3],$datetime[1]));
			$box_stuff .= "
<tr>
	<td class=\"type5\"><b>$subject</b></td>
	<td class=\"type5\">$timestamp</td><td class=\"type5\" align=\"right\">
	<a href=\"admin.php?op=DisplayStory&amp;qid=$qid\">" . lang("Read More...") . "</a> | 
	<a href=\"admin.php?op=DeleteStory&amp;qid=$qid\">" . lang("Delete") . "</a></td>
</tr>
			";
		}
	}

	if($phpgw->db->num_rows())
	$box_stuff .= "</table>";

	themesidebox($box_title, $box_stuff);
//	mysql_free_result($result);

	$box_title = "$admart " . lang("Last Articles");
	$box_stuff = "<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\" width=\"99%\">";

	$phpgw->db->query("select sid, title, time, topic, informant, exp_date from wcm_stories order by time desc limit 0,$admart");

	if ($phpgw->db->num_rows() < 1)
	$box_stuff = lang("None Found");
	else
	{
		while($phpgw->db->next_record())
		{
			$sid=$phpgw->db->f('sid');
			$title=$phpgw->db->f('title');
			$time=$phpgw->db->f('time');
			$topic=$phpgw->db->f('topic');
			$informant=$phpgw->db->f('informant');
			$exp_date=$phpgw->db->f('exp_date');
			$db2->query("select topictext from wcm_topics where topicid=$topic");
			$db2->next_record();
			$topictext=$db2->f("topictext");
			
			if($exp_date == '2099-12-31 23:59:59') $exp_date = 'No Expiration';
			else $exp_date = substr($exp_date,0,10);

			formatTimestamp($time);
		
			$box_stuff .= "
<tr>
	<td class=\"type5\"><b>$title</b></td>
	<td class=\"type5\">$topictext</td>
	<td class=\"type5\">$exp_date</td>
	<td class=\"type5\" align=\"right\">
	<a href=\"admin.php?op=EditStory&amp;sid=$sid\">" . lang("Edit") . "</a> |
	<a href=\"admin.php?op=RemoveStory&amp;sid=$sid\">" . lang("Delete") . "</a>
	</td>
</tr>
			";
		}
	}

	if ($phpgw->db->num_rows())
	$box_stuff .= "</table>";

	themesidebox($box_title, $box_stuff);
//	mysql_free_result($result);

	include ("footer.php");
}

/**
 *  Function: The SWITCH (not REALLY a function)
 *  Author:   Started by phpNuke developers and edited by anyone who
 *            touched the admin side.
 *  Purpose:  This switch statement takes the arguement $op passed to the
 *            admin page and decides which functions to call based on
 *            that variable.
 */
//The seesion variable admintest is used to make sure an administrator has logged in. If NOT then it calls
//the login() function at the bottom of this switch statement.

if (is_an_author())
{
	switch($op)
	{
		case "main_page_data":
		main_page_data();
		break;
      
		case "submit_main_page":
		test_data(1, $main_title, $main_text, $main_image, $main_alt);

		$main_title = htmlentities($main_title);
		$main_alt = htmlentities($main_alt);

		if($main_image == "none" && $old_main_image)
		update_main_page(addslashes($main_title), addslashes($main_text), $main_image, addslashes($main_alt), $old_main_image, 'image/gif', '1', $active);
		else
		update_main_page(addslashes($main_title), addslashes($main_text), $main_image, addslashes($main_alt), $main_image_name, $main_image_type, $main_image_size, $active);
		save_new_page();
		break;
      
		case "get_page_data":
		get_page_data();
		break;
      
		case "select_layout":
		test_data(1, $title, $text1, "none", "none");
		$page_id = store_user_page($title, $default_num_sections);
      
		for($i=1; $i <= $default_num_sections; $i++)
		{
			$subtitle = "subtitle".$i;
			$text = "text".$i;
			$image = "image".$i;
			$image_name = "image".$i."_name";
			$image_type = "image".$i."_type";
			$image_size = "image".$i."_size";
			$alt = "alt".$i;
	  
			test_data(0, $$sub_title, $$text, $$image, $$alt);
			store_page_content($page_id, $$subtitle, $$text, $$image, $$image_name,
			$$image_type, $$image_size, $$alt, $i);
		}
		set_display_flags($page_id, $sub_array, $text_array, $image_array);
		select_layout($page_id, $new_page);
		break;
      
		case "choose_menu":
		if($edit_content)
		 edit_page($page_id, $new_page);
		else if($layout)
		 select_layout($page_id, $new_page);
		else if($menu)
		 choose_menu($page_id);
		else
		 save_new_page();
		break;
      
		case "update_page_menu":
		update_page_menu($menu_id, $menu_text);
		save_new_page();
		break;
      
		case "new_menu_item_post":
		$menu_id = menu_post($title, 'content.php');
		$phpgw->db->query("update wcm_menu set page_id='$page_id' where menu_id='$menu_id'");
		get_menu_text($menu_id);
		break;
    
		case "page_menu_post":
		page_menu_post($page_id);
		break;
      
		case "sub_page_menu_post":
		sub_page_menu_post($low_sub, $page_id);
		break;
      
		case "update_link_text":
		update_link_text($menu_id, $link);
		save_new_page();
		break;
      
		case "list_user_pages":
		list_user_pages();
		break;
      
		case "toggle_active":
		toggle_active($page_id, $active);
		list_user_pages();
		break;
      
		case "double_check":
		double_check($page_id);
		break;
      
		case "drop_page":
		drop_page($page_id, $answer);
		list_user_pages();
		break;
      
		case "edit_page":
		edit_page($page_id, 0);  //pass zero as new_page because it is NOT a new page.
		break;
      
		case "save_changes":
		$phpgw->db->query("update wcm_user_pages set title='$title', num_sections='$default_num_sections' where page_id='$page_id'");
      
		for($i=1; $i <= $default_num_sections; $i++)
		{
			$subtitle = "subtitle".$i;
			$text = "text".$i;
			$image = "image".$i;
			$old_image = "old_image".$i;
			$image_name = "image".$i."_name";
			$image_type = "image".$i."_type";
			$image_size = "image".$i."_size";
			$alt = "alt".$i;

			test_data(0, $$sub_title, $$text, $$image, $$alt);
			if($$image == "none" && $$old_image)
			save_changes($page_id, $$subtitle, $$text, "none", $$old_image, "image/gif", $$image_size, $i, $$alt, 1);
			else
			save_changes($page_id, $$subtitle, $$text, $$image, $$image_name, $$image_type, $$image_size, $i, $$alt, 0);
		}
		set_display_flags($page_id, $sub_array, $text_array, $image_array);

		if($layout)
		 select_layout($page_id, $new_page);
		else if($menu)
		 choose_menu($page_id);
		else
		 save_new_page();
		break;
      
		case "preview_page":
		if($submit_layout)
		 preview_page($layout, $page_id, $new_page);
		else if($menu)
		 choose_menu($page_id);
		else
		 save_new_page();
		break;

		case "links":
		links();
		break;
      
		case "LinksDelNew":
		LinksDelNew($lid);
		break;
      
		case "LinksAddCat":
		LinksAddCat($title);
		break;
      
		case "LinksAddSubCat":
		LinksAddSubCat($cid, $title);
		break;
      
		case "LinksAddLink":
		LinksAddLink($new, $lid, $title, $url, $cat, $description, $name, $email);
		break;
      
		case "LinksDelCat":
		LinksDelCat($cid, $sid, $sub, $ok);
		break;
      
		case "LinksModCat":
		LinksModCat($cat);
		break;
      
		case "LinksModCatS":
		LinksModCatS($cid, $sid, $sub, $title);
		break;
      
		case "LinksModLink":
		LinksModLink($lid);
		break;
      
		case "LinksModLinkS":
		LinksModLinkS($lid, $title, $url, $description, $name, $email, $hits, $cat);
		break;
      
		case "LinksDelLink":
		LinksDelLink($lid);
		break;

		case "BannersAdmin":
		BannersAdmin();
		break;
      
		case "BannersAdd":
		BannersAdd($name, $cid, $imptotal, $imageurl, $clickurl);
		break;
      
		case "BannerAddClient":
		BannerAddClient($name, $contact, $email, $login, $passwd, $extrainfo);
		break;
     
		case "BannerFinishDelete":
		BannerFinishDelete($bid);
		break;
      
		case "BannerDelete":
		BannerDelete($bid, $ok);
		break;
      
		case "BannerEdit":
		BannerEdit($bid);
		break;
      
		case "BannerChange":
		BannerChange($bid, $cid, $imptotal, $impadded, $imageurl, $clickurl);
		break;
      
		case "BannerClientDelete":
		BannerClientDelete($cid, $ok);
		break;
      
		case "BannerClientEdit":
		BannerClientEdit($cid);
		break;
      
		case "BannerClientChange":
		BannerClientChange($cid, $name, $contact, $email, $extrainfo, $login, $passwd);
		break;

		case "GraphicsAdmin":
		GraphicAdmin();
		break;

		case "hreferer":
		hreferer($sortby, $filter);
		break;
      
		case "delreferer":
		delreferer($action);
		break;
      
		case "adminMain":
		adminMain();
		break;
      
		case "topicsmanager":
		topicsmanager();
		break;
      
		case "topicedit":
		topicedit($topicid);
		break;
      
		case "topicmake":
		if($topicimage == 'none')
		 topicerror("You must submit an image when creating a new topic!");
		else
		 topicmake($topicparent, $topicname, $topicimage, $topictext, $topiclongtext, $topicimage_name, $topicimage_type, $topicimage_size); 
		topicsmanager();
		break;
      
		case "topicdelete":
		topicdelete($topicid, $ok);
		break;
      
		case "topicchange":
		if($save)
		{
			if($topicimage == 'none')
			 topicchange($topicid, $topicparent, $topicname, $topicimage, $topictext, $topiclongtext, $old_topicimage, 'image/gif', 1, 0);
			else
			 topicchange($topicid, $topicparent, $topicname, $topicimage, $topictext, $topiclongtext, $topicimage_name, $topicimage_type, $topicimage_size, 1);
		}
		else if($delete)
		topicdelete($topicid, $ok);
		topicsmanager();
		break;
      
		case "sections":
		sections();
		break;
      
		case "sectionedit":
		sectionedit($secid);
		break;
      
		case "sectionmake":
		sectionmake($secname, $image);
		break;
      
		case "sectiondelete":
		sectiondelete($secid, $ok);
		break;
      
		case "sectionchange":
		sectionchange($secid, $secname, $image);
		break;
      
		case "secarticleadd":
		secarticleadd($secid, $title, $content);
		break;
      
		case "secartedit":
		secartedit($artid);
		break;
      
		case "secartchange":
		secartchange($artid, $secid, $title, $content);
		break;
      
		case "secartdelete":
		secartdelete($artid, $ok);
		break;
      
		case "blocks":
		blocks();
		break;
      
		case "makeblock":
		makeblock($title, $content);
		break;
      
		case "deleteblock":
		deleteblock($id);
		break;
    
		case "changeblock":
		changeblock($id, $title, $content);
		break;

		case "rblocks":
		rblocks();
		break;
      
		case "makerblock":
		makerblock($title, $content);
		break;
      
		case "deleterblock":
		deleterblock($id, $order_id);
		break;
      
		case "changerblock":
		changerblock($id, $title, $content);
		break;

		case "rblock_order":
		rblock_order($id, $action);
		break;

		case "lblocks":
		lblocks();
		break;
      
		case "makelblock":
		makelblock($title, $content);
		break;
      
		case "deletelblock":
		deletelblock($id, $order_id);
		break;
      
		case "changelblock":
		changelblock($id, $title, $content);
		break;

		case "lblock_order":
		lblock_order($id, $action);
		break;

		case "ablock":
		ablock();
		break;
      
		case "changeablock":
		changeablock($title, $content);
		break;
      
		case "DisplayStory":
		displayStory($qid);
		break;
      
		case "PreviewAgain":
		previewStory($qid, $uid, $author, $subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire);
		break;
      
		case "PostStory":
		postStory($qid, $uid, $author, $subject, $hometext, $bodytext, $topic, $notes, $month, $day, $year, $allow_expire);
		break;
      
		case "EditStory":
		editStory($sid);
		break;
      
		case "RemoveStory":
		removeStory($sid, $ok);
		break;
      
		case "RemoveComment":
		removeComment($tid, $sid);
		break;
      
		case "RemovePollComment":
		RemovePollComment($tid, $pollID);
		break;
      
		case "ChangeStory":
		changeStory($sid, $subject, $hometext, $bodytext, $topic, $notes, $month, $day, $year, $allow_expire);
		break;
      
		case "DeleteStory":
		deleteStory($qid);
		break;

		case "adminStory":
		adminStory($sid);
		break;
      
		case "PreviewAdminStory":
		previewAdminStory($subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire);
		break;
      
		case "PostAdminStory":
		postAdminStory($subject, $hometext, $bodytext, $topic, $month, $day, $year, $allow_expire);
		break;
      
		case "mod_authors":
		displayadmins();
		break;
      
		case "modifyadmin":
		modifyadmin($chng_aid);
		break;
      
		case "UpdateAuthor":
		updateadmin($chng_aid, $chng_name, $chng_email, $chng_url, $chng_pwd, $chng_pwd2);
		break;
      
		case "AddAuthor":
		if (!($add_aid && $add_name && $add_email && $add_pwd))
		{
			echo "You must complete all compulsory fields";
			return;
		}

		$crypt_pass = md5($add_pwd);
		$phpgw->db->query("insert into wcm_authors values ('$add_aid','$add_name','$add_url','$add_email','$crypt_pass','0')");
      
//		if (!$result)
//		{
//			echo mysql_errno(). ": ".mysql_error(). "<br />";
//			return;
//		}
//		Header("Location: admin.php?op=adminMain");
		$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=adminMain"));
		break;
      
		case "deladmin":
		include("header.php");
		$box_title = "<span class=\"type4bigger\">" . lang("Delete Author") . "</span>";
		$box_stuff = lang("Are you sure you want to delete") . " $del_aid?<br />";
		$box_stuff .= "[ <a href=\"admin.php?op=deladminconf&amp;del_aid=$del_aid\">" .lang("Yes") . "</a>&nbsp;|&nbsp;<a href=\"admin.php?op=mod_authors\">" .lang("No") . "</a> ]";
		themesidebox($box_title, $box_stuff);
		include("footer.php");
		break;
    
		case "deladminconf":
		$phpgw->db->query("delete from wcm_authors where aid='$del_aid'");
		header("location:./admin.php?op=adminMain");
//		echo mysql_error();
		break;
      
		case "mod_users":
		displayUsers();
		break;
      
		case "modifyUser":
		modifyUser($chng_uid);
		break;
      
		case "updateUser":
		updateUser($chng_uid, $chng_uname, $chng_name, $chng_url, $chng_email, $chng_femail, $chng_pass, $chng_pass2);
		break;
      
		case "delUser":
		include("header.php");
		$box_title = "<span class=\"type4bigger\">Delete User</span>";
		$box_stuff = "Are you sure you want to delete user $chng_uid?<br />";
		$box_stuff .= "[ <a href=\"admin.php?op=delUserConf&amp;del_uid=$chng_uid\">Yes</a> | <a href=\"admin.php?op=mod_users\">No</a> ]";
		themesidebox($box_title, $box_stuff);
		include("footer.php");
		break;
      
		case "delUserConf":
		$phpgw->db->query("delete from wcm_users where uid='$del_uid' or uname='$del_uid'");
//		Header("Location: admin.php?op=adminMain");
		$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=adminMain"));
//		echo mysql_error();
		break;
      
		case "addUser":
		$add_pwd = crypt($add_pass);

		if (!($add_uname && $add_email && $add_pass))
		{
			echo "You must complete all compulsory fields";
			return;
		}

		$sql = "insert into wcm_users ";
		$sql .= "(name,uname,email,femail,url,pass) ";
		$sql .= "values ('$add_name','$add_uname','$add_email','$add_femail','$add_url','$add_pwd')";
		$phpgw->db->query($sql);

//		if (!$result)
//		{
//			echo mysql_errno(). ": ".mysql_error(). "<br />";
//			return;
//		}
//		Header("Location: admin.php?op=mod_users");
		$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=mod_users"));
		break;
      
		case "create":
		poll_createPoll($flip);
		break;
      
		case "createPosted":
		$phpgw->db->query("update wcm_flags set poll='1'");
		poll_createPosted();
		break;

		case "poll_active":
		if($active == 1)
		 $phpgw->db->query("update wcm_flags set poll='1'");
		else
		 $phpgw->db->query("update wcm_flags set poll='0'");
		poll_createPoll();
		break;
            
		case "poll_editPoll":
		poll_editPoll($pollID);
		break;
      
		case "ChangePoll":
		ChangePoll($pollID, $pollTitle, $optionText, $optionCount, $voteID);
		break;
      
		case "remove":
		poll_removePoll();
		break;
      
		case "removePosted":
		poll_removePosted();
		break;
      
		case "view": 
		poll_viewPoll();
		break;
      
		case "viewPosted":
		poll_viewPosted();
		break;
      
		case "logout":
		$admintest = 0;
		$current_admin="";
		session_unregister("admintest");
		session_unregister("current_admin");
		$titlebar = "Logged out";
		include("header.php");
		themesidebox(lang("You are now logged out"), "<br /><a href=\"index.php\">".lang("Click here to go back to the main page")."</a>");
		include("footer.php");
		break;
      
      
		case "edit_menu":
		edit_menu();
		break;
      
		case "add_main_menu":
		add_main_menu();
		break;
      
		case "menu_post":
		menu_post($menu_text, $menu_url);
		edit_menu();
		break;
      
      
		case "add_sub_menu":
		add_sub_menu();
		break;
      
		case "sub_menu_post":
		sub_menu_post($low_sub, $menu_text, $menu_url);
		edit_menu();
		break;      

		case "menu_prompt_delete":
		menu_prompt_delete();
		break;
      
		case "menu_delete":
		menu_delete($menu_id);
		edit_menu();
		break;
      
		case "menu_active":
		menu_active($menu_id, $menu_active);
		edit_menu();
		break;
      
		case "edit_menu_item":
		edit_menu_item($menu_id);
		break;
      
		case "update_menu_item":
		update_menu_item($menu_id, $menu_text, $menu_url);
		edit_menu();
		break;

		case "order_menu":
		order_menu($menu_id);
		break;

		case "update_menu_order":
		update_menu_order($menu_id, $menu_order, $move);
		order_menu($menu_id);
		break;
      
		case "menu_error":
		menu_error();
		break;      
		
		case "help":
		help_main();
		break;

		case "help_modify_child":
		if(!$change_ok) {
		$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
		$phpgw->db->next_record();
		$name=$phpgw->db->f("name");
		$description = $phpgw->db->f("decription");
		modify_child("", "$name", "$description", $one, $two, $three, $four, $five, $six);
		}else{
		$name = htmlspecialchars(stripslashes($name));
		$description = htmlspecialchars(stripslashes($description));
		if ($one && !$two) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one > '0' AND one <> '$one' AND two='' AND three='' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if ($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description' WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
//						Header("Location: admin.php?op=help");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
	if ($two && !$three) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two > '0' AND two <> '$two' AND three='' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if ($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description' WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
	if ($three && !$four) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three > '0' AND three <> '$three' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if ($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description' WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
	if ($four && !$five) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four > '0' AND four <> '$four' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if ($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description' WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
	if ($five && !$six) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four='$four' AND five > '0' AND five <> '$five' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if ($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description' WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
	if($six) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six > '0' AND six <> '$six'");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
					if($nomen || !$name) {
						modify_child(1, $name, $description, $one, $two, $three, $four, $five, $six);
					}else{
						$phpgw->db->query("UPDATE wcm_help SET name='$name', description='$description', one='$one', two='$two', three='$three', four='$four', five='$five', six='$six'");
						$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
					}
			    }
		}
		break;

		case "help_add_child":
		if(!$change_ok) {
		add_child("", "", "", $one, $two, $three, $four, $five, $six);
		}else{
		$name = htmlspecialchars(stripslashes($name));
		$description = htmlspecialchars(stripslashes($description));
		if(!$one) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one > '0' AND two='' AND three='' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one > '0' ORDER BY one ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("one");
			}
			$one = $highnum + 1;
			$phpgw->db->query("INSERT INTO wcm_help (name, description, one) VALUES ('$name', '$description', '$one')");
			}
		}elseif($one && !$two) {
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two > '0' AND three='' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two > '0' ORDER BY two ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("two");
			}
	      		$two = $highnum + 1;
			$phpgw->db->query("SELECT admin FROM wcm_help WHERE one='$one' AND two='0'");
			$phpgw->db->next_record();
				$admin_check = $phpgw->db->f("admin");
			$phpgw->db->query("INSERT INTO wcm_help (name, description, admin, one, two, three, four, five, six) VALUES ('$name', '$description', '$admin_check', '$one', '$two', '$three', '$four', '$five', '$six')");
		     	}
		}elseif($two && !$three){
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three > '0' AND four='' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two='$two' AND three > '0' ORDER BY three ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("three");
			}
			$three = $highnum + 1;
			$phpgw->db->query("SELECT admin FROM wcm_help WHERE one='$one' AND two='$two' AND three='0'");
			$phpgw->db->next_record();
				$admin_check = $phpgw->db->f("admin");
			$phpgw->db->query("INSERT INTO wcm_help (name, description, admin, one, two, three, four, five, six) VALUES ('$name', '$description', '$admin_check', '$one', '$two', '$three', '$four', '$five', '$six')");
			}
		}elseif($three && !$four){
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four > '0' AND five='' AND six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four > '0' ORDER BY four ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("four");
			}
			$four = $highnum + 1;
			$phpgw->db->query("SELECT admin FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='0'");
			$phpgw->db->next_record();
				$admin_check = $phpgw->db->f("admin");
			$phpgw->db->query("INSERT INTO wcm_help (name, description, admin, one, two, three, four, five, six) VALUES ('$name', '$description', '$admin_check', '$one', '$two', '$three', '$four', '$five', '$six')");
			}
		}elseif($four && !$five){
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four='$four' AND five > '0' and six=''");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five > '0' ORDER BY five ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("five");
			}
			$five = $highnum + 1;
			$phpgw->db->query("SELECT admin FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='0'");
			$phpgw->db->next_record();
				$admin_check = $phpgw->db->f("admin");
			$phpgw->db->query("INSERT INTO wcm_help (name, description, admin, one, two, three, four, five, six) VALUES ('$name', '$description', '$admin_check', '$one', '$two', '$three', '$four', '$five', '$six')");
			}
		}elseif($five && !$six){
			$phpgw->db->query("SELECT name FROM wcm_help WHERE name='$name' AND one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six > '0'");
			$phpgw->db->next_record();
			$nomen = $phpgw->db->f("name");
				if ($nomen || !$name) {
					add_child("1", $nomen, $description, $one, $two, $three, $four, $five, $six);
				}else{
			$phpgw->db->query("SELECT * FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six > '0' ORDER BY six ASC");
			while ($phpgw->db->next_record()) {
			$highnum = $phpgw->db->f("six");
			}
			$six = $highnum + 1;
			$phpgw->db->query("SELECT admin FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='0'");
			$phpgw->db->next_record();
				$admin_check = $phpgw->db->f("admin");
			$phpgw->db->query("INSERT INTO wcm_help (name, description, admin, one, two, three, four, five, six) VALUES ('$name', '$description', '$admin_check', '$one', '$two', '$three', '$four', '$five', '$six')");
			}
		}elseif($six) {}else{}
		$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));}
		break;

		case "help_delete_child":
		if ($change) {
			if ($go) {
			//Go ahead and delete the thing and move stuff around
				if($one && !$two) {
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one'");
				 $phpgw->db->query("UPDATE wcm_help SET one=one-1 WHERE one > '$one'");	
				}
				if($two && !$three){
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one' AND two='$two'");
				 $phpgw->db->query("UPDATE wcm_help SET 
two=two-1 WHERE one='$one' AND two > '$two'");
				}
				if($three && !$four){
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three'");
				 $phpgw->db->query("UPDATE wcm_help SET three=three-1 WHERE one='$one' AND two='$two' AND three > '$three'");
				}
				if($four && !$five) {
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four'");
				 $phpgw->db->query("UPDATE wcm_help SET four=four-1 WHERE one='$one' AND two='$two' AND three='$three' AND four > '$four'");
				}
				if($five && !$six) {
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five'");
				 $phpgw->db->query("UPDATE wcm_help SET 
five=five-1 WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five > '$five'");
				}
				if($six) {
				 $phpgw->db->query("DELETE FROM wcm_help WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six='$six'");
				 $phpgw->db->query("UPDATE wcm_help SET six=six-1 WHERE one='$one' AND two='$two' AND three='$three' AND four='$four' AND five='$five' AND six > '$six'");
				}
				$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
			}elseif($stop){
				$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));	
			}
		}else{
		  	delete_child($one, $two, $three, $four, $five, $six);
		}
		break;
	
		case "activate_admin":
		//Clears previous admin section
			$phpgw->db->query("UPDATE wcm_help SET admin = '0'");
			$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));		
		//Updates Newer Admin Section
		if(!$two){
			$phpgw->db->query("UPDATE wcm_help SET admin = '1' WHERE one = '$one'");
			}
		elseif(!$three){
			$phpgw->db->query("UPDATE wcm_help SET admin = '1' WHERE one = '$one' AND two = '$two'");
			}
		elseif(!$four){
			$phpgw->db->query("UPDATE wcm_help SET admin = '1' WHERE one = '$one' AND two = '$two' AND three = '$three'");
			}
		elseif(!$five){
			$phpgw->db->query("UPDATE wcm_help SET admin = '1' WHERE one = '$one' AND two = '$two' AND three = '$three' AND four = '$four'");
			}
		elseif(!$six){
			$phpgw->db->query("UPDATE wcm_help SET admin = '1' WHERE one = '$one' AND two = '$two' AND three = '$three' AND four = '$four' AND five = '$five'");
			}
		$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
		break;

		case "deactivate_admin":
		//Clears admin sections
			$phpgw->db->query("UPDATE wcm_help SET admin = '0'");
			$phpgw->redirect($phpgw->link('/wcm/admin.php',"op=help"));
		break;

		default:
		adminMain();
		break;
	}
}
//IF NOT ADMIN FORCE USER TO LOG IN.
else {
	$user = $phpgw_info['user']['account_id'];
	$phpgw->common->phpgw_header();
	echo "<P>$user not permitted to be here.</p>";
}
//deny();

?>
