#
# Makefile for picasm (Amiga SAS/C 6.x)
#

OBJS = picasm.o devices.o config.o token.o symtab.o expr.o \
       pic12bit.o pic14bit.o pic16bit.o

picasm: $(OBJS)
	sc link $(OBJS) to $@

#---------------
config.o: config.c picasm.h token.h
devices.o: devices.c picasm.h
expr.o: expr.c picasm.h token.h symtab.h
pic12bit.o: pic12bit.c picasm.h token.h symtab.h
pic14bit.o: pic14bit.c picasm.h token.h symtab.h
pic16bit.o: pic16bit.c picasm.h token.h symtab.h
picasm.o: picasm.c picasm.h token.h symtab.h
symtab.o: symtab.c picasm.h symtab.h
token.o: token.c picasm.h token.h symtab.h
