/*
 * PIMPPA - pnewgrp (Adds a new newsgroup)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>

#include "pimppa.h"

unsigned long Flags=0;
	
void usage(char *progname)
{
	fprintf(stderr, "Usage: %s -d <dest_area> -n <group_name>\n\n%s", progname,
	"-d <dest_area>  Destination area name, MUST\n"
	"-n <group_name> Newsgroup name, MUST\n"
	"-s <server_id>  Newsserver id, default=1\n");
}

int main(int argc, char *argv[])
{
	char name[PATH_MAX];
	char dest[PATH_MAX];
	MYSQL *db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int go=1,areaid=0,server=1;

	name[0]=dest[0]=0;

	while(go)
	{
		switch(getopt(argc, argv, "hn:d:s:V"))
		{
			case 'n':
				strcpy(name, optarg);
				break;
			case 'd':
				strcpy(dest, optarg);
				break;
			case 's':
				server=atoi(optarg);
				break;
			case -1:
				go=0;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
			default:
				usage(argv[0]);
				return(0);
				break;
		}
	}
	
	if(!name[0])
	{
		fprintf(stderr, "Please supply newsgroup name with -n <name>\n");
		return(0);
	}	
	if(!dest[0])
	{
		fprintf(stderr, "Please supply destination area name with -d <name>\n");
		return(0);
	}

	db=p_connect();
	if(!db)
		return(-1);

/********************** Check that the group doesn't exist **************/

	p_query(db, "SELECT 1 "
		    "FROM p_groups "
		    "WHERE g_name='%s' AND g_server=%d", 
		name,server);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if(mysql_num_rows(sql_result)>0)
		{
			mysql_free_result(sql_result);
			fprintf(stderr, "%s already exists in p_groups...\n", name);
			return(-1);
		}
		mysql_free_result(sql_result);
	}

/*********** Find the area id *************/

    p_query(db, "SELECT area_id "
                "FROM p_areas "
                "WHERE area_name='%s'",
            dest);
    sql_result=mysql_store_result(db);
    if(sql_result)
    {
        sql_row=mysql_fetch_row(sql_result);
        if(!sql_row)
        {
            mysql_free_result(sql_result);
            fprintf(stderr, "Destination area '%s' doesn't exist...\n", dest);
            return(-3);
        }
        areaid=atoi(sql_row[0]);

        mysql_free_result(sql_result);

        if(areaid<0)
        {
            fprintf(stderr, "Invalid destination area...\n");
            return(-1);
        }
    }
    else
        return(-2);

/****************** Ok, lets add **********************/

	p_query(db, "INSERT INTO p_groups " 
		    "  (g_name, g_dest, g_server) "
		    "VALUES ('%s', %d, %d)", 
		name, areaid, server);
	if(mysql_error(db)[0])
	{
		mysql_close(db);
		fprintf(stderr, "Unable to add the area (%s)...\n",
				mysql_error(db));
		return(-1);
	}

	mysql_close(db);

	fprintf(stderr, "Newsgroup added ok...\n");

	return(0);
}

