/*
 * PIMPPA - rm
 * 
 * PIMPPA rm command. Deletes the files physically from current dir
 * and the db area linked to it. Gives the deleted files a negative 
 * assign pattern (=="next time DELETE on sight").
 *
 * Use with CAUTION!
 *
 * Usage: prm <files>
 *
 */

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "pimppa.h"

int Force=0;
int NiceKill=0;
int Verbose=0;

void usage(char *name)
{
	fprintf(stderr, "Usage: %s <options> [files]\n\n"
					"-f               Force creation of neg. assigns\n"
					"-n               Nice kill. Mark the file as offline,\n"
					"                 Don't create negative assign\n"
					"-v               Verbose execution\n", name);
}

int main(int argc, char *argv[])
{
	char src_lastcomp[PATH_MAX];
	char src_true[PATH_MAX];
	unsigned long src_id,src_context=0;
	MYSQL *db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	int i,files_killed=0,files_skipped=0;
	int go=1;
	char *value;
	int minassnamelen;

	while(go)
	{
		switch(getopt(argc, argv, "fhnvV"))
		{
			case 'f':
				Force=1;
				break;
			case 'n':
				NiceKill=1;
				break;
			case 'v':
				Verbose=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
			default:
				go=0;
				break;
		}
	}

	if(optind==argc)
	{
		usage(argv[0]);
		return(-1);
	}

	db=p_connect();
	if(!db)
		return(-1);

	if(!getcwd(src_true, PATH_MAX))
	{
		fprintf(stderr, "getcwd() failure.\n");
		return(-1);
	}

	if(!p_checkp(src_true))
		strcat(src_true, "/");

	for(i=strlen(src_true)-2;i>=0;i--)			// Find last dir component
	{
		if(src_true[i]=='/')
			break;
	}
	strcpy(src_lastcomp, &src_true[i]);

//	printf("'%s' '%s'\n", src_true, src_lastcomp);

	value=p_getmisc(db, P_KEY_MINASSNAMELEN);
	if(value)
		minassnamelen=atoi(value);
	else
		minassnamelen=atoi(P_MIN_ASS_NAMELENGTH);

/************** get source area *****************************/

	p_query(db, "SELECT area_id, area_path, area_context "
		    "FROM p_areas "
		    "WHERE area_path like '%%%s'", 
		src_lastcomp);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(db));
		return(-1);
	}
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		sql_row=mysql_fetch_row(sql_res);
		if(sql_row)
		{
			src_id=atoi(sql_row[0]);
			src_context=atoi(sql_row[2]);
		}
		else
		{
			fprintf(stderr, "Current dir '%s' doesn't match any area in the db.\n", src_true);
			return(-1);
		}

		mysql_free_result(sql_res);
	}
	else
		return(-2);
	
/************ Ok, kill files ****************/

	for(i=optind;i<argc;i++)
	{
		char fullsrc[PATH_MAX];
		char escaped_fn[2*P_LEN_FILE_NAME+1];
		unsigned long file_id=0;

		if(Verbose)
			printf("%s\n", argv[i]);
		
		mysql_escape_string(escaped_fn, argv[i], strlen(argv[i]));

		// Check that the source file exists
		p_query(db, "SELECT file_id FROM p_files "
			    "WHERE file_name='%s' "
			    "  AND file_area=%ld",
			escaped_fn, src_id);
		if(mysql_error(db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(db));
			return(-4);
		}
		sql_res=mysql_store_result(db);
		if(!sql_res)
			continue;
			
		if((sql_row=mysql_fetch_row(sql_res)))	// Find source
		{
			file_id=atoi(sql_row[0]);
		}
		else
		{
			mysql_free_result(sql_res);
			fprintf(stderr, "%s not found in db...\n", argv[i]);
			files_skipped++;
			continue;
		}
		mysql_free_result(sql_res);

		if(NiceKill)
		{
			p_query(db, "UPDATE p_files "
				    "SET file_flags=(file_flags | %ld) "
				    "WHERE file_id=%ld",
				FILE_OFFLINE, file_id);
		}
		else
		{
			p_query(db, "DELETE FROM p_files "
				    "WHERE file_id=%ld",
				file_id);
		}

		sprintf(fullsrc, "%s%s", src_true, argv[i]);
		remove(fullsrc);
	
		if(!NiceKill)
		{
			if(!Force)
			{
				int suggest;

				// Check if the assign points to this area
				suggest=p_getdest(argv[i], src_context);
				if(suggest>0 && suggest!=src_id)
				{
					printf("Not replacing assign of %s to area %d\n",
						argv[i], suggest);
					
					files_killed++;

					continue;
				}
			}
			
			p_assign(db, argv[i], minassnamelen, -1, src_context);
		}	

		files_killed++;
	}
	
	mysql_close(db);

	if(files_killed)
		fprintf(stderr, "%d files killed...\n", files_killed);
	if(files_skipped)
		fprintf(stderr, "%d files SKIPPED...\n", files_skipped);

	return(0);
}

