/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __USER_H
#define __USER_H

#ifdef __cplusplus
extern "C" {
#endif

#include "plex86.h"
#include "decode.h"

#define  BUGSMAIL "plex86@fastxs.net"
#define  VERSION  "0.1.0"

typedef struct
{
    int max_memory;
    Bit32u text_address;
    Bit32u stack_address;
    int verbose;
    int dump_vm;
    int exit_wait;
    enum i386_asm_syntax syntax;
    unsigned prescanDepth;
    unsigned prescanRing3;
} config_info_t;

typedef struct callback_command_tag {
  const char *command;
  void (*f)(unsigned char *);
  struct callback_command_tag *next;
  } callback_command_t;

extern callback_command_t *callback_command_list;

extern config_info_t vm_conf;

extern unsigned vm_mem_updated;

void vm_init (void);
void vm_fini (void);
void vm_kickstart (void);
void vm_abort (void);
void vm_set_intr (int intr);
int  vm_alloc_intr (int intr);
int  vm_release_intr (int intr);
void vm_get_cpu(guest_cpu_t *cpu);
void vm_event_loop(void);
int  vm_debug_exception (void);
void vm_set_init_ioctl(unsigned);
void vm_set_cpu(guest_cpu_t *);
void vm_register_callback(const char *, void (*)(unsigned char *));
void vm_open(void);
void vm_init_memory(unsigned nmegs);
void vm_init_prescan_depth(unsigned depth);
void vm_init_prescan_ring3(unsigned val);
unsigned vm_load_rom(const char *path, Bit32u address);

int  pluginReadPhyMem(Bit32u address, unsigned length, void *data);
int  pluginWritePhyMem(Bit32u address, unsigned length, void *data);

#ifdef __cplusplus
};
#endif

#endif /* __USER_H */
