import os, string, pwd, sys
import PMS

def get_mailname():
	try:
		fp = open('/etc/mailname')
	except (IOError, OSError):
		return get_dnsdomainname()
	try:
		return string.strip(fp.read())
	finally:
		fp.close()

def get_dnsdomaninname():
	if sys.platform[:5] == 'linux':
		command = command + " --fqdn"
	fp = os.popen(command)
	try:
		hostname = string.strip(fp.read())
		dnsdomainname = string.join(string.split(hostname, '.')[1:], 
	                            	'.')
		return dnsdomainname
	finally:
		fp.close()

mailname = get_mailname()

pw = pwd.getpwuid(os.getuid())
print 'From:', string.split(pw[4], ',')[0], '<%s@%s>' % (pw[0], mailname)
print 'X-Mailer: PMS '+PMS.__version__+' (http://pythonms.sourceforge.net)'
