/***************************************************************************
 *   Copyright (C) 2006 by FThauer FHammer   *
 *   f.thauer@web.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "arraydata.h"

using namespace std;

struct RoundData
{
	int hand;
	double data[4];
};

static const RoundData PreflopValues[] =
{
	{     0, { 0.392398, 0.276545, 0.212940, 0.178564 } },
	{    10, { 0.341141, 0.213735, 0.153802, 0.121123 } },
	{    11, { 0.374930, 0.252093, 0.194671, 0.161691 } },
	{    20, { 0.351826, 0.220031, 0.160432, 0.127509 } },
	{    21, { 0.385048, 0.260354, 0.200738, 0.167674 } },
	{    30, { 0.362845, 0.227411, 0.167515, 0.132691 } },
	{    31, { 0.393682, 0.265876, 0.207630, 0.172295 } },
	{    40, { 0.364174, 0.220155, 0.158920, 0.124233 } },
	{    41, { 0.395005, 0.261673, 0.199692, 0.165581 } },
	{    50, { 0.368042, 0.220327, 0.157511, 0.119645 } },
	{    51, { 0.403993, 0.258386, 0.197324, 0.159935 } },
	{    60, { 0.389178, 0.234286, 0.164548, 0.126870 } },
	{    61, { 0.418772, 0.270658, 0.204814, 0.167860 } },
	{    70, { 0.411282, 0.248507, 0.175819, 0.133796 } },
	{    71, { 0.441392, 0.285024, 0.216091, 0.174384 } },
	{    80, { 0.440480, 0.268060, 0.190030, 0.147938 } },
	{    81, { 0.467023, 0.302555, 0.231871, 0.188436 } },
	{    90, { 0.467598, 0.292983, 0.206409, 0.159414 } },
	{    91, { 0.492893, 0.327706, 0.247315, 0.200483 } },
	{   100, { 0.500946, 0.321231, 0.229723, 0.176626 } },
	{   101, { 0.523507, 0.354234, 0.266130, 0.216512 } },
	{   110, { 0.546298, 0.361122, 0.262676, 0.202235 } },
	{   111, { 0.564731, 0.391539, 0.300782, 0.241582 } },
	{   120, { 0.612210, 0.437722, 0.333962, 0.266613 } },
	{   121, { 0.631711, 0.466625, 0.370526, 0.302552 } },
	{  1010, { 0.425249, 0.294167, 0.227440, 0.189070 } },
	{  1020, { 0.368338, 0.236502, 0.175148, 0.141144 } },
	{  1021, { 0.398522, 0.274875, 0.213918, 0.181193 } },
	{  1030, { 0.380584, 0.244160, 0.183336, 0.148602 } },
	{  1031, { 0.411600, 0.280911, 0.221748, 0.185122 } },
	{  1040, { 0.379182, 0.238104, 0.174768, 0.138399 } },
	{  1041, { 0.410886, 0.274157, 0.214447, 0.178769 } },
	{  1050, { 0.388704, 0.236244, 0.169994, 0.133749 } },
	{  1051, { 0.416815, 0.269452, 0.210729, 0.172591 } },
	{  1060, { 0.396943, 0.237112, 0.169488, 0.130860 } },
	{  1061, { 0.425483, 0.274880, 0.208163, 0.171587 } },
	{  1070, { 0.421637, 0.255125, 0.181848, 0.138975 } },
	{  1071, { 0.447019, 0.291320, 0.219969, 0.180664 } },
	{  1080, { 0.448126, 0.274144, 0.196289, 0.151646 } },
	{  1081, { 0.473606, 0.310826, 0.235919, 0.190739 } },
	{  1090, { 0.478501, 0.298148, 0.212041, 0.163683 } },
	{  1091, { 0.504431, 0.333231, 0.251471, 0.204792 } },
	{  1100, { 0.510525, 0.327482, 0.234555, 0.180396 } },
	{  1101, { 0.532065, 0.360810, 0.270922, 0.220332 } },
	{  1110, { 0.553686, 0.367362, 0.268589, 0.207489 } },
	{  1111, { 0.576153, 0.400387, 0.303690, 0.247722 } },
	{  1120, { 0.621342, 0.446336, 0.343233, 0.273911 } },
	{  1121, { 0.637968, 0.474715, 0.373390, 0.310121 } },
	{  2020, { 0.458947, 0.313939, 0.242610, 0.200423 } },
	{  2030, { 0.398033, 0.259838, 0.198458, 0.161070 } },
	{  2031, { 0.425525, 0.293960, 0.235756, 0.199501 } },
	{  2040, { 0.397817, 0.255376, 0.190636, 0.154640 } },
	{  2041, { 0.425873, 0.292207, 0.228006, 0.194654 } },
	{  2050, { 0.405126, 0.253793, 0.186274, 0.148799 } },
	{  2051, { 0.434334, 0.290140, 0.224181, 0.187256 } },
	{  2060, { 0.415893, 0.254033, 0.183065, 0.144964 } },
	{  2061, { 0.442020, 0.289907, 0.223390, 0.183388 } },
	{  2070, { 0.431662, 0.261557, 0.186207, 0.143897 } },
	{  2071, { 0.458148, 0.295690, 0.221357, 0.182633 } },
	{  2080, { 0.458244, 0.283182, 0.202632, 0.158355 } },
	{  2081, { 0.485387, 0.317359, 0.244065, 0.197194 } },
	{  2090, { 0.486843, 0.305900, 0.219227, 0.169682 } },
	{  2091, { 0.509158, 0.336822, 0.255117, 0.209493 } },
	{  2100, { 0.520532, 0.334651, 0.241959, 0.186116 } },
	{  2101, { 0.544106, 0.367181, 0.277500, 0.224167 } },
	{  2110, { 0.562867, 0.376359, 0.275377, 0.213308 } },
	{  2111, { 0.583419, 0.408087, 0.311465, 0.251205 } },
	{  2120, { 0.631754, 0.455162, 0.349977, 0.281266 } },
	{  2121, { 0.647554, 0.478675, 0.382699, 0.318028 } },
	{  3030, { 0.491574, 0.334918, 0.260822, 0.215129 } },
	{  3040, { 0.415659, 0.266638, 0.203475, 0.168118 } },
	{  3041, { 0.440987, 0.306280, 0.241409, 0.206000 } },
	{  3050, { 0.420281, 0.269759, 0.202282, 0.163709 } },
	{  3051, { 0.446296, 0.302118, 0.239135, 0.202622 } },
	{  3060, { 0.434861, 0.270280, 0.199293, 0.158721 } },
	{  3061, { 0.457776, 0.306309, 0.238337, 0.200351 } },
	{  3070, { 0.445102, 0.275557, 0.201226, 0.157838 } },
	{  3071, { 0.471762, 0.310139, 0.239625, 0.197345 } },
	{  3080, { 0.468139, 0.289426, 0.208934, 0.162483 } },
	{  3081, { 0.491828, 0.325417, 0.244964, 0.199125 } },
	{  3090, { 0.499743, 0.313642, 0.227720, 0.176322 } },
	{  3091, { 0.521336, 0.347760, 0.262093, 0.214462 } },
	{  3100, { 0.534472, 0.344431, 0.248543, 0.193602 } },
	{  3101, { 0.553252, 0.374123, 0.284209, 0.232423 } },
	{  3110, { 0.573378, 0.384744, 0.283403, 0.220253 } },
	{  3111, { 0.588956, 0.415055, 0.318031, 0.259790 } },
	{  3120, { 0.641023, 0.464428, 0.359995, 0.290579 } },
	{  3121, { 0.657020, 0.489627, 0.389187, 0.322193 } },
	{  4040, { 0.516006, 0.359183, 0.277032, 0.228881 } },
	{  4050, { 0.435729, 0.282211, 0.212923, 0.174751 } },
	{  4051, { 0.462412, 0.313824, 0.249562, 0.212472 } },
	{  4060, { 0.447638, 0.285155, 0.212276, 0.172773 } },
	{  4061, { 0.470266, 0.319709, 0.250671, 0.208987 } },
	{  4070, { 0.460265, 0.288142, 0.213646, 0.171749 } },
	{  4071, { 0.487225, 0.324893, 0.250578, 0.208518 } },
	{  4080, { 0.482136, 0.303300, 0.219496, 0.173420 } },
	{  4081, { 0.502701, 0.334032, 0.255191, 0.211497 } },
	{  4090, { 0.504535, 0.319118, 0.230051, 0.180925 } },
	{  4091, { 0.530570, 0.355567, 0.265668, 0.219096 } },
	{  4100, { 0.539041, 0.348698, 0.254279, 0.198336 } },
	{  4101, { 0.560032, 0.381288, 0.289776, 0.233638 } },
	{  4110, { 0.582704, 0.393881, 0.290373, 0.226942 } },
	{  4111, { 0.598407, 0.422241, 0.321170, 0.263919 } },
	{  4120, { 0.642734, 0.464127, 0.357691, 0.287758 } },
	{  4121, { 0.659588, 0.488409, 0.390229, 0.321964 } },
	{  5050, { 0.549268, 0.382451, 0.297085, 0.244325 } },
	{  5060, { 0.461289, 0.298799, 0.224119, 0.184892 } },
	{  5061, { 0.485634, 0.330149, 0.263757, 0.223014 } },
	{  5070, { 0.473494, 0.303907, 0.228508, 0.183815 } },
	{  5071, { 0.499667, 0.340404, 0.266624, 0.219160 } },
	{  5080, { 0.497160, 0.318137, 0.235993, 0.189195 } },
	{  5081, { 0.519271, 0.346657, 0.273157, 0.225601 } },
	{  5090, { 0.519085, 0.333791, 0.244852, 0.193839 } },
	{  5091, { 0.545203, 0.363052, 0.280410, 0.228881 } },
	{  5100, { 0.548230, 0.359064, 0.263356, 0.204509 } },
	{  5101, { 0.565488, 0.387187, 0.295925, 0.242237 } },
	{  5110, { 0.591864, 0.402174, 0.298403, 0.235400 } },
	{  5111, { 0.608657, 0.431376, 0.331219, 0.269897 } },
	{  5120, { 0.652519, 0.476460, 0.368421, 0.296733 } },
	{  5121, { 0.666606, 0.497720, 0.396138, 0.331399 } },
	{  6060, { 0.572002, 0.405822, 0.316323, 0.263300 } },
	{  6070, { 0.490941, 0.317838, 0.241244, 0.198071 } },
	{  6071, { 0.511400, 0.351731, 0.277871, 0.233745 } },
	{  6080, { 0.513155, 0.333109, 0.251517, 0.203524 } },
	{  6081, { 0.534313, 0.364968, 0.284903, 0.239425 } },
	{  6090, { 0.535497, 0.351791, 0.262208, 0.209001 } },
	{  6091, { 0.555172, 0.379223, 0.294741, 0.242575 } },
	{  6100, { 0.564425, 0.375204, 0.277724, 0.220820 } },
	{  6101, { 0.585780, 0.404858, 0.309063, 0.255885 } },
	{  6110, { 0.601187, 0.412856, 0.307546, 0.243076 } },
	{  6111, { 0.619748, 0.439626, 0.340543, 0.278683 } },
	{  6120, { 0.663506, 0.484994, 0.379012, 0.308522 } },
	{  6121, { 0.672680, 0.508199, 0.406539, 0.338819 } },
	{  7070, { 0.602459, 0.432679, 0.339776, 0.280706 } },
	{  7080, { 0.525674, 0.349554, 0.266348, 0.218304 } },
	{  7081, { 0.546982, 0.380494, 0.299939, 0.252933 } },
	{  7090, { 0.550741, 0.367646, 0.277965, 0.224762 } },
	{  7091, { 0.570817, 0.396292, 0.308852, 0.257872 } },
	{  7100, { 0.578107, 0.392576, 0.296196, 0.237797 } },
	{  7101, { 0.597385, 0.417610, 0.325814, 0.269943 } },
	{  7110, { 0.616725, 0.429318, 0.326413, 0.260805 } },
	{  7111, { 0.633622, 0.455894, 0.358718, 0.295226 } },
	{  7120, { 0.673638, 0.496498, 0.389773, 0.317947 } },
	{  7121, { 0.685843, 0.518038, 0.416296, 0.347696 } },
	{  8080, { 0.633155, 0.462777, 0.368277, 0.305162 } },
	{  8090, { 0.569903, 0.386443, 0.299307, 0.246643 } },
	{  8091, { 0.582209, 0.415800, 0.328378, 0.277974 } },
	{  8100, { 0.597204, 0.413220, 0.317080, 0.258892 } },
	{  8101, { 0.612997, 0.437354, 0.344853, 0.288854 } },
	{  8110, { 0.632288, 0.447764, 0.345514, 0.281554 } },
	{  8111, { 0.651514, 0.473083, 0.372330, 0.311285 } },
	{  8120, { 0.689345, 0.516179, 0.410605, 0.339648 } },
	{  8121, { 0.700118, 0.537866, 0.439058, 0.369618 } },
	{  9090, { 0.660660, 0.495556, 0.396267, 0.332142 } },
	{  9100, { 0.606741, 0.425296, 0.327092, 0.266201 } },
	{  9101, { 0.626335, 0.449237, 0.357001, 0.298544 } },
	{  9110, { 0.645998, 0.460582, 0.357830, 0.289691 } },
	{  9111, { 0.657509, 0.486536, 0.383815, 0.322174 } },
	{  9120, { 0.699304, 0.529890, 0.420874, 0.350739 } },
	{  9121, { 0.711152, 0.550163, 0.444167, 0.379029 } },
	{ 10100, { 0.698831, 0.534374, 0.436462, 0.369034 } },
	{ 10110, { 0.660376, 0.479650, 0.373328, 0.304814 } },
	{ 10111, { 0.677518, 0.502799, 0.401653, 0.334030 } },
	{ 10120, { 0.718249, 0.550870, 0.440722, 0.365350 } },
	{ 10121, { 0.732486, 0.566302, 0.463868, 0.391412 } },
	{ 11110, { 0.757306, 0.604317, 0.501322, 0.428978 } },
	{ 11120, { 0.745230, 0.580949, 0.472283, 0.393985 } },
	{ 11121, { 0.754219, 0.599772, 0.495033, 0.416241 } },
	{ 12120, { 0.855608, 0.736617, 0.642366, 0.562044 } }
};

static const RoundData FlopValues[] =
{
	{   106, { 0.160312, 0.078750, 0.048325, 0.033350 } },
	{   206, { 0.185012, 0.099666, 0.071425, 0.053450 } },
	{   306, { 0.199662, 0.115567, 0.081625, 0.067500 } },
	{   406, { 0.199712, 0.121383, 0.088775, 0.070750 } },
	{  1206, { 0.191537, 0.110250, 0.078400, 0.057350 } },
	{  1306, { 0.212125, 0.119433, 0.089325, 0.071200 } },
	{  1406, { 0.219762, 0.133983, 0.101875, 0.080000 } },
	{  2306, { 0.228400, 0.142983, 0.103950, 0.087900 } },
	{  2406, { 0.242275, 0.155600, 0.124050, 0.100400 } },
	{  3406, { 0.237262, 0.164333, 0.125725, 0.099750 } },
	{   107, { 0.165612, 0.083566, 0.054850, 0.043750 } },
	{   207, { 0.183363, 0.101283, 0.068825, 0.054500 } },
	{   307, { 0.203250, 0.114933, 0.081875, 0.068600 } },
	{   407, { 0.221225, 0.119917, 0.085025, 0.065600 } },
	{  1207, { 0.199200, 0.113817, 0.078950, 0.061400 } },
	{  1307, { 0.214062, 0.126883, 0.092250, 0.075100 } },
	{  1407, { 0.245438, 0.141217, 0.102000, 0.081350 } },
	{  2307, { 0.231950, 0.141733, 0.105300, 0.084550 } },
	{  2407, { 0.267275, 0.166483, 0.126300, 0.101750 } },
	{  3407, { 0.257300, 0.168650, 0.129225, 0.100700 } },
	{   108, { 0.169475, 0.082066, 0.052325, 0.037950 } },
	{   208, { 0.186787, 0.100850, 0.070175, 0.052000 } },
	{   308, { 0.215725, 0.112733, 0.073875, 0.054150 } },
	{   408, { 0.253450, 0.134367, 0.092525, 0.072050 } },
	{  1208, { 0.195000, 0.111100, 0.077225, 0.056750 } },
	{  1308, { 0.235763, 0.123700, 0.084700, 0.065500 } },
	{  1408, { 0.262225, 0.140717, 0.099175, 0.074350 } },
	{  2308, { 0.242300, 0.135200, 0.096750, 0.074400 } },
	{  2408, { 0.287313, 0.160033, 0.116075, 0.094650 } },
	{  3408, { 0.277012, 0.163533, 0.116650, 0.095300 } },
	{   109, { 0.186037, 0.085966, 0.051825, 0.038350 } },
	{   209, { 0.200400, 0.098150, 0.066675, 0.050650 } },
	{   309, { 0.220688, 0.108317, 0.073075, 0.052350 } },
	{   409, { 0.275813, 0.135517, 0.086325, 0.063050 } },
	{  1209, { 0.219025, 0.115400, 0.080150, 0.061800 } },
	{  1309, { 0.246425, 0.130383, 0.092425, 0.068150 } },
	{  1409, { 0.304438, 0.158233, 0.108500, 0.081800 } },
	{  2309, { 0.254300, 0.143233, 0.104850, 0.079500 } },
	{  2409, { 0.326638, 0.178833, 0.127100, 0.099550 } },
	{  3409, { 0.323150, 0.178717, 0.129425, 0.097950 } },
	{   110, { 0.190100, 0.071466, 0.035575, 0.021400 } },
	{   210, { 0.213588, 0.085183, 0.046225, 0.028200 } },
	{   310, { 0.275788, 0.119583, 0.068500, 0.044200 } },
	{   410, { 0.320487, 0.149867, 0.090450, 0.068700 } },
	{  1210, { 0.225675, 0.098333, 0.056975, 0.036900 } },
	{  1310, { 0.302862, 0.133517, 0.078175, 0.052900 } },
	{  1410, { 0.344763, 0.168200, 0.106625, 0.075650 } },
	{  2310, { 0.310525, 0.151150, 0.092025, 0.066950 } },
	{  2410, { 0.365463, 0.188500, 0.121275, 0.093100 } },
	{  3410, { 0.386962, 0.214933, 0.151325, 0.119000 } },
	{   111, { 0.191887, 0.074800, 0.036500, 0.023150 } },
	{   211, { 0.197437, 0.074633, 0.038425, 0.021600 } },
	{   311, { 0.279463, 0.118717, 0.068550, 0.045300 } },
	{   411, { 0.375588, 0.179217, 0.106850, 0.074700 } },
	{  1211, { 0.226475, 0.101767, 0.058650, 0.037050 } },
	{  1311, { 0.302500, 0.135333, 0.078800, 0.054450 } },
	{  1411, { 0.402687, 0.198867, 0.126825, 0.083850 } },
	{  2311, { 0.311925, 0.150033, 0.097125, 0.066200 } },
	{  2411, { 0.420350, 0.219233, 0.141225, 0.100850 } },
	{  3411, { 0.476650, 0.281733, 0.202000, 0.160500 } },
	{   112, { 0.271713, 0.106417, 0.054675, 0.029350 } },
	{   212, { 0.305475, 0.124833, 0.068875, 0.039100 } },
	{   312, { 0.393087, 0.183367, 0.100875, 0.064600 } },
	{   412, { 0.453037, 0.240100, 0.146400, 0.101700 } },
	{  1212, { 0.310725, 0.143767, 0.078825, 0.049750 } },
	{  1312, { 0.420900, 0.205133, 0.117425, 0.078750 } },
	{  1412, { 0.481088, 0.263833, 0.160975, 0.114650 } },
	{  2312, { 0.422438, 0.215050, 0.133150, 0.089900 } },
	{  2412, { 0.498025, 0.283417, 0.184950, 0.133700 } },
	{  3412, { 0.509725, 0.303550, 0.211825, 0.153700 } },
	{ 10201, { 0.277375, 0.133517, 0.076325, 0.042900 } },
	{ 10102, { 0.317775, 0.177483, 0.112400, 0.077850 } },
	{ 10202, { 0.291087, 0.147300, 0.085675, 0.051200 } },
	{ 10103, { 0.328775, 0.179900, 0.113375, 0.079500 } },
	{ 10203, { 0.295988, 0.150617, 0.089500, 0.056800 } },
	{ 10104, { 0.315550, 0.168617, 0.103550, 0.068600 } },
	{ 10204, { 0.308200, 0.155367, 0.093075, 0.056450 } },
	{ 10005, { 0.270150, 0.170433, 0.124725, 0.096250 } },
	{ 10105, { 0.296262, 0.172950, 0.126950, 0.095050 } },
	{ 10205, { 0.336438, 0.172217, 0.103250, 0.068550 } },
	{ 10006, { 0.289838, 0.171233, 0.128600, 0.096950 } },
	{ 10106, { 0.324525, 0.182750, 0.130125, 0.101000 } },
	{ 10206, { 0.381512, 0.197733, 0.124625, 0.086700 } },
	{ 10007, { 0.310425, 0.175450, 0.128100, 0.096550 } },
	{ 10107, { 0.367663, 0.207800, 0.144725, 0.110750 } },
	{ 10207, { 0.425438, 0.224617, 0.138200, 0.092250 } },
	{ 10008, { 0.352000, 0.194683, 0.136925, 0.103950 } },
	{ 10108, { 0.422225, 0.237950, 0.164950, 0.121300 } },
	{ 10208, { 0.485413, 0.273783, 0.171725, 0.114450 } },
	{ 10009, { 0.397750, 0.222400, 0.151450, 0.116250 } },
	{ 10109, { 0.470425, 0.261367, 0.170925, 0.121600 } },
	{ 10209, { 0.532787, 0.305733, 0.190700, 0.118150 } },
	{ 10010, { 0.454037, 0.251483, 0.168825, 0.126050 } },
	{ 10110, { 0.550462, 0.334933, 0.229600, 0.167950 } },
	{ 10210, { 0.613350, 0.392250, 0.259175, 0.174450 } },
	{ 10011, { 0.526900, 0.317983, 0.217350, 0.153850 } },
	{ 10111, { 0.642038, 0.431733, 0.313825, 0.236850 } },
	{ 10012, { 0.611275, 0.396950, 0.277325, 0.206950 } },
	{ 11200, { 0.573987, 0.362933, 0.252050, 0.192800 } },
	{ 11101, { 0.635763, 0.427050, 0.305575, 0.227200 } },
	{ 11201, { 0.579963, 0.368700, 0.259525, 0.193700 } },
	{ 11002, { 0.641050, 0.437717, 0.313950, 0.235550 } },
	{ 11102, { 0.654863, 0.449200, 0.321575, 0.247450 } },
	{ 11202, { 0.597325, 0.389683, 0.268975, 0.203750 } },
	{ 11003, { 0.647775, 0.442267, 0.316825, 0.243500 } },
	{ 11103, { 0.654050, 0.446483, 0.320175, 0.245900 } },
	{ 11203, { 0.627513, 0.412067, 0.290050, 0.212450 } },
	{ 11004, { 0.689688, 0.487583, 0.362425, 0.266950 } },
	{ 11104, { 0.673050, 0.468117, 0.336500, 0.260750 } },
	{ 11204, { 0.651563, 0.437467, 0.313000, 0.230700 } },
	{ 11005, { 0.731213, 0.553867, 0.428225, 0.340550 } },
	{ 11105, { 0.697263, 0.497867, 0.368350, 0.288650 } },
	{ 11205, { 0.661388, 0.454883, 0.325175, 0.247450 } },
	{ 11006, { 0.753262, 0.580283, 0.452975, 0.366400 } },
	{ 11106, { 0.716875, 0.529517, 0.399350, 0.310700 } },
	{ 11206, { 0.679713, 0.473533, 0.346825, 0.255500 } },
	{ 11007, { 0.780038, 0.616067, 0.488425, 0.400650 } },
	{ 11107, { 0.743613, 0.565267, 0.439275, 0.344200 } },
	{ 11207, { 0.665825, 0.462400, 0.333175, 0.252750 } },
	{ 11008, { 0.801338, 0.649083, 0.529225, 0.437450 } },
	{ 11108, { 0.747300, 0.571033, 0.439275, 0.343300 } },
	{ 11208, { 0.665063, 0.462650, 0.334500, 0.250000 } },
	{ 11009, { 0.795763, 0.640850, 0.516675, 0.427450 } },
	{ 11109, { 0.765500, 0.594217, 0.458475, 0.370950 } },
	{ 11209, { 0.694300, 0.492983, 0.361300, 0.269800 } },
	{ 11010, { 0.818762, 0.677283, 0.564350, 0.469850 } },
	{ 11110, { 0.755775, 0.577433, 0.448450, 0.347350 } },
	{ 11210, { 0.709525, 0.511550, 0.379400, 0.291150 } },
	{ 11011, { 0.843975, 0.713083, 0.610900, 0.520750 } },
	{ 11111, { 0.807163, 0.651467, 0.525225, 0.432100 } },
	{ 11012, { 0.866263, 0.749767, 0.655075, 0.569900 } },
	{ 12300, { 0.446325, 0.224100, 0.133125, 0.097100 } },
	{ 12201, { 0.541987, 0.314517, 0.195500, 0.133600 } },
	{ 12301, { 0.460913, 0.241117, 0.145000, 0.097950 } },
	{ 12102, { 0.641775, 0.424583, 0.289350, 0.206500 } },
	{ 12202, { 0.565462, 0.330867, 0.212075, 0.148150 } },
	{ 12302, { 0.481162, 0.253533, 0.154325, 0.106450 } },
	{ 12103, { 0.655763, 0.442417, 0.305875, 0.222850 } },
	{ 12203, { 0.576050, 0.347733, 0.221600, 0.146250 } },
	{ 12303, { 0.499538, 0.274933, 0.163900, 0.111500 } },
	{ 12104, { 0.667987, 0.449733, 0.310625, 0.223550 } },
	{ 12204, { 0.595762, 0.367533, 0.240700, 0.169500 } },
	{ 12304, { 0.529400, 0.299100, 0.185825, 0.123600 } },
	{ 12005, { 0.709287, 0.502400, 0.365725, 0.270400 } },
	{ 12105, { 0.673400, 0.460317, 0.323550, 0.229950 } },
	{ 12205, { 0.613313, 0.387950, 0.257175, 0.181950 } },
	{ 12305, { 0.544462, 0.309800, 0.191700, 0.129750 } },
	{ 12006, { 0.719650, 0.522967, 0.382550, 0.291200 } },
	{ 12106, { 0.692875, 0.482733, 0.345825, 0.253050 } },
	{ 12206, { 0.633238, 0.413717, 0.276850, 0.195200 } },
	{ 12306, { 0.562913, 0.339250, 0.215550, 0.147250 } },
	{ 12007, { 0.759613, 0.584300, 0.446275, 0.344550 } },
	{ 12107, { 0.709600, 0.507483, 0.371300, 0.274150 } },
	{ 12207, { 0.666238, 0.449700, 0.310075, 0.219450 } },
	{ 12307, { 0.583650, 0.356250, 0.224450, 0.155600 } },
	{ 12008, { 0.767475, 0.593817, 0.463025, 0.370750 } },
	{ 12108, { 0.718925, 0.524250, 0.385325, 0.294600 } },
	{ 12208, { 0.695125, 0.486433, 0.349075, 0.250250 } },
	{ 12009, { 0.787362, 0.623250, 0.502500, 0.397000 } },
	{ 12109, { 0.740750, 0.552867, 0.412425, 0.317100 } },
	{ 12209, { 0.712725, 0.509083, 0.365475, 0.262950 } },
	{ 12010, { 0.826462, 0.686000, 0.570850, 0.483000 } },
	{ 12110, { 0.766262, 0.589100, 0.456425, 0.356700 } },
	{ 12210, { 0.729612, 0.533183, 0.393700, 0.292100 } },
	{ 12011, { 0.833638, 0.701600, 0.588350, 0.496800 } },
	{ 12111, { 0.778250, 0.605767, 0.477175, 0.380450 } },
	{ 12012, { 0.863613, 0.751683, 0.652550, 0.561100 } },
	{ 21000, { 0.625838, 0.410617, 0.270925, 0.190000 } },
	{ 21001, { 0.648913, 0.439150, 0.299050, 0.207200 } },
	{ 21101, { 0.660925, 0.451067, 0.324350, 0.240950 } },
	{ 21002, { 0.679150, 0.472167, 0.334075, 0.247900 } },
	{ 21102, { 0.666275, 0.464717, 0.331075, 0.240200 } },
	{ 21003, { 0.701150, 0.500167, 0.364575, 0.266300 } },
	{ 21103, { 0.686625, 0.481400, 0.351650, 0.262200 } },
	{ 21004, { 0.731800, 0.541583, 0.407800, 0.303500 } },
	{ 21104, { 0.709675, 0.513417, 0.380125, 0.291950 } },
	{ 21005, { 0.755663, 0.579500, 0.440825, 0.339550 } },
	{ 21105, { 0.736100, 0.553650, 0.421150, 0.324500 } },
	{ 21006, { 0.782800, 0.608600, 0.476850, 0.380650 } },
	{ 21106, { 0.760350, 0.581683, 0.457225, 0.358500 } },
	{ 21007, { 0.810125, 0.657750, 0.532425, 0.434600 } },
	{ 21107, { 0.781587, 0.614050, 0.484450, 0.396600 } },
	{ 21008, { 0.795125, 0.637433, 0.513125, 0.413050 } },
	{ 21108, { 0.782750, 0.621833, 0.493250, 0.402300 } },
	{ 21009, { 0.821125, 0.682633, 0.566600, 0.465600 } },
	{ 21109, { 0.811562, 0.663167, 0.536500, 0.449750 } },
	{ 21010, { 0.850012, 0.720967, 0.610900, 0.517400 } },
	{ 21110, { 0.833425, 0.695433, 0.580225, 0.491300 } },
	{ 21011, { 0.881563, 0.773350, 0.678975, 0.596350 } },
	{ 21111, { 0.861350, 0.739867, 0.640600, 0.552200 } },
	{ 21112, { 0.883838, 0.784233, 0.693675, 0.608300 } },
	{ 22000, { 0.494837, 0.276100, 0.173950, 0.121300 } },
	{ 22001, { 0.512687, 0.300783, 0.191075, 0.134950 } },
	{ 22101, { 0.579575, 0.352150, 0.223700, 0.160050 } },
	{ 22002, { 0.539288, 0.318483, 0.207925, 0.148700 } },
	{ 22102, { 0.601537, 0.374417, 0.246825, 0.171800 } },
	{ 22003, { 0.559063, 0.343450, 0.230575, 0.162500 } },
	{ 22103, { 0.624287, 0.398150, 0.266900, 0.191750 } },
	{ 22004, { 0.586975, 0.373667, 0.250275, 0.186900 } },
	{ 22104, { 0.643887, 0.424983, 0.292000, 0.206800 } },
	{ 22005, { 0.619375, 0.412650, 0.288550, 0.209100 } },
	{ 22105, { 0.663300, 0.453867, 0.309300, 0.223150 } },
	{ 22006, { 0.650125, 0.443033, 0.311900, 0.229550 } },
	{ 22106, { 0.684963, 0.475650, 0.336650, 0.248150 } },
	{ 22007, { 0.696263, 0.490017, 0.355825, 0.267800 } },
	{ 22107, { 0.708137, 0.501767, 0.365350, 0.273450 } },
	{ 22008, { 0.738287, 0.549433, 0.413700, 0.314500 } },
	{ 22108, { 0.727075, 0.535983, 0.393100, 0.300650 } },
	{ 22009, { 0.847912, 0.722017, 0.616725, 0.523850 } },
	{ 22109, { 0.812725, 0.658717, 0.543300, 0.446600 } },
	{ 22010, { 0.868900, 0.752417, 0.656675, 0.561700 } },
	{ 22110, { 0.821000, 0.680383, 0.562475, 0.470100 } },
	{ 22011, { 0.888225, 0.785000, 0.693000, 0.612450 } },
	{ 22111, { 0.833363, 0.700750, 0.589450, 0.503050 } },
	{ 22112, { 0.858475, 0.738600, 0.636825, 0.553700 } },
	{ 22201, { 0.856137, 0.742967, 0.651625, 0.574600 } },
	{ 22202, { 0.859688, 0.746217, 0.656150, 0.580900 } },
	{ 22203, { 0.862888, 0.752333, 0.664400, 0.586800 } },
	{ 22204, { 0.858088, 0.742617, 0.649500, 0.571800 } },
	{ 22205, { 0.853263, 0.734683, 0.641875, 0.559850 } },
	{ 22206, { 0.867075, 0.756617, 0.664375, 0.591450 } },
	{ 22207, { 0.872938, 0.766767, 0.678900, 0.605650 } },
	{ 22208, { 0.874800, 0.771667, 0.688800, 0.616650 } },
	{ 22209, { 0.887825, 0.792483, 0.719900, 0.650000 } },
	{ 22210, { 0.895650, 0.808067, 0.735575, 0.671050 } },
	{ 22211, { 0.919162, 0.850183, 0.785825, 0.729700 } },
	{ 22212, { 0.935600, 0.877833, 0.825725, 0.781800 } },
	{ 30001, { 0.344288, 0.222633, 0.164400, 0.127100 } },
	{ 30002, { 0.347087, 0.227383, 0.170950, 0.136900 } },
	{ 30102, { 0.363162, 0.236250, 0.169975, 0.122950 } },
	{ 30003, { 0.353500, 0.234733, 0.177000, 0.140700 } },
	{ 30103, { 0.364412, 0.236583, 0.172325, 0.132450 } },
	{ 30004, { 0.367337, 0.240800, 0.187725, 0.156750 } },
	{ 30104, { 0.371575, 0.243267, 0.184725, 0.138900 } },
	{ 30005, { 0.389600, 0.248250, 0.196350, 0.153950 } },
	{ 30105, { 0.376387, 0.247067, 0.186375, 0.145050 } },
	{ 30006, { 0.422950, 0.269267, 0.211625, 0.179050 } },
	{ 30106, { 0.388362, 0.249483, 0.191125, 0.157850 } },
	{ 30007, { 0.463462, 0.294067, 0.218500, 0.186350 } },
	{ 30107, { 0.416438, 0.258417, 0.200850, 0.163700 } },
	{ 30008, { 0.512837, 0.321717, 0.238700, 0.197850 } },
	{ 30108, { 0.466575, 0.291450, 0.223225, 0.184350 } },
	{ 30009, { 0.577688, 0.379667, 0.282675, 0.217700 } },
	{ 30109, { 0.518075, 0.330517, 0.245975, 0.199450 } },
	{ 30010, { 0.645362, 0.447467, 0.331675, 0.263600 } },
	{ 30110, { 0.577037, 0.370500, 0.274075, 0.212850 } },
	{ 30011, { 0.718850, 0.532200, 0.412975, 0.335200 } },
	{ 30111, { 0.642912, 0.441300, 0.324475, 0.253150 } },
	{ 30112, { 0.715350, 0.528400, 0.403125, 0.326600 } },
	{ 41104, { 0.311063, 0.191417, 0.143925, 0.111150 } },
	{ 41204, { 0.622650, 0.408700, 0.282950, 0.208600 } },
	{ 41005, { 0.241925, 0.148983, 0.109150, 0.078200 } },
	{ 41105, { 0.353787, 0.204000, 0.147650, 0.110350 } },
	{ 41205, { 0.637350, 0.427133, 0.301150, 0.219250 } },
	{ 41006, { 0.262412, 0.162067, 0.120525, 0.091800 } },
	{ 41106, { 0.374837, 0.216017, 0.156400, 0.121500 } },
	{ 41206, { 0.654100, 0.446733, 0.315550, 0.227350 } },
	{ 41007, { 0.281788, 0.166167, 0.119675, 0.090250 } },
	{ 41107, { 0.417137, 0.238983, 0.166225, 0.126500 } },
	{ 41207, { 0.673787, 0.468433, 0.336425, 0.245300 } },
	{ 41008, { 0.294438, 0.160567, 0.108150, 0.080150 } },
	{ 41108, { 0.469050, 0.273150, 0.181300, 0.140800 } },
	{ 41208, { 0.694975, 0.492300, 0.357850, 0.263450 } },
	{ 41009, { 0.327000, 0.172217, 0.113000, 0.081250 } },
	{ 41109, { 0.525288, 0.312350, 0.207875, 0.149050 } },
	{ 41209, { 0.711425, 0.518733, 0.378975, 0.290700 } },
	{ 41010, { 0.382525, 0.202600, 0.131125, 0.096650 } },
	{ 41110, { 0.529775, 0.321067, 0.214900, 0.154300 } },
	{ 41210, { 0.743725, 0.556700, 0.417775, 0.317000 } },
	{ 41011, { 0.413625, 0.212317, 0.136275, 0.095900 } },
	{ 41211, { 0.762962, 0.588517, 0.456225, 0.355800 } },
	{ 41012, { 0.492750, 0.298683, 0.221950, 0.185600 } },
	{ 41212, { 0.834475, 0.703650, 0.590950, 0.507050 } },
	{ 42004, { 0.272075, 0.189533, 0.154000, 0.130900 } },
	{ 42204, { 0.558087, 0.350000, 0.238125, 0.171450 } },
	{ 42005, { 0.293525, 0.196417, 0.156200, 0.138000 } },
	{ 42205, { 0.574750, 0.361550, 0.250350, 0.179300 } },
	{ 42006, { 0.322700, 0.204917, 0.159825, 0.138950 } },
	{ 42206, { 0.592150, 0.382783, 0.260500, 0.193550 } },
	{ 42007, { 0.354563, 0.217383, 0.170950, 0.147300 } },
	{ 42207, { 0.614363, 0.399333, 0.278975, 0.199000 } },
	{ 42008, { 0.383175, 0.232967, 0.176525, 0.149850 } },
	{ 42208, { 0.632000, 0.419717, 0.295275, 0.212400 } },
	{ 42009, { 0.380225, 0.237933, 0.187000, 0.151900 } },
	{ 42209, { 0.651100, 0.440883, 0.307875, 0.223250 } },
	{ 42010, { 0.432150, 0.273117, 0.208100, 0.175100 } },
	{ 42210, { 0.680638, 0.472867, 0.336475, 0.245050 } },
	{ 42011, { 0.486375, 0.309800, 0.239700, 0.202900 } },
	{ 42211, { 0.703037, 0.499717, 0.368450, 0.272750 } },
	{ 42012, { 0.539112, 0.356167, 0.271325, 0.235650 } },
	{ 42212, { 0.774487, 0.610033, 0.485250, 0.399300 } },
	{ 43104, { 0.409863, 0.271383, 0.221500, 0.193500 } },
	{ 43204, { 0.674612, 0.484033, 0.367575, 0.292950 } },
	{ 43005, { 0.273612, 0.200917, 0.165400, 0.149900 } },
	{ 43105, { 0.417563, 0.270517, 0.221725, 0.195200 } },
	{ 43205, { 0.684512, 0.498017, 0.378375, 0.305750 } },
	{ 43006, { 0.309837, 0.220700, 0.186450, 0.170800 } },
	{ 43106, { 0.430175, 0.290183, 0.239550, 0.212950 } },
	{ 43206, { 0.693287, 0.504233, 0.389650, 0.311650 } },
	{ 43007, { 0.333612, 0.221617, 0.184400, 0.161500 } },
	{ 43107, { 0.474075, 0.315533, 0.250375, 0.221250 } },
	{ 43207, { 0.714700, 0.529633, 0.403875, 0.332650 } },
	{ 43008, { 0.366375, 0.235083, 0.191950, 0.171900 } },
	{ 43108, { 0.478425, 0.318050, 0.256450, 0.218950 } },
	{ 43208, { 0.730437, 0.556533, 0.435500, 0.349800 } },
	{ 43009, { 0.394825, 0.241567, 0.189150, 0.165250 } },
	{ 43109, { 0.582588, 0.391300, 0.306525, 0.258850 } },
	{ 43209, { 0.754012, 0.580250, 0.462725, 0.377800 } },
	{ 43010, { 0.445638, 0.270467, 0.203300, 0.174450 } },
	{ 43110, { 0.581725, 0.391300, 0.296350, 0.244000 } },
	{ 43210, { 0.774787, 0.608450, 0.486750, 0.405050 } },
	{ 43011, { 0.493063, 0.298867, 0.218075, 0.174500 } },
	{ 43211, { 0.795150, 0.640217, 0.524175, 0.430450 } },
	{ 43012, { 0.554212, 0.354300, 0.263500, 0.210650 } },
	{ 43212, { 0.817175, 0.673367, 0.567850, 0.482750 } },
	{ 44004, { 0.307038, 0.228567, 0.195650, 0.175900 } },
	{ 44204, { 0.658875, 0.465283, 0.344600, 0.268000 } },
	{ 44005, { 0.329525, 0.231150, 0.197550, 0.172200 } },
	{ 44205, { 0.675550, 0.480683, 0.358925, 0.279700 } },
	{ 44006, { 0.362038, 0.249583, 0.202575, 0.178200 } },
	{ 44206, { 0.695137, 0.501583, 0.380750, 0.303800 } },
	{ 44007, { 0.396062, 0.259800, 0.212000, 0.185900 } },
	{ 44207, { 0.710562, 0.522133, 0.402875, 0.313250 } },
	{ 44008, { 0.409938, 0.284817, 0.239925, 0.214050 } },
	{ 44208, { 0.729025, 0.545667, 0.423575, 0.327600 } },
	{ 44009, { 0.441763, 0.299717, 0.246700, 0.216600 } },
	{ 44209, { 0.749025, 0.575000, 0.452725, 0.361400 } },
	{ 44010, { 0.486963, 0.324150, 0.258175, 0.216700 } },
	{ 44210, { 0.779200, 0.613317, 0.491025, 0.396800 } },
	{ 44011, { 0.544312, 0.368567, 0.289350, 0.244350 } },
	{ 44211, { 0.807025, 0.663100, 0.550800, 0.457450 } },
	{ 44012, { 0.602287, 0.418417, 0.322750, 0.264100 } },
	{ 44212, { 0.833538, 0.697883, 0.591800, 0.495950 } },
	{ 45103, { 0.446537, 0.320717, 0.258300, 0.229650 } },
	{ 45203, { 0.660650, 0.475000, 0.364250, 0.291550 } },
	{ 45104, { 0.449338, 0.315950, 0.256475, 0.216550 } },
	{ 45204, { 0.669375, 0.477967, 0.357125, 0.286200 } },
	{ 45005, { 0.354975, 0.267583, 0.218450, 0.186250 } },
	{ 45105, { 0.451525, 0.319533, 0.254850, 0.220550 } },
	{ 45205, { 0.685837, 0.490700, 0.370900, 0.298350 } },
	{ 45006, { 0.374312, 0.270217, 0.223775, 0.187900 } },
	{ 45106, { 0.492350, 0.333350, 0.260700, 0.220150 } },
	{ 45206, { 0.700025, 0.512533, 0.395450, 0.314200 } },
	{ 45007, { 0.396838, 0.276150, 0.226725, 0.195000 } },
	{ 45107, { 0.502000, 0.341300, 0.272350, 0.227850 } },
	{ 45207, { 0.715512, 0.528850, 0.408850, 0.323650 } },
	{ 45008, { 0.421350, 0.283000, 0.225525, 0.187700 } },
	{ 45108, { 0.543037, 0.368167, 0.283500, 0.237700 } },
	{ 45208, { 0.729588, 0.551767, 0.429675, 0.340050 } },
	{ 45009, { 0.458587, 0.295383, 0.230075, 0.189400 } },
	{ 45109, { 0.587450, 0.403633, 0.311325, 0.250400 } },
	{ 45209, { 0.747225, 0.571583, 0.449975, 0.360700 } },
	{ 45010, { 0.494925, 0.321633, 0.246600, 0.199150 } },
	{ 45110, { 0.626425, 0.454617, 0.366225, 0.319700 } },
	{ 45210, { 0.768275, 0.598867, 0.476275, 0.387300 } },
	{ 45011, { 0.564175, 0.402817, 0.341375, 0.308450 } },
	{ 45211, { 0.835438, 0.712033, 0.618225, 0.548900 } },
	{ 46003, { 0.393412, 0.325133, 0.290800, 0.262650 } },
	{ 46203, { 0.616788, 0.428533, 0.332000, 0.270250 } },
	{ 46004, { 0.408050, 0.324033, 0.290675, 0.273100 } },
	{ 46204, { 0.621762, 0.428233, 0.330775, 0.263500 } },
	{ 46005, { 0.426350, 0.331800, 0.294425, 0.275050 } },
	{ 46205, { 0.637687, 0.442550, 0.339525, 0.274300 } },
	{ 46006, { 0.424287, 0.298133, 0.242425, 0.208950 } },
	{ 46206, { 0.650700, 0.460850, 0.345900, 0.274650 } },
	{ 46007, { 0.456813, 0.311117, 0.242075, 0.205300 } },
	{ 46207, { 0.670850, 0.475450, 0.359300, 0.281500 } },
	{ 46008, { 0.489600, 0.325300, 0.256975, 0.215200 } },
	{ 46208, { 0.684512, 0.491350, 0.376250, 0.298350 } },
	{ 46009, { 0.523763, 0.378883, 0.326650, 0.289750 } },
	{ 46209, { 0.702950, 0.515500, 0.390650, 0.306250 } },
	{ 46010, { 0.566300, 0.411217, 0.355550, 0.324150 } },
	{ 46210, { 0.720163, 0.538167, 0.419300, 0.329400 } },
	{ 46011, { 0.612413, 0.458083, 0.383525, 0.338000 } },
	{ 46211, { 0.788062, 0.642550, 0.538650, 0.467050 } },
	{ 47103, { 0.471550, 0.373750, 0.339475, 0.320850 } },
	{ 47203, { 0.712512, 0.547183, 0.449275, 0.393250 } },
	{ 47104, { 0.475825, 0.373333, 0.330600, 0.303850 } },
	{ 47204, { 0.715800, 0.549467, 0.452925, 0.389600 } },
	{ 47005, { 0.393350, 0.323100, 0.291775, 0.273500 } },
	{ 47105, { 0.505525, 0.382067, 0.335800, 0.312800 } },
	{ 47205, { 0.726325, 0.563583, 0.462500, 0.398700 } },
	{ 47006, { 0.409537, 0.327417, 0.298125, 0.279350 } },
	{ 47106, { 0.513325, 0.379950, 0.337075, 0.312600 } },
	{ 47206, { 0.743337, 0.574517, 0.476475, 0.403150 } },
	{ 47007, { 0.431150, 0.331817, 0.294775, 0.280500 } },
	{ 47107, { 0.549813, 0.403817, 0.348025, 0.318450 } },
	{ 47207, { 0.758500, 0.603533, 0.494375, 0.422850 } },
	{ 47008, { 0.465612, 0.343300, 0.298125, 0.279450 } },
	{ 47108, { 0.589638, 0.435017, 0.364825, 0.326650 } },
	{ 47208, { 0.773550, 0.620767, 0.512475, 0.446550 } },
	{ 47009, { 0.498600, 0.360433, 0.306375, 0.280400 } },
	{ 47109, { 0.638363, 0.480517, 0.390100, 0.343050 } },
	{ 47209, { 0.793125, 0.644517, 0.538925, 0.467600 } },
	{ 47010, { 0.537250, 0.381883, 0.320025, 0.287450 } },
	{ 47110, { 0.650475, 0.488167, 0.406400, 0.362350 } },
	{ 47210, { 0.808975, 0.667967, 0.566075, 0.487500 } },
	{ 47011, { 0.574788, 0.410933, 0.343250, 0.307450 } },
	{ 47211, { 0.829862, 0.702650, 0.604125, 0.536500 } },
	{ 48003, { 0.437437, 0.372950, 0.345550, 0.321600 } },
	{ 48203, { 0.758550, 0.601850, 0.499875, 0.436700 } },
	{ 48004, { 0.447738, 0.377883, 0.345675, 0.325550 } },
	{ 48204, { 0.738812, 0.578317, 0.474075, 0.406200 } },
	{ 48005, { 0.465250, 0.385383, 0.347550, 0.322950 } },
	{ 48205, { 0.754475, 0.590500, 0.489050, 0.417700 } },
	{ 48006, { 0.485762, 0.392267, 0.355850, 0.335850 } },
	{ 48206, { 0.770100, 0.612867, 0.509100, 0.440600 } },
	{ 48007, { 0.513262, 0.407900, 0.362625, 0.332900 } },
	{ 48207, { 0.784737, 0.636200, 0.527375, 0.458650 } },
	{ 48008, { 0.549225, 0.424117, 0.375525, 0.349150 } },
	{ 48208, { 0.801113, 0.660333, 0.550825, 0.474000 } },
	{ 48009, { 0.562100, 0.447650, 0.398400, 0.369750 } },
	{ 48209, { 0.820037, 0.682783, 0.580650, 0.504050 } },
	{ 48010, { 0.597800, 0.470500, 0.408600, 0.383350 } },
	{ 48210, { 0.834775, 0.709433, 0.607925, 0.533750 } },
	{ 48011, { 0.638713, 0.500050, 0.437450, 0.395450 } },
	{ 48211, { 0.854437, 0.742983, 0.650175, 0.577100 } },
	{ 50005, { 0.510262, 0.313833, 0.218400, 0.154900 } },
	{ 50006, { 0.525575, 0.335667, 0.233525, 0.178550 } },
	{ 50007, { 0.562262, 0.376000, 0.277625, 0.215050 } },
	{ 50008, { 0.579575, 0.398367, 0.308200, 0.237200 } },
	{ 50009, { 0.633363, 0.452767, 0.361100, 0.293650 } },
	{ 50010, { 0.647537, 0.484900, 0.385475, 0.331150 } },
	{ 50011, { 0.677488, 0.526450, 0.447275, 0.392600 } },
	{ 50103, { 0.599825, 0.397350, 0.275725, 0.204050 } },
	{ 50104, { 0.567913, 0.353483, 0.233500, 0.158700 } },
	{ 50105, { 0.544125, 0.342167, 0.237425, 0.171400 } },
	{ 50106, { 0.556462, 0.367967, 0.265450, 0.197150 } },
	{ 50107, { 0.580688, 0.399833, 0.297825, 0.234800 } },
	{ 50108, { 0.608387, 0.433967, 0.340575, 0.277950 } },
	{ 50109, { 0.658687, 0.485533, 0.390100, 0.332800 } },
	{ 50110, { 0.679175, 0.521367, 0.437575, 0.385000 } },
	{ 50201, { 0.499700, 0.279550, 0.172150, 0.106200 } },
	{ 50202, { 0.510413, 0.295367, 0.188475, 0.129700 } },
	{ 50203, { 0.526737, 0.318817, 0.216700, 0.148500 } },
	{ 50204, { 0.544312, 0.342083, 0.234125, 0.168750 } },
	{ 50205, { 0.562500, 0.367067, 0.264075, 0.197300 } },
	{ 50206, { 0.578600, 0.391483, 0.287625, 0.222050 } },
	{ 50207, { 0.633262, 0.447267, 0.341525, 0.269100 } },
	{ 50207, { 0.634100, 0.445667, 0.338500, 0.268000 } },
	{ 50207, { 0.632000, 0.444467, 0.341475, 0.268700 } },
	{ 50300, { 0.522600, 0.300500, 0.184175, 0.114950 } },
	{ 50301, { 0.534013, 0.316800, 0.203550, 0.133100 } },
	{ 50302, { 0.542975, 0.334133, 0.216025, 0.145900 } },
	{ 50303, { 0.573950, 0.358667, 0.244925, 0.177350 } },
	{ 50304, { 0.582725, 0.384033, 0.267600, 0.197450 } },
	{ 50305, { 0.592800, 0.400850, 0.294125, 0.230250 } },
	{ 50306, { 0.607100, 0.429083, 0.330500, 0.264200 } },
	{ 51005, { 0.517325, 0.400183, 0.320550, 0.259850 } },
	{ 51006, { 0.476925, 0.357450, 0.279500, 0.220200 } },
	{ 51007, { 0.453912, 0.328583, 0.258825, 0.198350 } },
	{ 51008, { 0.488387, 0.358700, 0.286150, 0.228150 } },
	{ 51009, { 0.519250, 0.375967, 0.308500, 0.255700 } },
	{ 51010, { 0.557338, 0.410900, 0.342025, 0.296150 } },
	{ 51011, { 0.621525, 0.474133, 0.406375, 0.365400 } },
	{ 51012, { 0.679325, 0.538100, 0.468975, 0.427500 } },
	{ 51104, { 0.455338, 0.338717, 0.256075, 0.199200 } },
	{ 51105, { 0.411425, 0.287100, 0.210625, 0.155700 } },
	{ 51106, { 0.447437, 0.314667, 0.240000, 0.182600 } },
	{ 51107, { 0.468250, 0.332183, 0.257425, 0.208100 } },
	{ 51108, { 0.507437, 0.364967, 0.291425, 0.240100 } },
	{ 51109, { 0.551700, 0.404933, 0.333700, 0.280950 } },
	{ 51110, { 0.615150, 0.467283, 0.391525, 0.347700 } },
	{ 51111, { 0.666162, 0.519900, 0.449650, 0.407100 } },
	{ 51201, { 0.366287, 0.215917, 0.134950, 0.088450 } },
	{ 51202, { 0.389300, 0.230183, 0.152650, 0.098800 } },
	{ 51203, { 0.429663, 0.258150, 0.174750, 0.119100 } },
	{ 51204, { 0.450813, 0.288167, 0.201275, 0.151050 } },
	{ 51205, { 0.491737, 0.320900, 0.230975, 0.173250 } },
	{ 51206, { 0.539750, 0.360683, 0.267825, 0.211450 } },
	{ 51207, { 0.554500, 0.388600, 0.299900, 0.248550 } },
	{ 51208, { 0.653900, 0.502500, 0.419550, 0.360150 } },
	{ 51209, { 0.651688, 0.606217, 0.429275, 0.486300 } },
	{ 51210, { 0.663737, 0.510117, 0.430075, 0.395050 } },
	{ 51300, { 0.374575, 0.212500, 0.133100, 0.085400 } },
	{ 51301, { 0.393663, 0.236817, 0.155525, 0.107650 } },
	{ 51302, { 0.433300, 0.261867, 0.177925, 0.122250 } },
	{ 51303, { 0.473288, 0.295433, 0.205450, 0.148950 } },
	{ 51304, { 0.528250, 0.338267, 0.241275, 0.176950 } },
	{ 51305, { 0.541500, 0.364833, 0.274075, 0.213300 } },
	{ 51306, { 0.585225, 0.404750, 0.304400, 0.245100 } },
	{ 51307, { 0.680837, 0.511117, 0.418425, 0.357800 } },
	{ 52005, { 0.433787, 0.325783, 0.254575, 0.208050 } },
	{ 52006, { 0.434525, 0.313600, 0.231975, 0.173100 } },
	{ 52007, { 0.411488, 0.289517, 0.217100, 0.168100 } },
	{ 52008, { 0.440550, 0.317383, 0.242675, 0.190650 } },
	{ 52009, { 0.497812, 0.357500, 0.286875, 0.236250 } },
	{ 52010, { 0.530238, 0.388467, 0.316000, 0.269350 } },
	{ 52011, { 0.587000, 0.442150, 0.374575, 0.328550 } },
	{ 52012, { 0.644625, 0.497233, 0.438425, 0.401100 } },
	{ 52104, { 0.439450, 0.322667, 0.243000, 0.183300 } },
	{ 52105, { 0.396050, 0.270767, 0.197225, 0.145500 } },
	{ 52106, { 0.426988, 0.296667, 0.222800, 0.167400 } },
	{ 52107, { 0.455850, 0.313850, 0.243925, 0.197550 } },
	{ 52108, { 0.509225, 0.357333, 0.291600, 0.242000 } },
	{ 52109, { 0.545037, 0.393867, 0.321400, 0.278350 } },
	{ 52110, { 0.592600, 0.440233, 0.366100, 0.325250 } },
	{ 52111, { 0.648587, 0.500317, 0.427300, 0.392050 } },
	{ 52202, { 0.359825, 0.235550, 0.152900, 0.109500 } },
	{ 52203, { 0.382650, 0.251150, 0.173950, 0.120400 } },
	{ 52204, { 0.399975, 0.260900, 0.191075, 0.134100 } },
	{ 52205, { 0.426200, 0.280567, 0.208000, 0.154250 } },
	{ 52206, { 0.459788, 0.311433, 0.238600, 0.191850 } },
	{ 52207, { 0.496225, 0.342267, 0.275250, 0.218400 } },
	{ 52208, { 0.553863, 0.398000, 0.323150, 0.282750 } },
	{ 52209, { 0.605888, 0.444450, 0.369800, 0.321600 } },
	{ 52210, { 0.652725, 0.499567, 0.424825, 0.383000 } },
	{ 52301, { 0.364625, 0.219883, 0.144425, 0.094500 } },
	{ 52302, { 0.378400, 0.238967, 0.161425, 0.109800 } },
	{ 52303, { 0.408938, 0.263950, 0.185900, 0.133650 } },
	{ 52304, { 0.432013, 0.283050, 0.207225, 0.155200 } },
	{ 52305, { 0.476237, 0.316733, 0.239075, 0.192950 } },
	{ 52306, { 0.510787, 0.351550, 0.277225, 0.229000 } },
	{ 52307, { 0.553238, 0.390633, 0.313825, 0.265550 } },
	{ 53005, { 0.671550, 0.462267, 0.326050, 0.239800 } },
	{ 53006, { 0.714975, 0.521183, 0.379050, 0.285700 } },
	{ 53007, { 0.725888, 0.539000, 0.401425, 0.312350 } },
	{ 53008, { 0.765875, 0.595433, 0.471975, 0.376500 } },
	{ 53009, { 0.792950, 0.635133, 0.520575, 0.424200 } },
	{ 53010, { 0.816987, 0.677700, 0.570375, 0.484100 } },
	{ 53011, { 0.832275, 0.707483, 0.608725, 0.527600 } },
	{ 53012, { 0.879188, 0.781317, 0.704100, 0.645950 } },
	{ 53102, { 0.646188, 0.431000, 0.297600, 0.212250 } },
	{ 53103, { 0.662075, 0.451183, 0.316450, 0.226250 } },
	{ 53104, { 0.679488, 0.476467, 0.338175, 0.247350 } },
	{ 53105, { 0.685588, 0.486467, 0.355675, 0.262250 } },
	{ 53106, { 0.710063, 0.516383, 0.389000, 0.299000 } },
	{ 53107, { 0.737263, 0.554483, 0.426550, 0.339200 } },
	{ 53108, { 0.769500, 0.602567, 0.484000, 0.391150 } },
	{ 53109, { 0.788512, 0.633800, 0.524600, 0.437200 } },
	{ 53110, { 0.817612, 0.680600, 0.582975, 0.502600 } },
	{ 53111, { 0.832588, 0.712100, 0.629325, 0.562650 } },
	{ 53201, { 0.677300, 0.463333, 0.333250, 0.238700 } },
	{ 53201, { 0.677675, 0.467983, 0.330350, 0.234150 } },
	{ 53203, { 0.708037, 0.505850, 0.371000, 0.274750 } },
	{ 53204, { 0.731738, 0.540933, 0.404050, 0.309350 } },
	{ 53205, { 0.744363, 0.563950, 0.432425, 0.338750 } },
	{ 53206, { 0.769687, 0.599167, 0.473925, 0.375550 } },
	{ 53207, { 0.802450, 0.647200, 0.533025, 0.430750 } },
	{ 53208, { 0.832425, 0.695833, 0.585975, 0.497900 } },
	{ 53209, { 0.855850, 0.736900, 0.642750, 0.561800 } },
	{ 53210, { 0.872650, 0.772550, 0.692250, 0.619650 } },
	{ 53300, { 0.671262, 0.462133, 0.321625, 0.231600 } },
	{ 53301, { 0.686913, 0.481600, 0.342825, 0.249700 } },
	{ 53302, { 0.712013, 0.513850, 0.376300, 0.279150 } },
	{ 53303, { 0.731025, 0.542133, 0.406350, 0.313500 } },
	{ 53304, { 0.761413, 0.587967, 0.449450, 0.348700 } },
	{ 53305, { 0.781200, 0.615433, 0.485325, 0.380500 } },
	{ 53306, { 0.788900, 0.630667, 0.507500, 0.415200 } },
	{ 53307, { 0.803338, 0.658517, 0.548025, 0.464250 } },
	{ 60105, { 0.449263, 0.372250, 0.329725, 0.301050 } },
	{ 60106, { 0.457888, 0.371467, 0.331025, 0.305750 } },
	{ 60107, { 0.465225, 0.372783, 0.327575, 0.301500 } },
	{ 60108, { 0.465237, 0.376017, 0.326300, 0.306300 } },
	{ 60109, { 0.463462, 0.373900, 0.327375, 0.300650 } },
	{ 60110, { 0.484550, 0.380033, 0.334850, 0.306000 } },
	{ 60111, { 0.498262, 0.383467, 0.334500, 0.309250 } },
	{ 60112, { 0.507550, 0.391383, 0.345825, 0.308150 } },
	{ 60205, { 0.464050, 0.387800, 0.341925, 0.314150 } },
	{ 60206, { 0.477787, 0.386600, 0.345400, 0.316300 } },
	{ 60207, { 0.486150, 0.383117, 0.331725, 0.311850 } },
	{ 60208, { 0.495975, 0.393867, 0.344275, 0.314400 } },
	{ 60209, { 0.525800, 0.410417, 0.351100, 0.324100 } },
	{ 60210, { 0.529763, 0.409683, 0.357775, 0.330750 } },
	{ 60211, { 0.552412, 0.415517, 0.360550, 0.330600 } },
	{ 60212, { 0.553475, 0.419217, 0.363925, 0.330700 } },
	{ 60305, { 0.470900, 0.389867, 0.352600, 0.324350 } },
	{ 60306, { 0.493825, 0.394883, 0.351575, 0.320400 } },
	{ 60307, { 0.507075, 0.403533, 0.351175, 0.322750 } },
	{ 60308, { 0.534925, 0.416150, 0.359450, 0.329150 } },
	{ 60309, { 0.577087, 0.437533, 0.385150, 0.346100 } },
	{ 60310, { 0.582462, 0.460883, 0.399325, 0.374550 } },
	{ 60311, { 0.621838, 0.482767, 0.421350, 0.388650 } },
	{ 60312, { 0.665325, 0.521000, 0.451400, 0.426500 } },
	{ 61205, { 0.471450, 0.393600, 0.345100, 0.318200 } },
	{ 61206, { 0.489613, 0.396983, 0.351175, 0.322750 } },
	{ 61207, { 0.488000, 0.393300, 0.347050, 0.319450 } },
	{ 61208, { 0.507012, 0.401367, 0.352875, 0.322700 } },
	{ 61209, { 0.529975, 0.407283, 0.359375, 0.326050 } },
	{ 61210, { 0.538613, 0.420967, 0.373875, 0.339550 } },
	{ 61211, { 0.598113, 0.457800, 0.395250, 0.364400 } },
	{ 61212, { 0.630637, 0.486500, 0.414750, 0.374450 } },
	{ 61305, { 0.484588, 0.402333, 0.358050, 0.326600 } },
	{ 61306, { 0.509900, 0.411400, 0.368800, 0.334250 } },
	{ 61307, { 0.522637, 0.413067, 0.365875, 0.335750 } },
	{ 61308, { 0.555638, 0.431650, 0.380650, 0.349350 } },
	{ 61309, { 0.591175, 0.452767, 0.393800, 0.356700 } },
	{ 61310, { 0.602012, 0.469183, 0.412875, 0.382650 } },
	{ 61311, { 0.631050, 0.492500, 0.434525, 0.397000 } },
	{ 61312, { 0.676462, 0.531650, 0.461650, 0.426000 } },
	{ 62305, { 0.495500, 0.412033, 0.366375, 0.333950 } },
	{ 62306, { 0.519388, 0.424033, 0.372825, 0.344200 } },
	{ 62307, { 0.534613, 0.426467, 0.375600, 0.346250 } },
	{ 62308, { 0.557137, 0.438667, 0.378650, 0.346100 } },
	{ 62309, { 0.594437, 0.458850, 0.397700, 0.360150 } },
	{ 62310, { 0.607625, 0.487617, 0.434500, 0.398800 } },
	{ 62311, { 0.641975, 0.499533, 0.435450, 0.407300 } },
	{ 62312, { 0.703137, 0.561583, 0.487200, 0.444400 } },
	{ 70103, { 0.549350, 0.415500, 0.344525, 0.303000 } },
	{ 70104, { 0.560662, 0.424933, 0.357650, 0.308500 } },
	{ 70105, { 0.566275, 0.438433, 0.364575, 0.313700 } },
	{ 70106, { 0.599775, 0.460033, 0.383200, 0.337550 } },
	{ 70107, { 0.635238, 0.489750, 0.408925, 0.358750 } },
	{ 70108, { 0.593487, 0.470683, 0.405500, 0.365900 } },
	{ 70109, { 0.622250, 0.494050, 0.430375, 0.383850 } },
	{ 70110, { 0.657725, 0.524967, 0.460425, 0.416400 } },
	{ 70111, { 0.696450, 0.567133, 0.501450, 0.460800 } },
	{ 70203, { 0.611600, 0.549250, 0.514275, 0.484950 } },
	{ 70204, { 0.621100, 0.545367, 0.505775, 0.481450 } },
	{ 70205, { 0.634200, 0.551617, 0.515000, 0.486250 } },
	{ 70206, { 0.645563, 0.555433, 0.508525, 0.477150 } },
	{ 70207, { 0.665488, 0.566550, 0.520925, 0.489550 } },
	{ 70208, { 0.681575, 0.593467, 0.550600, 0.524750 } },
	{ 70209, { 0.701113, 0.608083, 0.560450, 0.536300 } },
	{ 70210, { 0.726838, 0.624467, 0.572425, 0.548250 } },
	{ 70211, { 0.754563, 0.656283, 0.594225, 0.558150 } },
	{ 71104, { 0.512750, 0.350417, 0.264550, 0.216200 } },
	{ 71105, { 0.528850, 0.369000, 0.286975, 0.230200 } },
	{ 71106, { 0.547200, 0.393933, 0.309375, 0.251600 } },
	{ 71107, { 0.585550, 0.427233, 0.339825, 0.279150 } },
	{ 71108, { 0.599650, 0.445783, 0.363475, 0.309750 } },
	{ 71109, { 0.572087, 0.433050, 0.361125, 0.316300 } },
	{ 71110, { 0.610487, 0.465467, 0.390825, 0.342150 } },
	{ 71111, { 0.647575, 0.503700, 0.432725, 0.390050 } },
	{ 71112, { 0.703662, 0.562233, 0.494850, 0.460550 } },
	{ 71204, { 0.543100, 0.468933, 0.427475, 0.393500 } },
	{ 71205, { 0.560638, 0.476717, 0.437200, 0.408000 } },
	{ 71206, { 0.578850, 0.483267, 0.440675, 0.408050 } },
	{ 71207, { 0.594387, 0.489250, 0.443050, 0.411900 } },
	{ 71208, { 0.611750, 0.514117, 0.470200, 0.442250 } },
	{ 71209, { 0.636775, 0.532250, 0.486750, 0.450400 } },
	{ 71210, { 0.672350, 0.555367, 0.499375, 0.463250 } },
	{ 71211, { 0.709275, 0.580383, 0.527200, 0.483850 } },
	{ 71212, { 0.751687, 0.628100, 0.560100, 0.516900 } }
};

struct calcHandsData
{
	int hand;
	int data[10][2];
};

static const calcHandsData handChancePreflop[] =
{
	{     0,	{ { 0,0}, { 36,1}, { 40,1}, { 12,1}, { 1,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     10,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     11,	{ { 18,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     20,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     21,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     30,	{ { 19,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     31,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     40,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     41,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     50,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     51,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     60,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     61,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     70,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     71,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     80,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     81,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     90,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     91,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     100,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 2,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     101,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 2,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     111,	{ { 19,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1010,	{ { 0,0}, { 36,1}, { 40,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     1020,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1021,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1030,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1031,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1040,	{ { 19,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1041,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1050,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1051,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1060,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1061,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1070,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1071,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1080,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1081,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1090,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1091,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1100,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1101,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 2,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     1121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2020,	{ { 0,0}, { 35,1}, { 40,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     2030,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2031,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2040,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2041,	{ { 17,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2050,	{ { 18,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2051,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 6,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2060,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2061,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2070,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2071,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2080,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2081,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2090,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2091,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2100,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2101,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     2121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3030,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     3040,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3041,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3050,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 8,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3051,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3060,	{ { 18,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3061,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 6,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3070,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3071,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 5,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3080,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3081,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3090,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3091,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3100,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3101,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3110,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     3121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4040,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     4050,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4051,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4060,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 8,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4061,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4070,	{ { 18,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4071,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 6,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4080,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4081,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 5,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4090,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4091,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4100,	{ { 19,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4101,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     4121,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5050,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     5060,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5061,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5070,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 8,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5071,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5080,	{ { 18,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5081,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 6,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5090,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5091,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5100,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5101,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     5121,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6060,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     6070,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6071,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6080,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 8,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6081,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6090,	{ { 18,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6091,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 6,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6100,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6101,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6110,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6111,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     6121,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7070,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     7080,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7081,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7090,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7091,	{ { 17,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7100,	{ { 19,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7101,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7110,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7111,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     7121,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 2,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8080,	{ { 0,0}, { 35,1}, { 39,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     8090,	{ { 17,1}, { 43,1}, { 22,1}, { 4,1}, { 9,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8091,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 9,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8100,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8101,	{ { 16,1}, { 41,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8110,	{ { 19,1}, { 44,1}, { 23,1}, { 4,1}, { 6,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8111,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     8121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9090,	{ { 0,0}, { 35,1}, { 40,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     9100,	{ { 18,1}, { 44,1}, { 22,1}, { 4,1}, { 7,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9101,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 7,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9110,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9111,	{ { 17,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     9121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 4,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     10100,	{ { 0,0}, { 36,1}, { 40,1}, { 12,1}, { 2,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     10110,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 5,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     10111,	{ { 18,1}, { 42,1}, { 22,1}, { 4,1}, { 5,1}, { 6,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     10120,	{ { 19,1}, { 45,1}, { 23,1}, { 4,1}, { 4,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     10121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     11110,	{ { 0,0}, { 36,1}, { 40,1}, { 12,1}, { 1,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } },
	{     11120,	{ { 20,1}, { 46,1}, { 23,1}, { 4,1}, { 3,1}, { 2,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     11121,	{ { 18,1}, { 43,1}, { 22,1}, { 4,1}, { 3,1}, { 7,1}, { 2,1}, { 0,1}, { 0,1}, { 0,1} } },
	{     12120,	{ { 0,0}, { 36,1}, { 40,1}, { 12,1}, { 1,1}, { 2,1}, { 9,1}, { 1,1}, { 0,1}, { 0,1} } }
};

#define NUM_PREFLOP_VALUES (sizeof(PreflopValues)/sizeof(RoundData))
#define NUM_FLOP_VALUES (sizeof(FlopValues)/sizeof(RoundData))
#define NUM_HAND_CHANCE_PREFLOP (sizeof(handChancePreflop)/sizeof(calcHandsData))

ArrayData::ArrayData()
{
}

ArrayData::~ArrayData()
{
}

void ArrayData::getHandChancePreflop(int handCode, int** values) {

	int check = -1;

	for (unsigned val = 0; val < NUM_HAND_CHANCE_PREFLOP; val++) {
		if(handCode == handChancePreflop[val].hand) {
			check = 1;
			for(int i=0;i<10;i++) {
				for(int j=0;j<2;j++) {
					values[i][j] = handChancePreflop[val].data[i][j];
				}
			}
			break;
		}
	}
	if (check == -1) LOG_ERROR(__FILE__ << " (" << __LINE__ << "): ERROR getHandChancePreflop - " << handCode);

}

vector< vector<int> > ArrayData::getHandChancePreflop(int handCode) {

	int check = -1;

	int i;

	vector< vector<int> > chance(2);

	chance[0].resize(10);
	chance[1].resize(10);

	for(i=0;i<10;i++) {
		chance[0][i] = 0;
		chance[1][i] = 0;
	}

	for (unsigned val = 0; val < NUM_HAND_CHANCE_PREFLOP; val++) {
		if(handCode == handChancePreflop[val].hand) {
			check = 1;
			for(int i=0;i<10;i++) {
				for(int j=0;j<2;j++) {
					chance[j][i] = handChancePreflop[val].data[i][j];
				}
			}
			break;
		}
	}
	if (check == -1) LOG_ERROR(__FILE__ << " (" << __LINE__ << "): ERROR getHandChancePreflop - " << handCode);

	return chance;

}
