/*
XString.h
*/


#ifndef __XSTRING_H
#define __XSTRING_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

typedef int UINT;

class XString {
public:
        // Constructor(s) / Destructors
        //-----------------------------
        XString( const char *Value = "" );
        XString( const XString &Value );
        virtual ~XString() {if ((BufferLen != -1) && (Buffer != NULL)) {delete [] Buffer;}}

        //Operators
        //----------
        const XString & operator = ( const XString &Rhs );
        const XString & operator +=( const XString &Rhs );
        const XString & operator +=( const char );
        int                             operator ==( const XString &Rhs ) const;
        int                             operator !=( const XString &Rhs ) const;
        int                             operator < ( const XString &Rhs ) const;
        int                             operator > ( const XString &Rhs ) const;
        int                             operator <=( const XString &Rhs ) const;
        int                             operator >=( const XString &Rhs ) const;
        char                    operator []( UINT Index ) const;
        char&                   operator []( UINT Index );

        //Methods
        //-------
        //INSPECTORS
        //==========
        char                    charAt( UINT index ) const;
        int                             compareTo( const XString &anotherString ) const;
        const char*             cstr( ) const { return Buffer; }
        int                             endsWith( const XString &suffix ) const;
        int                             equals( const XString &anObject ) const;
        int                             equalsIgnoreCase( const XString &anotherString ) const;
        int                             indexOf( char ch ) const;
        int                             indexOf( char ch, UINT fromIndex ) const;
        int                             indexOf( const XString &str ) const;
        int                             indexOf( const XString &str, UINT fromIndex ) const;
        int                             lastIndexOf( char ch ) const;
        int                             lastIndexOf( char ch, UINT fromIndex ) const;
        int                             lastIndexOf( const XString &str ) const;
        int                             lastIndexOf( const XString &str, UINT fromIndex ) const;
        const UINT              length( ) const { return Length; }
        int                            startsWith( const XString &prefix ) const;
        int                             startsWith( const XString &prefix, UINT toffset ) const;
        XString                 substring( UINT beginIndex ) const;
        XString                 substring( UINT beginIndex, UINT endIndex ) const;
        XString                 toLowerCase( ) const;
        XString                 toUpperCase( ) const;
        XString                 trim( ) const; 
        int                     empty () const;
         
        //Methods
        //-------
        //MODIFIERS
        //=========
        const XString&  concat( const XString &str );
        void                    replace( char oldChar, char newChar );
        void                    replace( const XString& match, const XString& replace );
        void                    Format( const char* fmt, ...);
        void            Cut   ( UINT donde);

        // Friends
        //--------
        friend const XString&   operator + ( XString Lhs, const XString &Rhs );

protected:
        //Members
        //-------
        char *Buffer;                      // Stores the chars
        UINT BufferLen;                   // Max strlen for Buffer
        UINT Length;                             // Length of string

        void GetBuffer(UINT MaxStrLen);
        void Double( );
        void verifyIndex( UINT index, char *debug ) const;
};

//Class Functions
//===============

inline int
XString::empty(void) const
{
    if (strcmp(Buffer, "") == 0) {return 1;} else {return 0;}
}


inline void
XString::GetBuffer(UINT MaxStrLen)
{
        BufferLen = MaxStrLen;
        Buffer = new char[BufferLen + 1];
}

inline void
XString::Double( )
{
        char *temp = Buffer;
        GetBuffer( ++BufferLen * 2 );
        strncpy( Buffer, temp, strlen(temp)+1 );
        delete [] temp;
}

inline void
XString::verifyIndex( UINT index, char *debug ) const
{
        if ( index < 0 || index >= Length )
        {
                fprintf (stderr, "XString.h: Index Out Of Bounds. Function='%s'. Buffer='%s'. Total=%d, index=%d\n", 
                                 debug, Buffer, Length, index);
                exit(1);
        }
}

//Friend Functions
//================
inline const XString &
operator+( XString Lhs, const XString &Rhs ) 
{
        return Lhs += Rhs;
}

#endif
