/*                 
Service_Databases.cc
*/

#include "Service_Databases.h"
#include "ClientDB.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

StringList SLDatabasesPapeleraCopy, SLDatabasesPapeleraCut;
bool InverseDBSort = false;
bool Service_Databases_Initialized = false;

TBuffer dbfilename, whatsearch;

ClientDB *CDB = NULL;

class HTMLPages: public HTMLBasic
  {
  private:
    void BotoneraDBComun (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo, int indexpos);                              
    void BotoneraDBIndex (const char *lang, const char *user, const char *connid, UserOptions *uo, int abeginpage, int atotalrecords, 
                          int apagesize);
  public:
    void PrintDBIndexPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, int indexpos);
    void PrintDBEditRecordPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, int indexpos, const char *recordid); 
    void PrintDBDisplayRecordPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, int indexpos, const char *recordid);    
    void PrintDBMainPage (const char *lang, const char *user, const char *connid, UserOptions *uo);
    void PrintDBDefinePage (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *db_define_name);    
  };

int getIndexPos (const char *envfile, const char *parm1)
  {
  TBuffer anum;
  int indexpos = xatoidef (parm1, -1);
  if (indexpos == -1) 
    {
    cgienv_GetSimpleVarDef (envfile, "indexpos", anum, "1");
    indexpos = xatoidef (anum, 1);
    }
  return indexpos;      
  }  

//retrieve the url for the Service icon
const char *GetService_Databases_ICO_URL (void)
  {
  return skin->getI(L_DATABASES);
  }                   

//Retrieve the ALT tag for the Service icon
const char *GetService_Databases_ICO_ALT (void)
  {
  return L->get(L_DATABASES);
  }

//Retrieve the Service name
const char *GetService_Databases_NAME (void)
  {
  return L->get(L_DATABASES);
  }

//Retrieve the Service Description
const char *GetService_Databases_DESCRIPTION (void)
  {
  return L->get(L_DATABASES_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Databases_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (Service_Databases_Initialized == true) {return true;}
  Service_Databases_Initialized = false;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  LOG ("Initializating Service Databases for user=%s", pd->username);

  Service_Databases_Initialized = true;
  initStr (dbfilename);
  initStr (whatsearch);
  return true;
  }

//Entry point to service end
bool DoService_Databases_END (TProgData *pd)
  {
  if (Service_Databases_Initialized == false) {return true;}    
  Service_Databases_Initialized = false;  
  CDB->DBclose();
  delete CDB;
  return true;
  }

//Entry point to execute a service command
bool DoService_Databases_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  
      
  cmd = pd->cmd;

  if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "copy") == true))
    {
    pd->cmd = CMD_DATABASES_COPY;
    } 
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "duplicate") == true))
    {
    pd->cmd = CMD_DATABASES_DUPLICATE;
    }                                                                                                                        
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "cut") == true))
    {
    pd->cmd = CMD_DATABASES_CUT;
    }                                                                                                                    
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "paste") == true))
    {
    pd->cmd = CMD_DATABASES_PASTE;
    }                                                                             
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "delete") == true))
    {
    pd->cmd = CMD_DATABASES_DELETE;
    }              
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "undelete") == true))
    {
    pd->cmd = CMD_DATABASES_UNDELETE;
    }                                            
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_expunge") == true))
    {
    pd->cmd = CMD_DATABASES_DB_EXPUNGE;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_open") == true))
    {
    pd->cmd = CMD_DATABASES_DB_OPEN;
    }      
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_create") == true))
    {
    pd->cmd = CMD_DATABASES_DB_CREATE;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_rename") == true))
    {
    pd->cmd = CMD_DATABASES_DB_RENAME;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_delete") == true))
    {
    pd->cmd = CMD_DATABASES_DB_DELETE;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_confdelete") == true))
    {
    pd->cmd = CMD_DATABASES_DB_CONFDELETE;
    }      
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_dump") == true))
    {
    pd->cmd = CMD_DATABASES_DB_DUMP;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_import") == true))
    {
    pd->cmd = CMD_DATABASES_DB_IMPORT;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_export") == true))
    {
    pd->cmd = CMD_DATABASES_DB_EXPORT;
    }  
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "newrecord") == true))
    {
    pd->cmd = CMD_DATABASES_NEWRECORD;
    }    
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "editshow") == true))
    {
    pd->cmd = CMD_DATABASES_EDITSHOW;
    }                                                                        
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "editsave") == true))
    {
    pd->cmd = CMD_DATABASES_EDITSAVE;
    }                                    
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "search") == true))
    {
    pd->cmd = CMD_DATABASES_SEARCH;
    }                                    
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "deletesearch") == true))
    {
    pd->cmd = CMD_DATABASES_DELETESEARCH;
    }                                        
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "sync") == true))
    {
    pd->cmd = CMD_DATABASES_SYNC;
    } 
  else if ((cmd == CMD_DATABASES_GO) && (cgienv_ExistsVar (pd->envfile, "db_define") == true))
    {
    pd->cmd = CMD_DATABASES_DB_DEFINE;
    }                                                                                                                        
  else if (cmd == CMD_DATABASES_GO)  //FOR PRESSING INTRO BUTTON WHEN WE ARE WRITING THE STRING TO SEARCH
    {
    pd->cmd = CMD_DATABASES_SEARCH;
    }  

  /*** COMMANDS ***/                                      
  switch (pd->cmd)
    {    
    case (CMD_DATABASES_DB_CREATE):
      {
      TBuffer sterror, db_template, db_create_newname;
      cgienv_GetSimpleVarDef (pd->envfile, "db_template", db_template, "");  
      cgienv_GetSimpleVarDef (pd->envfile, "db_create_newname", db_create_newname, "");          
      if (!creaDatabase (pd->username, db_template, pd->uo->getDatabasesDir(), db_create_newname, sterror)) 
        {pd->html->ErrorPage(sterror);}
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                               
    case (CMD_DATABASES_DB_RENAME):
      {
      TBuffer sterror, db_rename_oldname, db_rename_newname;
      cgienv_GetSimpleVarDef (pd->envfile, "db_rename_oldname", db_rename_oldname, "");                
      cgienv_GetSimpleVarDef (pd->envfile, "db_rename_newname", db_rename_newname, "");          
      if (!renameDatabase (pd->uo->getDatabasesDir(), db_rename_oldname, db_rename_newname, sterror)) 
        {pd->html->ErrorPage(sterror);}
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                                   
    case (CMD_DATABASES_DB_CONFDELETE):
      {
      TBuffer db_delete_name;
      pd->uo->InitStatusLine ();
      cgienv_GetSimpleVarDef (pd->envfile, "db_delete_name", db_delete_name, "");
      pd->html->PrintConfirmPage (iSERVICE_MAIN, "db_delete", pd->stlang, db_delete_name, pd->username, pd->connid, 
                                  pd->uo->getValidator(), pd->uo->getPageId(), pd->uo);                                                    
      break;   
      }                                                   
    case (CMD_DATABASES_DB_DELETE):
      {
      TBuffer db_delete_name, sterror;
      cgienv_GetSimpleVarDef (pd->envfile, "db_delete_name", db_delete_name, "");
      if (!deleteDatabase (pd->uo->getDatabasesDir(), db_delete_name, sterror)) 
        {pd->html->ErrorPage(sterror);}
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                                   
    case (CMD_DATABASES_DB_DUMP):
      {
      TBuffer db_dump_name, sterror;
      cgienv_GetSimpleVarDef (pd->envfile, "db_dump_name", db_dump_name, "");
      pd->uo->InitStatusLine ();
      html->Head ("text/plain", "", "");
      if (!dumpDatabase (pd->uo->getDatabasesDir(), db_dump_name, sterror, pd->xs))
        {pd->html->ErrorPage(sterror);}
      break;   
      }                                                   
    case (CMD_DATABASES_DB_IMPORT):
      {
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                                   
    case (CMD_DATABASES_DB_EXPORT):
      {
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                               
    case (CMD_DATABASES_MAINPAGE):
      {
      pd->uo->InitStatusLine ();
      html->PrintDBMainPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }                                               
    case (CMD_DATABASES_DISPLAYPAGE):
      {
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      pd->uo->InitStatusLine ();
      html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
      break;   
      }   
    case (CMD_DATABASES_SORT):
      {
      int indexpos = 1;
      if (!CDB->Sort (pd->parm1)) 
        {
        pd->html->ErrorPage(CDB->getErrorMsg());
        }
      else
        {                                                    
        pd->uo->InitStatusLine ();
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
        }
      break;   
      } 
    case (CMD_DATABASES_DELETESEARCH):
      {
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      CDB->deleteSearch(); 
      pd->uo->setStatusLine (L->get(MSG_RECORDS_ALL_SHOWN), BLUE);
      html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
      break;   
      }         
    case (CMD_DATABASES_SEARCH):
      {
      TBuffer abuf;
      TFieldName fieldname;
      StringList *SLRes;
      int indexpos = 1;
      
      SLRes = new StringList();      
      cgienv_GetSimpleVarDef (pd->envfile, "fieldtosearch", fieldname, "");
      cgienv_GetSimpleVarDef (pd->envfile, "whatsearch", whatsearch, "");
      if (!CDB->Search (fieldname, whatsearch, SLRes))
        {
        pd->html->ErrorPage(CDB->getErrorMsg());
        }
      else
        {       
        int contsearched = CDB->getFoundRecords(); 
        if (contsearched <= 0) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSFOUND_0));}
        else if (contsearched == 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSFOUND), contsearched);}
        else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSFOUND_S), contsearched);}
        pd->uo->setStatusLine (abuf, BLUE);                                            
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
        }
      delete SLRes;  
      break;   
      } 
   case (CMD_DATABASES_DISPLAYRECORD):
      {
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      pd->uo->InitStatusLine ();
      html->PrintDBDisplayRecordPage(pd->stlang, pd->username, pd->connid, pd->uo, indexpos, pd->parm2);                  
      break;
      }                  
   case (CMD_DATABASES_EDITSHOW):
      {
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      pd->uo->InitStatusLine ();
      html->PrintDBEditRecordPage(pd->stlang, pd->username, pd->connid, pd->uo, indexpos, pd->parm2);                  
      break;
      }            
    case (CMD_DATABASES_EDITSAVE):
      {
      TUniqId recordid;
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      cgienv_GetSimpleVarDef (pd->envfile, "recordid", recordid, "-1");
      if (!CDB->SaveRecordFromCGI (pd->envfile, recordid)) 
        {
        pd->html->ErrorPage(CDB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintDBEditRecordPage(pd->stlang, pd->username, pd->connid, pd->uo, indexpos, recordid);
        }
      break;
      }      
    case (CMD_DATABASES_NEWRECORD):
      {
      TUniqId recordid;
      int indexpos = getIndexPos (pd->envfile, pd->parm1);
      strcpy (recordid, "-1");
      pd->uo->InitStatusLine ();
      html->PrintDBEditRecordPage(pd->stlang, pd->username, pd->connid, pd->uo, indexpos, recordid);                  
      break;
      }    
    case (CMD_DATABASES_SYNC):
      {
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      CDB->Sync();
      pd->uo->InitStatusLine ();
      html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
      break;   
      }
    case (CMD_DATABASES_DUPLICATE):
      {
      bool b;
      TBuffer abuf;
      StringList *SLMulti;                        
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      SLMulti = new StringList();                           
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "recordid", SLMulti, false);
      pd->uo->InitStatusLine ();
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {        
        b = CDB->pasteItems (SLMulti, NULL);
        if (b == false) 
          {
          pd->html->ErrorPage(CDB->getErrorMsg());
          }
        else
          {
          if (SLMulti->Count() > 0)
            xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESCOPY), SLMulti->Count());
          pd->uo->setStatusLine (abuf, BLUE);
          html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
          }
        }
      delete SLMulti;     
      break;   
      }          
    case (CMD_DATABASES_COPY):
      {
      TBuffer abuf;
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      SLDatabasesPapeleraCopy.Clear();
      SLDatabasesPapeleraCut.Clear();                                    
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "recordid", &SLDatabasesPapeleraCopy, false);
      pd->uo->InitStatusLine ();
      if (SLDatabasesPapeleraCopy.Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {    
        xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESCOPY), SLDatabasesPapeleraCopy.Count()); 
        pd->uo->setStatusLine (abuf, BLUE);                    
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
        }
      break;   
      }    
    case (CMD_DATABASES_CUT):
      {
      TBuffer abuf;
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      SLDatabasesPapeleraCopy.Clear();
      SLDatabasesPapeleraCut.Clear();                                    
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "recordid", &SLDatabasesPapeleraCut, false);
      pd->uo->InitStatusLine ();
      if (SLDatabasesPapeleraCut.Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {        
        xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESCOPY), SLDatabasesPapeleraCut.Count()); 
        pd->uo->setStatusLine (abuf, BLUE);                    
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
        }
      break;   
      }
    case (CMD_DATABASES_PASTE):
      {
      bool b;
      TBuffer abuf;
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      b = CDB->pasteItems (&SLDatabasesPapeleraCopy, &SLDatabasesPapeleraCut);
      if (b == false) 
        {
        pd->html->ErrorPage(CDB->getErrorMsg());
        }
      else
        {
        if (SLDatabasesPapeleraCopy.Count() > 0)
          xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESPASTED), SLDatabasesPapeleraCopy.Count());
        else
          xsnprintf (abuf, CMAXBUFFER, "%s: %d", L->get(MSG_FILESPASTED), SLDatabasesPapeleraCut.Count());
        pd->uo->setStatusLine (abuf, BLUE);
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos);
        }
      break;         
      }
    case (CMD_DATABASES_DELETE):
      {
      TBuffer abuf;
      StringList *SLMulti;      
      SLMulti = new StringList();
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "recordid", SLMulti, false);
      pd->uo->InitStatusLine ();
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {
        int contdeleted = CDB->markRecordsByID (SLMulti, POS_FLAG_DELETED, true);
        if (contdeleted <= 1)
          xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSDELETED), contdeleted, L->get(L_DELETED));              
        else
          xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSDELETED_S),  contdeleted, L->get(L_DELETED));
        pd->uo->setStatusLine (abuf, BLUE);                    
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos); 
        }  
      delete SLMulti;     
      break;   
      }      
    case (CMD_DATABASES_UNDELETE):
      {
      TBuffer abuf;
      StringList *SLMulti;      
      SLMulti = new StringList();
      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      cgienv_GetSimpleMultipleEntriesSL (pd->envfile, "recordid", SLMulti, false);
      pd->uo->InitStatusLine ();
      if (SLMulti->Count () <= 0) 
        {
        pd->html->ErrorPage(L->get(MSG_NO_ENTRIES_MARKED));
        }
      else
        {
        int contundeleted = CDB->markRecordsByID (SLMulti, POS_FLAG_DELETED, false);
        if (contundeleted <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), contundeleted, L->get(L_UNDELETED));}
        else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), contundeleted, L->get(L_UNDELETED));}
        pd->uo->setStatusLine (abuf, BLUE);                    
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos); 
        }  
      delete SLMulti;     
      break;   
      }            
    case (CMD_DATABASES_DB_EXPUNGE):
      {
      TBuffer abuf;

      int indexpos = getIndexPos (pd->envfile, pd->parm1);        
      pd->uo->IncValidator();
      int contpurged = CDB->Expunge ();
      pd->uo->InitStatusLine ();
      if (contpurged == 0)      {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED_0));}
      else if (contpurged == 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED), contpurged);}
      else                      {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED_S), contpurged);}
      pd->uo->setStatusLine (abuf, BLUE);                                    
      html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos); 
      break;   
      }
    case (CMD_DATABASES_DB_OPEN):
      {
      TBuffer db_name;
      cgienv_GetSimpleVarDef (pd->envfile, "db_name", db_name, "");
      if (IsEmpty (db_name)) {xstrncpy (db_name, CMAXBUFFER, pd->parm1);}
      int indexpos = 1;
      pd->uo->IncValidator();    
      xstrncpy (dbfilename, CMAXBUFFER, db_name);    
      if (CDB != NULL)
        {
        CDB->DBclose();
        delete CDB; 
        CDB = NULL;         
        }
      CDB = new ClientDB (dbfilename, pd->uo->getDatabasesDir(), false, true);
      if (CDB->DBopen () == false) 
        {
        html->ErrorPage(CDB->getErrorMsg());
        }
      else
        {  
        pd->uo->InitStatusLine ();
        html->PrintDBIndexPage (pd->stlang, pd->username, pd->connid, pd->uo, indexpos); 
        }
      break;   
      }  
    case (CMD_DATABASES_DB_DEFINE):
      {
      TBuffer db_define_name;
      cgienv_GetSimpleVarDef (pd->envfile, "db_define_name", db_define_name, "Mi Nueva Database");                
      pd->uo->InitStatusLine ();
      html->PrintDBDefinePage (pd->stlang, pd->username, pd->connid, pd->uo, db_define_name);
      break;         
      }
    default: 
      {    
      LOG ("ERROR: Service_Databases: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  return false;  
  }  

void HTMLPages::BotoneraDBComun (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo, int indexpos)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

    //BUTTON BACK 
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_DATABASES_NEWRECORD:
        case CMD_DATABASES_EDITSAVE:
        case CMD_DATABASES_EDITSHOW: 
          WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%d\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, pageid, 
                 cmdactual, indexpos); 
          break;
        case CMD_DATABASES_MAINPAGE:        
          break;  
        default: 
          WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual); 
          break;
        }
      if (cmdactual != CMD_DATABASES_MAINPAGE) 
        {  
        Image (skin->getI(L_BACK), L->get(L_BACK), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
        WRITE ("</A>");
        }
      EndTD();  

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   
      
      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      /*
      switch (cmdactual)
        {
        case CMD_DATABASES_EDITSHOW:   WRITE ("<A HREF=\"%s/%s/help/editshow/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_DATABASES_DISPLAYPAGE:WRITE ("<A HREF=\"%s/%s/help/displaypage/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, pageid, cmdactual); break;
        }
      */  
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      //SPACE
      EmptyCellx2();      
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual); 
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP);
    EndTR();
  EndTable ();  
  PrintStatusLine (user, uo, true);
  }

void HTMLPages::BotoneraDBIndex (const char *lang, const char *user, const char *connid, UserOptions *uo, int abeginpage, int atotalrecords, int apagesize)
  {
  long newbegin, actualpos, totalrecords, aMAXMSGSFORPAGE;
  int validator, actualcmd;                           
  
  actualpos    = abeginpage;
  totalrecords = atotalrecords;
  validator    = uo->getValidator();
  actualcmd    = CMD_DATABASES_DISPLAYPAGE;
  aMAXMSGSFORPAGE = apagesize;
  if (aMAXMSGSFORPAGE <= 0) aMAXMSGSFORPAGE = totalrecords;
  
  //DEBUG ("actualpos=%d,totalrecords=%d,pagesize=%d", actualpos, totalrecords, aMAXMSGSFORPAGE);  
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));    
    
      //BUTTON BACK 
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/mainpage/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, uo->getValidator(), 
              uo->getPageId(), uo->getLastCmd()); 
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();  

      //BUTTON ROOT      
      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //BUTTON HELP   
      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      //WRITE ("<A HREF=\"%s/%s/help/displaypage/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, uo->getPageId(), actualcmd);
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());
      //if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      //WRITE ("</A>");
      EndTD();

      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON PREVIOUS PAGE
      if (actualpos > 1)  
        {
        newbegin = actualpos - aMAXMSGSFORPAGE; if (newbegin <= 0) newbegin = 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, 
               validator, uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_PREVPAGE_ACT), L->get(ALT_PREVPAGE_ACT), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }
      else 
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_PREVPAGE_INA), L->get(ALT_PREVPAGE_INA), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVPAGE_INA));}
        EndTD();
        }
      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON NEXT PAGE
      if (actualpos + aMAXMSGSFORPAGE <= totalrecords)
        {
        newbegin = actualpos + aMAXMSGSFORPAGE; 
        if (newbegin + aMAXMSGSFORPAGE > totalrecords)
          {
          ldiv_t ld;
          ld = ldiv (totalrecords, aMAXMSGSFORPAGE);
          newbegin = (ld.quot * aMAXMSGSFORPAGE) + 1;
          }
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_NEXTPAGE_ACT), L->get(ALT_NEXTPAGE_ACT), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTPAGE_ACT));}
        WRITE ("</A>");
        EndTD(); 
        }
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_NEXTPAGE_INA), L->get(ALT_NEXTPAGE_INA), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTPAGE_INA));}
        EndTD();
        }  

      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON FIRST PAGE
      if (actualpos > 1)
        {
        newbegin = 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_FIRSTPAGE_ACT), L->get(ALT_FIRSTPAGE_ACT), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_FIRSTPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }          
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_FIRSTPAGE_INA), L->get(ALT_FIRSTPAGE_INA), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_FIRSTPAGE_INA));}
        EndTD();
        }  

      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON LAST PAGE
      if (actualpos + aMAXMSGSFORPAGE <= totalrecords)
        {
        ldiv_t ld;
        ld = ldiv (totalrecords - 1, aMAXMSGSFORPAGE);
        newbegin = (ld.quot * aMAXMSGSFORPAGE) + 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/displaypage/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_LASTPAGE_ACT), L->get(ALT_LASTPAGE_ACT), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LASTPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }          
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_LASTPAGE_INA), L->get(ALT_LASTPAGE_INA), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LASTPAGE_INA));}
        EndTD();
        }

      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON DB_EXPUNGE   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmPurge() == true)       
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/db_expunge/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/db_expunge/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_DATABASES, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      Image (skin->getI(L_EXPUNGE), L->get(ALT_EXPUNGE), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_EXPUNGE));}
      WRITE ("</A>");
      EndTD();

      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
    EndTR();

  EndTable ();

  PrintStatusLine (user, uo, true);
  }   

void HTMLPages::PrintDBEditRecordPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, int indexpos, const char *recordid)
  {
  StringList *SLHTML;

  SLHTML = new StringList();
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_DATABASES_EDITRECORD), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  BotoneraDBComun (CMD_DATABASES_NEWRECORD, stlang, user, connid, uo, indexpos);

  BeginFormPost ("PrintDBEditRecordPage1", PATH_CGI);

  FormHidden ("service", SERVICE_DATABASES); 
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_DATABASES_DISPLAYPAGE);
  FormHidden ("cmd", "go");  
  FormHidden ("subcmd", "noop");

  if (strcmp (recordid, "-1") == 0) //New Blank Record
    {
    FormHidden ("recordid", "-1");
    CDB->generaHTMLFormEditNewRecord (SLHTML);
    }
  else
    {
    FormHidden ("recordid", recordid);                      
    CDB->generaHTMLFormEditRecordByID ((TUniqId)recordid, SLHTML);    
    }  
  for (int i = 0; i < SLHTML->Count(); ++i) {WRITE (SLHTML->getString(i).cstr());}
                
  BeginCenter();       
  FormButton ("editsave", L->get(L_SAVE));
  EndCenter();   
                
  EndForm ();
    
  BR();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));              
  
  delete SLHTML;
  }
  
void HTMLPages::PrintDBDisplayRecordPage (const char *stlang, const char *user, const char *connid, UserOptions *uo, int indexpos, const char *recordid)
  {
  TUniqId otheruniqid;
  StringList *SLHTML;
  int nextpos, NUMRECS;

  SLHTML = new StringList();
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_DATABASES_DISPLAYRECORD), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  BotoneraDBComun (CMD_DATABASES_NEWRECORD, stlang, user, connid, uo, indexpos);

  NUMRECS = CDB->getNumRecords();      
  
  Linea();
  BeginCenter();
  CDB->generaHTMLFormDisplayRecordByID ((TUniqId)recordid, SLHTML);    
  for (int i = 0; i < SLHTML->Count(); ++i) {WRITE (SLHTML->getString(i).cstr());}                
  BR();
  EndCenter();

  BeginCenter();
  //BUTTON PREV RECORD
  if (indexpos > 1)
    {
    nextpos = indexpos - 1;
    if (CDB->getUniqIDFromIndexPos (nextpos, otheruniqid) == NULL) {ErrorPage(CDB->getErrorMsg()); return;}
    WRITE ("<A HREF=\"%s/%s/displayrecord/noop/%s/%s/%s/%d/%d/%d/%d/%s/\">", PATH_CGI, SERVICE_DATABASES, stlang, user, connid, uo->getValidator(), 
           uo->getPageId(), CMD_DATABASES_DISPLAYRECORD, nextpos, otheruniqid);
    WRITE ("[%s]\n", L->get(ALT_PREVRECORD));
    WRITE ("</A>&nbsp;&nbsp;");
    }
  //BUTTON NEXT RECORD
  if (indexpos <= NUMRECS - 1)
    {
    nextpos = indexpos + 1;
    if (CDB->getUniqIDFromIndexPos (nextpos, otheruniqid) == NULL) {ErrorPage(CDB->getErrorMsg()); return;}
    WRITE ("<A HREF=\"%s/%s/displayrecord/noop/%s/%s/%s/%d/%d/%d/%d/%s/\">", PATH_CGI, SERVICE_DATABASES, stlang, user, connid, uo->getValidator(), 
            uo->getPageId(), CMD_DATABASES_DISPLAYRECORD, nextpos, otheruniqid);
    WRITE ("[%s]\n", L->get(ALT_NEXTRECORD));
    WRITE ("</A>&nbsp;&nbsp;");
    }
  EndCenter();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));                
  delete SLHTML;
  }  
  
void HTMLPages::PrintDBIndexPage (const char *lang, const char *user, const char *connid, UserOptions *uo, int indexpos)
  {
  TBuffer sorturl, abuf;
  TUniqId uniqid;
  TNumber anum; 
  int lendata = 0, NUMRECS, beginpos, lastpos, pagesize;
  char *fielddata = NULL;
  StringList *SLHTML, SLFieldNames, SLFieldLabels, SLDatabasesFileNames, SLDatabasesNames;
  TMatField *amf = NULL;
  TDBField DBField;  
  TFlags flags;

  SLHTML = new StringList ();
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_DATABASES_INDEXPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
         
  NUMRECS = CDB->getNumRecords();      
  beginpos = indexpos;
  pagesize = uo->getMsgsPerIndexPage();      
  if (pagesize <= 0) pagesize = NUMRECS;
  lastpos  = beginpos + pagesize - 1;  if (lastpos > NUMRECS) lastpos = NUMRECS;;
  
  if (uo->get_use_javascript() == true)
    {
    JavaScript(DEF_JavaIndexCheck);
    }
  BotoneraDBIndex (lang, user, connid, uo, beginpos, NUMRECS, pagesize);    
    
  BeginTable (0, 2, 1, 100);
  BeginFormPost ("PrintDBIndexPage1", PATH_CGI);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));  
  BeginTDColSpanCenter (20);
  xsnprintf (abuf, CMAXBUFFER, L->get(L_DB_INDEXHEADER), CDB->getDBName (),  NUMRECS, CDB->getDBSize());
  WRITE ("<B>%s</B>", abuf);
  EndTD();
  EndTR(); 
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  if (uo->get_use_javascript() == true)
    {
    BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"), 1); JSFormCheckbox ("jscheckall", "", "if (this.checked) {putOn()} else {putOff()}", false); EndTD();     
    }
  else
    {
    BeginTD(true,  1, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); WRITE (HTML_HSP); EndTD(); 
    }  
  BeginTD(); WRITE ("&nbsp;"); EndTD();   
  WRITE ("<TD width=\"5%%\" align=\"left\"><B>%s</B></TD>\n", L->get(L_FLAGS));
  BeginTD(); WRITE ("&nbsp;"); EndTD();     
  BeginTD(); WRITE ("&nbsp;"); EndTD();         
  
  (const TMatField *)amf = CDB->getMatField ();    

  xsnprintf (sorturl, CMAXBUFFER, "<A HREF=\"%s/%s/sort/noop/%s/%s/%s/%d/%d/%d/%%s\">%%s</A>", 
             PATH_CGI, SERVICE_DATABASES, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_DATABASES_DISPLAYPAGE);      
  CDB->generaHTMLIndexPage (sorturl, SLHTML);
  for (int i = 0; i < SLHTML->Count(); ++i) {WRITE (SLHTML->getString(i).cstr());}
  EndTR();
      
  for (int recordpos = beginpos; recordpos <= lastpos; ++recordpos)
    {    
    if (CDB->getUniqIDFromIndexPos (recordpos, uniqid) == NULL) {ErrorPage(CDB->getErrorMsg()); return;}
     
    //DEBUG ("recordpos=%d,lastpos=%d,pagesize=%d,uniqid='%s'", recordpos, lastpos, pagesize, uniqid);
    
    WRITE ("<TR valign=baseline bgcolor=\"%s\">", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
    
    //1. CHECKBOX
    BeginTD(); FormCheckbox ("recordid", uniqid, false); EndTD();
    
    //2. POSITION
    WRITE ("<TD align=\"right\" width=\"1%%\"><FONT size=2 face=\"%s\"><B>%s.</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), xltoa (recordpos, anum));

    //3. FLAGS    
    TBuffer tmpbuf;
    CDB->getFlagsById (uniqid, flags);
    WRITE ("<TD align=\"left\"><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), 
           Database_DisplayFlags(flags, false, "", 0, SERVICE_DATABASES, tmpbuf));

    //4. DISPLAY RECORD
    WRITE ("<TD align=\"right\" width=\"1%%\"><FONT size=2 face=\"%s\">\n", skin->getSkinAtribProp("FONT_TABLE"));
    WRITE ("<A HREF=\"%s/%s/displayrecord/noop/%s/%s/%s/%d/%d/%d/%d/%s/\">\n", 
           PATH_CGI, SERVICE_DATABASES, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_DATABASES_DISPLAYPAGE, 
           recordpos, uniqid);
    Image (skin->getI(L_DISPLAY), L->get(L_DISPLAY), "");
    WRITE ("</A>\n");  
    WRITE ("</TD>");

    //5. EDIT RECORD
    WRITE ("<TD align=\"right\" width=\"1%%\"><FONT size=2 face=\"%s\">\n", skin->getSkinAtribProp("FONT_TABLE"));
    WRITE ("<A HREF=\"%s/%s/editshow/noop/%s/%s/%s/%d/%d/%d/%d/%s/\">\n", 
           PATH_CGI, SERVICE_DATABASES, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_DATABASES_DISPLAYPAGE, 
           recordpos, uniqid);
    Image (skin->getI(L_EDIT), L->get(L_EDIT), "");
    WRITE ("</A>\n");  
    WRITE ("</TD>");
    
    //6 and NEXT. DATABASE FIELDS TO DISPLAY
    for (int i = 0; i < amf->Count(); ++i)
      {
      DBField = amf->elementAt(i);
      if (DBField.findexlength > 0)
        {
        fielddata  = CDB->displayField_Text_ByID (uniqid, DBField.fname, DBField.ftype, fielddata, &lendata);
        BeginTD (DBField.findexlength, skin->getSkinAtribProp("FONT_TABLE"), 2, "left"); WRITE ("%s", fielddata); EndTD();        
        free (fielddata);              
        }    
      }        
    EndTR();            
    }

  EndTable();   
  
  FormHidden ("service", SERVICE_DATABASES); 
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_DATABASES_DISPLAYPAGE);
  FormHidden ("cmd", "go");  
  FormHidden ("subcmd", "noop");                  
  FormHidden ("indexpos", indexpos);
  BR();            
  BeginTable (0, 0, 0, 100);              
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));    
  if (NUMRECS > 0) 
    {
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"), "left"); 
      FormButton ("delete", L->get(L_DELETE));
      FormButton ("undelete", L->get(L_UNDELETE)); 
    EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"), "right");
      FormButton ("duplicate", L->get(L_COPY));
      // FormButton ("copy", L->get(L_COPY));
      // FormButton ("cut", L->get(L_CUT)); 
    }
  else
    {
    BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
    }  
  if ((SLDatabasesPapeleraCopy.Count() > 0) || (SLDatabasesPapeleraCut.Count() > 0)) 
    {
      // FormButton ("paste", L->get(L_PASTE)); 
    }
  FormButton ("newrecord", L->get(L_CREATE)); 
  //FormButton ("sync", L->get(L_SYNC));
  EndTD();   

  if (NUMRECS > 0) 
    {
    EndTR();
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));    
    BeginTDColSpanCenter (15);
      FormButton ("search", L->get(L_SEARCH));
      FormBeginSelect ("PrintDBIndexPage1", "fieldtosearch", NULL, uo->get_use_javascript()); 
      CDB->getAllFieldNames (&SLFieldNames);
      CDB->getAllFieldLabels (&SLFieldLabels);    
      for (int i = 0; i < SLFieldNames.Count(); ++i)
        {
        if (i == 0) FormAddOptionSelect (true,  SLFieldNames.getString(i).cstr(), SLFieldLabels.getString(i).cstr());
        else FormAddOptionSelect (false, SLFieldNames.getString(i).cstr(), SLFieldLabels.getString(i).cstr());
        }
        FormAddOptionSelect (false, "fd_all", L->get(L_SEARCH_ALL));
        FormEndSelect();
      FormEdit (100, 20, "whatsearch", whatsearch);  
      if (CDB->isDBSearched() == true) {FormButton ("deletesearch", L->get(L_DELETESEARCH));}    
    EndTD();    
    }

  if (getTotalDatabases (uo->getDatabasesDir(), &SLDatabasesFileNames, &SLDatabasesNames) > 0)
    {
    EndTR();
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));    
    BeginTDColSpanCenter (15);
      FormButton ("db_open", L->get(L_DB_CHANGE));
      FormBeginSelect ("PrintDBIndexPage1", "db_name", "db_open", uo->get_use_javascript()); 
      for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
        {
        if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
        else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
        }
      FormEndSelect();
    EndTD();        
    }      

  EndTR();  
  EndTable();   

  EndForm ();
    
  BR();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  delete SLHTML;
  }

void HTMLPages::PrintDBMainPage (const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  TBuffer abuf;
  StringList SLDatabasesFileNames, SLDatabasesNames, SLDBTemplatesFileNames, SLDBTemplatesNames;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_DATABASES_MAINPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
            
  BotoneraDBComun (CMD_DATABASES_MAINPAGE, lang, user, connid, uo, 1);

  BeginFormPost ("PrintDBMainPage1", PATH_CGI);

  FormHidden ("service", SERVICE_DATABASES); 
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_DATABASES_MAINPAGE);
  FormHidden ("cmd", "go");  
  FormHidden ("subcmd", "noop");                  
  FormHidden ("indexpos", 1);

  xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_DATABASES)); 
  Label (abuf);
  Linea();             
  if (getTotalDatabases (uo->getDatabasesDir(), &SLDatabasesFileNames, &SLDatabasesNames) > 0)
    {
    WRITE ("<UL>");
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      xsnprintf (abuf, CMAXBUFFER, "%s/%s/db_open/noop/%s/%s/%s/%d/%d/%d/%s", PATH_CGI, SERVICE_DATABASES, lang, user, connid,
                 uo->getValidator(), uo->getPageId(), uo->getLastCmd(),
                 SLDatabasesFileNames.getString(i).cstr());        
      WRITE ("<LI>\n");
      URL (SLDatabasesNames.getString(i).cstr(), abuf);
      }
    WRITE ("</UL>");
    }        
  else
    {
    WRITE ("<UL>\n<LI>\n(%s)\n</UL>\n", L->get(L_NONE_A));
    }  
  Linea();             
    
  BeginTable (0, 2, 1, 100);      
  if (getTotalDatabases (DATABASES_PATH, &SLDBTemplatesFileNames, &SLDBTemplatesNames) > 0)
    {
    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_create", L->get(L_CREATE)); 
    EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
      FormEdit (100, 25, "db_create_newname", L->get(L_DB_MYNEWDB)); 
      Label (L->get(L_LEX_OF));
      FormBeginSelect ("PrintDBMainPage1", "db_template", NULL, uo->get_use_javascript()); 
      for (int i = 0; i < SLDBTemplatesFileNames.Count(); ++i)
        {
        if (i == 0) FormAddOptionSelect (true,  SLDBTemplatesFileNames.getString(i).cstr(), SLDBTemplatesNames.getString(i).cstr());
        else FormAddOptionSelect (false, SLDBTemplatesFileNames.getString(i).cstr(), SLDBTemplatesNames.getString(i).cstr());
        }
      FormEndSelect();    
    EndTD();
    EndTR();             
    }

  if (SLDatabasesFileNames.Count() > 0)
    {
    
    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_rename", L->get(L_RENAME)); 
    EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormBeginSelect ("PrintDBMainPage1", "db_rename_oldname", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      }
    FormEndSelect();
    WRITE ("%s<B>%s</B>%s\n", HTML_HSP, L->get(L_LEX_AS), HTML_HSP);
    FormEdit (100, 25, "db_rename_newname", "");
    EndTD();
    EndTR();             

    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_confdelete", L->get(L_DELETE)); 
    EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormBeginSelect ("PrintDBMainPage1", "db_delete_name", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      }
    FormEndSelect();
    EndTD();
    EndTR();             
                 
    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_dump", L->get(L_DUMP)); 
    EndTD(); 
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormBeginSelect ("PrintDBMainPage1", "db_dump_name", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      }
    FormEndSelect();
    EndTD();
    EndTR();             

    /*
    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_import", L->get(L_IMPORT)); 
    EndTD(); 
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormFile (255, 20, "filetoimport", "", "*"); 
    WRITE ("%s<B>%s</B>%s\n", HTML_HSP, L->get(L_LEX_AS), HTML_HSP);
    FormBeginSelect ("PrintDBMainPage1", "db_import_name", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      }
    FormEndSelect();
    EndTD();
    EndTR();             

    BeginTR();  
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
      FormButton ("db_export", L->get(L_EXPORT)); 
    EndTD(); 
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormBeginSelect ("PrintDBMainPage1", "db_export_name", NULL, uo->get_use_javascript()); 
    for (int i = 0; i < SLDatabasesFileNames.Count(); ++i)
      {
      if (i == 0) FormAddOptionSelect (true,  SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      else FormAddOptionSelect (false, SLDatabasesFileNames.getString(i).cstr(), SLDatabasesNames.getString(i).cstr());
      }
    FormEndSelect();
    EndTD();
    EndTR();             
    */
    }
    
  /*  
  BeginTR();  
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
    FormButton ("db_define", L->get(L_DEFINE)); 
  EndTD();   
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left"); 
    FormEdit (100, 25, "db_define_name", "");
  EndTD();
  EndTR();             
  */
    
  EndTable();

  EndForm ();
         
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));                                      
  }
                          
void HTMLPages::PrintDBDefinePage (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *db_define_name)
  {
  TBuffer abuf;
  StringList SLDBFields;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_DATABASES_DB_DEFINE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
            
  BotoneraDBComun (CMD_DATABASES_DB_DEFINE, stlang, user, connid, uo, 1);

  BeginFormPost ("PrintDBDefinePage1", PATH_CGI);

  FormHidden ("service", SERVICE_DATABASES); 
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_DATABASES_DB_DEFINE);
  FormHidden ("cmd", "go");  
  FormHidden ("subcmd", "noop");                  
  FormHidden ("indexpos", 1);

  xsnprintf (abuf, CMAXBUFFER, "%s: '%s'", L->get(L_DATABASE), db_define_name);
  Label (abuf);
  Linea ();

  Linea ();
  getTotalFields (&SLDBFields);
                                             
  BeginTable (0, 0, 0, 100);
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        //
      EndTD();     
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormButton ("db_addfield", L->get(L_FIELD_ADD));        
      EndTD(); 
    EndTR();                              
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_NAME));
        Label (abuf);        
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "name", ""); 
      EndTD(); 
    EndTR();                            
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_ORDER));
        Label (abuf);         
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "orden", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_TYPE));
        Label (abuf);          
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormBeginSelect ("PrintDBDefinePage11", "db_field_type", NULL, uo->get_use_javascript()); 
        for (int i = 0; i < SLDBFields.Count(); ++i)
          {
          if (i == 0) FormAddOptionSelect (true,  SLDBFields.getString(i).cstr(), SLDBFields.getString(i).cstr());
          else FormAddOptionSelect (false, SLDBFields.getString(i).cstr(), SLDBFields.getString(i).cstr());
          }                                                      
        FormEndSelect();
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_MAXLENGTH));
        Label (abuf);     
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "maxlength", ""); 
      EndTD(); 
    EndTR();    
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_DISPLAYLENGTH));
        Label (abuf); 
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "displaylength", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_INDEXLENGTH));
        Label (abuf);   
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "indexlength", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_LABEL));
        Label (abuf);         
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "label", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_DEFAULT));
        Label (abuf);       
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "default", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_COULDBENULL));
        Label (abuf); 
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "couldbenull", ""); 
      EndTD(); 
      EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_OPTIONAL1));
        Label (abuf);    
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "optional1", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_OPTIONAL2));
        Label (abuf);    
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "optional2", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); 
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_OPTIONAL3));
        Label (abuf);    
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "optional3", ""); 
      EndTD(); 
    EndTR();
    BeginTR(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
        xsnprintf (abuf, CMAXBUFFER, "%s:", L->get(L_FIELD_OPTIONAL4));
        Label (abuf);    
      EndTD(); 
      BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "left"); 
        FormEdit (100, 20, "optional4", ""); 
      EndTD(); 
    EndTR();
  EndTable ();

  EndForm ();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));                                          
  }    
        
const char *Database_DisplayFlags (const char *flags, bool clickable, const char *molde, 
                                   int show_way, const char *aservice, TBuffer abuf)
  {
  XString XS;                                                    
  char c;
  TBuffer tmpbuf;
  
  //show_way = 0: All flags
  //show_way = 1: Active flags
  //show_way = 2: Inactive flags
  
  XS = HTML_HSP; XS += "\n";
  for (xuint i=0; i < strlen (flags); ++i)
    {
    c = flags[i];
    if (i == POS_FLAG_DELETED)
      {
      if ((c == FDELETED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_undelete/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_DELETED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_DELETED); XS += ")\">";
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_delete/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNDELETED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNDELETED); XS += ")\">";
          XS += "</A>\n";
          }
        }
      }
    else if (i == POS_FLAG_SEARCHED)
      {
      if ((c == FSEARCHED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_unsearched/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;                                           
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_SEARCHED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_SEARCHED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_searched/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNSEARCHED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNSEARCHED); XS += ")\">";    
          XS += "</A>\n";
          }
        }
      }                                                                 
    else if (i == POS_FLAG_IMPORTANT)
      {
      if ((c == FFLAGGED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_unflagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_FLAGGED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_FLAGGED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_flagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNFLAGGED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNFLAGGED); XS += ")\">";      
          XS += "</A>\n";
          }
        }
      }
    else if ((i == POS_FLAG_NEW) && (clickable == false))
      {
      if (((c == FNEW) || (c == FUNSEEN)) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_seen/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNSEEN); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNSEEN); XS += ")\">";
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_unseen/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_SEEN); XS += "\" ALT=\"("; XS += L->get(L_FLAG_SEEN); XS += ")\">";
          XS += "</A>\n";
          }
        }
      }
    else if (i == POS_FLAG_COPIED)
      {
      if ((c == FCOPIED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_unflagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_COPIED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_COPIED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/rec_fg_flagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNCOPIED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNCOPIED); XS += ")\">";      
          XS += "</A>\n";
          }
        }
      }
    }   
  xstrncpy (abuf, CMAXBUFFER, XS.cstr());
  return abuf;
  }  

  
