/*
 * $Id: tooltips.c,v 1.11 2000/11/22 19:47:31 davej Exp $
 *
 * GTK Tooltips. Suck. And blow. Lots. Hard.
 * So much so, that someone wrote this wonderful piece of code
 * and implemented it into gnumeric.
 * Maybe one day, someone will be kind enough to merge it into GTK also.
 * 
 * Author:
 *  Unknown contributor to Gnumeric. (Miguel is credited, but denies all knowledge)
 *  -- Thank you mystery person.
 *
 * FIXME:
 * We need to steal^Wcopy the gnumeric `wait a second or 2 before showing the tooltip'
 * code too, as it looks kinda sucky as is.
 *
 */

#include <gtk/gtk.h>
#include <powertweak.h>

static int color_inited;
static GdkColorContext *pt_color_context;

/* Public colors: shared by all of our items in Powertweak */
static GdkColor gs_white, gs_black, gs_light_gray, gs_dark_gray, gs_red, gs_lavender;

static void color_alloc_name (const char *name, GdkColor *c)
{
	int failed;

	g_return_if_fail (name != NULL);
	g_return_if_fail (c != NULL);

	gdk_color_parse (name, c);
	c->pixel = 0;
	c->pixel = gdk_color_context_get_pixel (pt_color_context, c->red, c->green, c->blue, &failed);
}


void color_init(void)
{
	GdkColormap *colormap = gtk_widget_get_default_colormap ();
	/* Initialize the color context */
	pt_color_context = gdk_color_context_new (
		gtk_widget_get_default_visual(), colormap);

	/* Allocate the default colors */
	gdk_color_white (colormap, &gs_white);
	gdk_color_black (colormap, &gs_black);

	color_alloc_name ("gray78",  &gs_light_gray);
	color_alloc_name ("gray20",  &gs_dark_gray);
	color_alloc_name ("red",     &gs_red);
	color_alloc_name ("lavender",&gs_lavender);

	color_inited = 1;
}


GtkWidget *pt_create_tooltip (char *tiplabel)
{
	GtkWidget *tip, *label, *frame;
	static GtkRcStyle*rc_style = NULL;
	
	if (rc_style == NULL) {
		int i;
		rc_style = gtk_rc_style_new ();

		for (i = 5; --i >= 0 ; ) {
			rc_style->color_flags[i] = GTK_RC_BG;
			color_alloc_name ("LightYellow",  &rc_style->bg[i]);
		}
	}

	tip = gtk_window_new (GTK_WINDOW_POPUP);
	if (rc_style != NULL)
		gtk_widget_modify_style (tip, rc_style);

	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
	label = gtk_label_new ("");

	gtk_container_add (GTK_CONTAINER (tip), frame);
	gtk_container_add (GTK_CONTAINER (frame), label);

	gtk_label_set_text (GTK_LABEL (label), tiplabel);
	
	return label;
}

void pt_position_tooltip (GtkWidget *tip, int horizontal)
{
	GtkRequisition req;
	int  x, y;

	gtk_widget_size_request (tip, &req);
	gdk_window_get_pointer (NULL, &x, &y, NULL);

	if (horizontal){
		x = x - req.width/2;
		y = y - req.height - 20;
	} else {
		x = x - req.width - 20;
		y = y - req.height/2;
	}

	if (x < 20)
		x = 20;
	if (y < 20)
		y = 20;

	gtk_widget_set_uposition (gtk_widget_get_toplevel (tip), x, y);
}
