/* ppxp-applet.c
 *
 * Copyright (C) 1999-2000 Yurika.
 *
 * Copyright (C) 2000 Takuo Kitame <kitame@northeye.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "all.h"

static gchar *select_a_file (void);
static void about_dialog(AppletWidget *applet, gpointer data);
static void quit_applet(AppletWidget *applet,gpointer data);
static void change_pixel_size_event (AppletWidget *applet, int size);
static void ppxp_disconnect_cb(Ppxp *ppxp, gpointer data);
static void ppxp_changed_cb(Ppxp *ppxp, gpointer data);

/* */
static void
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {
    applet_widget_gtk_main_quit();
}

static int
save_session_event(GtkWidget *widget, gchar *privcfgpath, gchar *globcfgpath,
                   gpointer data)
{
    save_property (widget, privcfgpath, globcfgpath);
    
    return FALSE;
}

gint
main(gint argc, gchar *argv[]){
    GtkWidget *applet;
    Ppxp *ppxp;

#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE,LOCALEDIR);
    textdomain(PACKAGE);
#endif

    applet_widget_init(PACKAGE, VERSION, argc, argv, NULL, 0, NULL);

#ifdef DISABLE_GDK_PIXBUF
    gdk_imlib_init();
#endif /* DISABLE_GDK_PIXBUF */

  /* MAKE_APPLET_WIDGET_AND_CONNECT_SIGNAL */
  {
      gint size;
    
      applet = applet_widget_new(PACKAGE);
      if(!applet) g_error("Can't create applet widget!");

      gtk_signal_connect(GTK_OBJECT(applet), "delete_event",
                         GTK_SIGNAL_FUNC(delete_event), NULL);  
      gtk_signal_connect(GTK_OBJECT(applet), "save_session",
                         GTK_SIGNAL_FUNC(save_session_event),NULL);
      gtk_signal_connect(GTK_OBJECT(applet), "change_pixel_size",
                         GTK_SIGNAL_FUNC(change_pixel_size_event),NULL);
      

      size = applet_widget_get_panel_pixel_size (APPLET_WIDGET(applet));
      gtk_widget_set_usize(applet, size, size);
      gtk_widget_show(applet);
  }

  /* MAKE_PPXP_OBJECT_AND_CONNECT_SIGNAL */
  {
    gint retry_count = 0, reply;
    GtkWidget *message_box_ask_retry;
    
    while (!(ppxp = ppxp_new())) {    
        if (retry_count < 5)
            sleep (1);
        else {
            message_box_ask_retry =
                gnome_message_box_new (_("Couldn't make connection with "
                                         "PPxP daemon %s times.\n"
                                         "Would you like to retry?"),
                                       GNOME_MESSAGE_BOX_QUESTION,
                                       _("retry"),
                                       _("abort"),
                                       NULL);
            
            //  gtk_widget_show ( message_box_ask_retry );
            
            reply = gnome_dialog_run ( GNOME_DIALOG( message_box_ask_retry ) );
        
            if (reply != 0)
                exit (1);
        }
        retry_count++;
    }
  
    gtk_signal_connect(GTK_OBJECT(ppxp),"changed",
                       GTK_SIGNAL_FUNC(ppxp_changed_cb), applet);
    gtk_signal_connect(GTK_OBJECT(ppxp),"disconnect",
                       GTK_SIGNAL_FUNC(ppxp_disconnect_cb),NULL);
  }
  
  /* LOAD_PROPERTY_AND_LOAD_CONFIGFILE */
  {
    gchar *str, *loaded_configname;
    
    load_property (applet,
                   APPLET_WIDGET(applet)->privcfgpath,
                   APPLET_WIDGET(applet)->globcfgpath);
    str = gtk_object_get_data (GTK_OBJECT(applet), "configname");
    loaded_configname = ppxp_getenv(ppxp, "NAME");
    if( str[0] != '\0' ) {
        if (gtk_object_get_data (GTK_OBJECT(applet), "always_load_config_on_startup")
            || !( loaded_configname && loaded_configname[0] != '\0' )
            )
            ppxp_source(ppxp, str);
    } else {
        if ( loaded_configname && loaded_configname[0] != '\0' ) {
          g_return_val_if_fail( str = g_strdup(loaded_configname), 1 );
          gtk_object_set_data_full(GTK_OBJECT(applet),"configname",str,
                                   (GtkDestroyNotify)g_free);
        } else {        
          str = select_a_file ();
          
          if (str) {
              ppxp_source (ppxp, str);
              gtk_object_set_data_full(GTK_OBJECT(applet),"configname",str,
                                       (GtkDestroyNotify)g_free);
          }
        }
    }
  }
  
  /* MAKE_UI_WIDGET */
  {
      GtkWidget *widget;
      PanelOrientType orient;
      gint size;
      
      orient = applet_widget_get_panel_orient (APPLET_WIDGET(applet));
      size   = applet_widget_get_panel_pixel_size   (APPLET_WIDGET(applet));
      
      widget = ui_make_widget (ppxp);
      ui_set_size (size);
      ui_set_orient (orient);
      
      applet_widget_add(APPLET_WIDGET(applet), widget);
  }
  
  /* ADD_CALLBACKS_TO_MENU */
  {
      applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                            "properties",
                                            GNOME_STOCK_MENU_PROP,
                                            _("Properties..."),
                                            property_dialog,
                                            ppxp);
      
      applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                            "quit",
                                            GNOME_STOCK_MENU_EXIT,
                                            _("Quit"),
                                            quit_applet,
                                            ppxp);
      
      applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                            "about",
                                            GNOME_STOCK_MENU_ABOUT,
                                            _("About..."),
                                            about_dialog,
                                            NULL);
  }

  applet_widget_gtk_main();
  
  return 0;
}

static gchar *
select_a_file (void){
    DIR *dp;
    struct direct *dir;
    struct stat status;
    gchar *str;
    gchar dirname[MAX_FILENAME_LEN];
    gchar filename[MAX_FILENAME_LEN];
    gchar selected_filename[MAX_FILENAME_LEN];
    time_t latest_time = 0;
  
    dirname[0] = '\0';
    selected_filename[0] = '\0';
    g_return_val_if_fail( str = getenv ("HOME"), NULL );
    strncpy (dirname, str, MAX_FILENAME_LEN);
    dirname[MAX_FILENAME_LEN-1] = '\0';
    strncat (dirname, "/.ppxp/conf", MAX_FILENAME_LEN);
    dirname[MAX_FILENAME_LEN-1] = '\0';
    g_return_val_if_fail ((dp = opendir (dirname)) != NULL, NULL);
  
    while ((dir = readdir (dp)) != NULL) {
      if (dir->d_ino == 0)
          continue;
      
      if (strncmp (".", dir->d_name, 1) == 0)
          continue;
      
      
      strncpy (filename, dirname, MAX_FILENAME_LEN);
      filename[MAX_FILENAME_LEN-1] = '\0';
      strncat (filename, "/", MAX_FILENAME_LEN);
      filename[MAX_FILENAME_LEN-1] = '\0';
      strncat (filename, dir->d_name, MAX_FILENAME_LEN);
      filename[MAX_FILENAME_LEN-1] = '\0';
      stat (filename, &status);
      
      if (latest_time < status.st_atime) {
        latest_time = status.st_atime;
        strcpy (selected_filename, dir->d_name);
      }
    }
    closedir (dp);
  
    if ( selected_filename[0] == '\0' )
        return NULL;
    return g_strdup(selected_filename);
}

static void
change_pixel_size_event (AppletWidget *applet, gint size)
{
    gtk_widget_set_usize (GTK_WIDGET(applet), size, size);
    ui_set_size (size);
}

static void
about_dialog(AppletWidget *applet, gpointer data)
{
    GtkWidget *about;
    const gchar *authors[] = {
        "Takuo Kitame <kitame@northeye.org> (forked version)",
        "Yurika <yurika@po.gws.ne.jp> (Original)",
        NULL
    };
    
    about = gnome_about_new (_("The PPxP Applet"), VERSION,
                             "Copyright (C) 1999-2000 ",
                             authors,
                             _("A frontend for PPxP."),
                             NULL);
    gtk_widget_show(about);
}

static void
quit_applet(AppletWidget *applet, gpointer data) {
    Ppxp *ppxp = (Ppxp *)data;
    ppxp_quit( ppxp );
    applet_widget_gtk_main_quit();
}

static void
ppxp_disconnect_cb(Ppxp *ppxp, gpointer data) {
    applet_widget_gtk_main_quit();
}

static void
ppxp_changed_cb(Ppxp *ppxp, gpointer data) {
    GtkWidget *applet = GTK_WIDGET(data);
    static gint bstat = 0;
    
    ui_update (ppxp);

    if((gint)gtk_object_get_data(GTK_OBJECT(applet), "quickendisconnect") == TRUE
       && bstat == 4 && ppxp->stat != 4){
        ppxp_disconnect(ppxp);
    }
    bstat = ppxp->stat;
}
