/*****
*
* Copyright (C) 1998 - 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef PLUGIN_PROTOCOL_H

#define PLUGIN_PROTOCOL_H

#include <libprelude/list.h>



typedef struct {
        PLUGIN_GENERIC;
        int (*opt)(int argc, char **argv);
        int (*run)(packet_container_t *packet, unsigned char *data, int len);
        const char *proto;
        struct list_head detect_plugin_list;
} plugin_protocol_t;


#define plugin_protocol(p) (p)->proto
#define plugin_run_func(p) (p)->run

#define plugin_set_protocol(p, proto) plugin_protocol(p) = proto
#define plugin_set_running_func(p, func) plugin_run_func(p) = (func)


plugin_protocol_t *protocol_plugins_search(const char *proto);

int protocol_plugins_run(packet_container_t *packet, unsigned char *data, int len);


int protocol_plugin_register(plugin_protocol_t *plugin);


/*
 * Open the plugin directory (dirname),
 * and try to load all plugins located int it.
 */
int protocol_plugins_init(const char *dirname, int argc, char **argv);


/*
 * port_list
 */
typedef struct port_list port_list_t;

int protocol_plugin_is_port_ok(port_list_t *plist, uint16_t port);

int protocol_plugin_add_port_to_list(port_list_t *plist, uint16_t port);

int protocol_plugin_add_string_port_to_list(port_list_t *plist, const char *string);

port_list_t *protocol_plugin_port_list_new(void);

void protocol_plugin_port_list_free(port_list_t *plist);

/*
 * Plugin initialisation function
 */
plugin_generic_t *plugin_init(int argc, char **argv);


#endif
    
