/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: imgnode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:44  slash
 * Initial release.
 *
 */

#ifndef IMGNODE_H
#define IMGNODE_H

#include "imagesize.h"
#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class represents an img-node.
 */
class ImgNode : public Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the img-node.
     *
     * @param node The XML-node, which represents the img-node.
     * @param latex_scale 1, if the image in the LaTeX-output should be
     *                    automatically scaled to the proper size, else 0.
     */
    ImgNode(xmlNodePtr node,
            int latex_scale = 1);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~ImgNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the HTML-environment for the node to the global
     * output filestream Output_.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * The size of the image.
     */
    ImageSize size_;

    //-----------------------------------------------------------------------
    /**
     * The filename of the image for the HTML-output.
     */
    char *filename_html_;

    /**
     * The filename of the image for the LaTeX-output.
     */
    char *filename_latex_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the image in the LaTeX-output should be automatically scaled
     * to the proper size, else 0.
     */
    int latex_scale_;
};

#endif //IMGNODE_H
