/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: node.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:40  slash
 * Initial release.
 *
 */

#ifndef NODE_H
#define NODE_H

#include <vector.h>

#include <tree.h>

//---------------------------------------------------------------------------
/**
 * This base-class provides a common interface for all nodes.
 * This interface contains methods to write the node to a HTML-,
 * a LaTeX- or a XML-file.
 */
class Node { 
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the node.
     */
    Node();

    //-----------------------------------------------------------------------
    /**
     * Destructor
     */
    virtual ~Node();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * This method must be overloaded by all derivated classes.
     *
     * @param parameter An integer-parameter which may have a special meaning
     *                  for each derivated class.
     */
    virtual void writeHTML(int parameter = 0) const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     * This method must be overloaded by all derivated classes.
     */
    virtual void writeLaTeX() const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     * This method must be overloaded by all derivated classes.
     */       
    virtual void writeXML() const = 0;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of characters of the stored text.
     * Note, that some derivated Nodes don't store any text.
     * In this case, this method is called recursively on the child-nodes.
     *
     * @return The length of the stored text.
     */
    virtual unsigned int getLength() const;


  protected:

    //-----------------------------------------------------------------------
    /**
     * An array of pointers to all child-nodes.
     */
    vector<Node*> child_nodes_;
};

#endif //NODE_H
