/***************************************************************************
                          job_appendsmbtodatabase.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_appendsmbtodatabase.h"

#include "job_disconnectfromdatabase.h"
#include "database.h"
#include "datadispatcher.h"
#include "jobmanager.h"

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_AppendSMBToDatabase::Job_AppendSMBToDatabase(LVI_SMBShare *_share)
: share(_share) {}

void Job_AppendSMBToDatabase::run() {
    int error = 0;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    app->lock()
    ;
    datadispatcher->eventAddEditLock();
    datadispatcher->eventStartedAppendingSMB(share);
    app->unlock();

    QList<TRACK> *files = readTags(getFileList(new QDir(share->getPath()), false), true);

    for(TRACK *curr = files->first(); curr != 0; curr = files->next())
        curr->path.replace(0, share->getPath().length(), "");

    database->lock()
    ;
    int SmbID = database->appendTracks(files, MEDIUM_SMB, share->getLabel(), share->getDevice(), 0, true, 0);
    error = database->getError();
    database->unlock();

    if(!error) {
        database->lock()
        ;
        app->lock()
        ;

        MEDIUM medium;
        medium.id       = SmbID;
        medium.type     = MEDIUM_SMB;
        medium.label    = share->getLabel();
        medium.path     = share->getDevice();

        datadispatcher->eventNewLocalAlbumDelta(SmbID, database->getLocalAlbumDelta(SmbID));
        datadispatcher->eventNewArtistDelta(database->getArtistDelta());
        datadispatcher->eventNewMedium(&medium);
        datadispatcher->eventNewTrackListing(database->getLastQuery());

        error  = database->getError();

        if(!error)
            datadispatcher->eventStoppedAppendingSMB(share);
        datadispatcher->eventRemoveEditLock();

        app->unlock();
        database->unlock();
    }

    if(error) {
        app->lock()
        ;
        datadispatcher->eventStoppedAppendingSMB(share);
        app->unlock();
        jobman->lock()
        ;
        jobman->addJob(new Job_DisconnectFromDatabase());
        jobman->unlock();
    }

    for(TRACK *curr = files->first(); curr != 0; curr = files->next())
        delete curr;
    delete files;

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();
    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_AppendSMBToDatabase::~Job_AppendSMBToDatabase() {}
