/****************************************************************************
** busywidget.cpp - cool animating widget
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"busywidget.h"
#include<qpainter.h>

BusyWidget::BusyWidget(QWidget *parent, const char *name)
:QWidget(parent, name)
{
	v_isActive = FALSE;
	frame = 0;
	at = 0;

	t = 0;

	setFixedWidth(80);
	setFixedHeight(17);
	setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));

	renderPixmap();
}

void BusyWidget::start()
{
	if(v_isActive)
		return;

	v_isActive = TRUE;
	t = new QTimer(this);
	connect(t, SIGNAL(timeout()), SLOT(animate()));
	t->start(50);
}

void BusyWidget::stop()
{
	if(!v_isActive)
		return;

	v_isActive = FALSE;
	delete t;
	t = 0;

	renderPixmap();
	render();
}

void BusyWidget::animate()
{
	++at;
	if(at == 12)
		at = 0;

	renderPixmap();
	render();
}

void BusyWidget::paintEvent(QPaintEvent *)
{
	render();
}

void BusyWidget::resizeEvent(QResizeEvent *)
{
	renderPixmap();
}

void BusyWidget::render()
{
	QPainter p(this);
	p.drawPixmap(0,0, pix);
}

void BusyWidget::renderPixmap()
{
	pix.resize(width(), height());
	pix.fill(Qt::white);

	QPainter p(&pix);
	p.setPen(v_isActive ? QColor("#FF00FF") : (Qt::gray));
	int y = height();
	int a = y / 2;
	int rep = width() / 12;
	for(int n = -1; n < rep+1; ++n) {
		int x = n * 12 + at;
		for(int n2 = 0; n2 < 4; ++n2) {
			p.drawLine(x+n2, 0, x+n2 + 8, a);
			p.drawLine(x+n2, y-1, x+n2 + 8, a);
		}
	}

	p.setPen(Qt::black);
	p.drawRect(0, 0, width(), height());
}

