/****************************************************************************
** filetrans.h - classes for handling file transfers
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef FILETRANS_H
#define FILETRANS_H

#include<qobject.h>
#include<qsocket.h>
#include<qserversocket.h>
#include<qptrlist.h>
#include<qguardedptr.h>
#include<qfileinfo.h>
#include<qfile.h>
#include<qsignalmapper.h>
#include<qcstring.h>


#define FT_FILE   0
#define FT_STRING 1

/****************************************************************************
  FileServer

  The FileServer class implements a simple httpd which serves files based
  on keys (for security).  Use 'addFile' to offer a file.  'addFile'
  will generate a unique key for the file and return a pointer to a
  FileServerItem.

    FileServer ftserv;
    ftserv.setServer("127.0.0.1", 12345);
    FileServerItem *item = ftserv.addFile("/home/justin/myfile.txt");

  The resulting URL (item->url) would be something like:

    http://127.0.0.1:12345/e1f13de17df17c5a/myfile.txt

  The local path to the file is kept hidden from the recipient.

****************************************************************************/

class FileTransfer;
struct FileServerItem;
class ServSock;

class FileServer : public QObject
{
	Q_OBJECT
public:
	FileServer();
	~FileServer();

	void setServer(const QString &, int);
	FileServerItem *addFile(const QString &fname, const QString &desc, const QString &who);
	QPtrList<FileServerItem> items() const;

signals:
	void newDownload(QGuardedPtr<FileTransfer>);

private slots:
	void connectionReady(int sock);
	void transferDiscarded(int id);

private:
	FileServerItem *getFSI(const QString &key);
	void listen();
	QString genKey();

	FileTransfer *findByID(int);

	QSignalMapper *sigmap[2];
	QPtrList<FileTransfer> ftlist;
	QPtrList<FileServerItem> filelist;
	int current_id;

	ServSock *serv;
	QString host;
	int port;
	void (*old_sigpipe)(int);

	friend class FileTransfer;
};


class ServSock : public QServerSocket
{
	Q_OBJECT
public:
	ServSock(int port);

signals:
	void connectionReady(int);

protected:
	// reimplemented
	void newConnection(int);
};


struct FileServerItem
{
	int type;
	QFileInfo file;
	QString key;

	QString url, who, desc;
};


class FileTransfer : public QObject
{
	Q_OBJECT
public:
	FileTransfer(FileServer *par);
	~FileTransfer();

	void start();
	bool isValid() { return v_isValid; }

	QSocket sock;
	int id;
	QFile file;
	bool v_isValid;
	bool finished;
	int type;
	QByteArray stringData;

signals:
	void done();
	void valid();
	void discarding();

private slots:
	void sock_readyRead();
	void sock_connectionClosed();
	void sock_bytesWritten(int);
	void processChunk();

private:
	bool getGETInfo(const QString &getReq, QString *resource, QString *http_ver);
	bool extractResourceInfo(const QString &resource, QString *fname, QString *key);
	void discard();

	FileServer *par;
	int bytesSent;

	int at;
	char recvBuf[1024];
};

#endif
