/****************************************************************************
** jabio.h - handles JabTasks
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef JABIO_H
#define JABIO_H

#include<qobject.h>
#include<qobjectlist.h>
#include<qstring.h>
#include<qstringlist.h>
#include<qdatetime.h>
#include<qptrlist.h>
#include<qdom.h>
#include"jabcommon.h"


class JabIO;

class JabTask : public QObject
{
	Q_OBJECT
public:
	JabTask(JabTask *parent);
	JabTask(JabIO *parent);
	virtual ~JabTask() { }

	bool isRoot() { return v_isRoot; }
	bool isDone() { return v_isDone; }
	JabIO *io() { return v_io; }
	QDomDocument *doc();
	JabTask *parent();
	JabTask *find(const char *);
	JabTask *findById(const QString &);

	const QString & id() { return v_id; }
	bool success() { return v_success; }
	const QString & errorString() { return v_errorString; }

	virtual void go() { }
	virtual void stop() { }
	virtual bool take(const QDomElement &);
	virtual void done(JabTask *);
	virtual QString toString();
	virtual bool fromString(const QString &);
	virtual bool isClearable() { return TRUE; }
	virtual bool isDaemon() { return FALSE; }

	// helper API
	bool stamp2TS(const QString &ts, QDateTime *d);
	QString TS2stamp(const QDateTime &);
	QDomElement textTag(const QString &name, const QString &content);
	QString tagContent(const QDomElement &e);
	QDomElement findSubTag(const QDomElement &e, const QString &name, bool *found);
	QDomElement createIQ(const QString &type, const QString &to, const QString &id);
	QDomElement queryTag(const QDomElement &e);
	QString queryNS(const QDomElement &e);
	JabRoster xmlReadRoster(const QDomElement &, bool push=FALSE);
	QString getErrorString(const QDomElement &e);

signals:
	void finished(JabTask *);
	void childFinished(JabTask *);
	void childAdded(JabTask *);
	void childRemoved(JabTask *);

private:
	QString v_id, v_errorString;
	bool v_success, v_isDone;
	JabIO *v_io;
	bool v_isRoot;
	JabTask *v_parent;

protected:
	void send(const QDomElement &);
	void setSuccess(bool);
	void setError(const QString &);

	// reimplemented
	void childEvent(QChildEvent *);
};


class JabIO : public QObject
{
	Q_OBJECT

public:
	JabIO();
	~JabIO();

	QString getId();
	void reset();
	void clear();
	void send(const QDomElement &);
	JabTask *root();
	JabTask *find(const char *);
	JabTask *findById(const QString &);

	void doneJT(JabTask *);

	QDomDocument doc;

signals:
	void outgoingPacket(const QDomElement &);
	void done(JabTask *);
	void anyDone(JabTask *);

public slots:
	void incomingPacket(const QDomElement &);

private:
	int id_seed;
	JabTask *v_root;

	void distribute(const QDomElement &);
};

#endif
