/****************************************************************************
** logwindow.cpp - a debug window to log colored messages
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"logwindow.h"
#include"common.h"
#include<qlayout.h>
#include<qpushbutton.h>
#include<qbuttongroup.h>

LogWindow::LogWindow(QWidget *parent, const char *name)
:QWidget(parent, name)
{
	setCaption(CAP("Log Window"));

	QVBoxLayout *vb1 = new QVBoxLayout(this, 8);

	te = new QTextEdit(this);
	te->setReadOnly(TRUE);
	te->setUndoRedoEnabled(FALSE);
	te->setTextFormat(RichText);

	te->setPaper(QBrush(Qt::black));
	vb1->addWidget(te);

	QHBoxLayout *hb1 = new QHBoxLayout(vb1);
	QButtonGroup *bg = new QButtonGroup(2, Vertical, "Log debug messages from:", this);
	db_check[0] = new QCheckBox("JabXml", bg);
	db_check[1] = new QCheckBox("Jabber", bg);
	db_check[2] = new QCheckBox("JabCon", bg);
	db_check[3] = new QCheckBox("MainWin", bg);
	db_check[4] = new QCheckBox("ContactView", bg);
	db_check[5] = new QCheckBox("HighLevel", bg);
	for(int n = 0; n < 6; ++n)
		db_check[n]->setChecked(FALSE);
	hb1->addWidget(bg);

	QVBoxLayout *vb2 = new QVBoxLayout(hb1);

	QPushButton *pb;

	pb = new QPushButton("&XML Input...", this);
	pb->setFixedWidth(100);
	connect(pb, SIGNAL(clicked()), SLOT(insertXml()));
	vb2->addWidget(pb);

	pb = new QPushButton("&Close", this);
	pb->setFixedWidth(100);
	connect(pb, SIGNAL(clicked()), SLOT(close()));
	vb2->addWidget(pb);

	resize(560,400);
}

LogWindow::~LogWindow()
{
}

void LogWindow::insertXml()
{
	bool ok;

	QString text = XmlPrompt::getText(&ok, this);
	if(ok) {
		if(debug_jabber)
			debug_jabber->insertXml(text);
	}
}

void LogWindow::append(int depth, const QString &str)
{
	if(!db_check[depth]->isChecked())
		return;

	QColor depth2color[6] = { Qt::yellow, Qt::red, Qt::cyan, Qt::blue, Qt::green, Qt::white };

	//te->setColor(depth2color[depth]);
	//te->append(str);
	te->append(QString("<font color=\"%1\">").arg(depth2color[depth].name()) + plain2rich(str) + "</font>\n");
	te->scrollToBottom();
}


XmlPrompt::XmlPrompt(QWidget *parent, const char *name)
:QDialog(parent, name, TRUE)
{
	setCaption(CAP("Xml Input"));

	QVBoxLayout *vb1 = new QVBoxLayout(this, 8);

	te = new QTextEdit(this);
	vb1->addWidget(te);

	QHBoxLayout *hb1 = new QHBoxLayout(vb1);
	QPushButton *pb;

	pb = new QPushButton("&Transmit", this);
	pb->setDefault(TRUE);
	connect(pb, SIGNAL(clicked()), SLOT(accept()));
	hb1->addWidget(pb);
	hb1->addStretch(1);

	pb = new QPushButton("&Close", this);
	connect(pb, SIGNAL(clicked()), SLOT(close()));
	hb1->addWidget(pb);

	resize(320,240);
}

QString XmlPrompt::getText(bool *ok, QWidget *parent, const char *name)
{
	XmlPrompt *p = new XmlPrompt(parent, name);
	QString result;

	if(p->exec() == Accepted) {
		*ok = TRUE;
		result = p->te->text();
	}
	else
		*ok = FALSE;

	delete p;
	return result;
}
