/****************************************************************************
** mainwin.cpp - the main window.  holds contactlist and buttons.
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"mainwin.h"
#include"userlist.h"
#include"common.h"
#include"showtextdlg.h"

#include<qmessagebox.h>
#include<qiconset.h>
#include<qtooltip.h>
#include<qstyle.h>


// deletes submenus in a popupmenu
void qpopupmenuclear(QPopupMenu *p)
{
	while(p->count()) {
		QMenuItem *item = p->findItem(p->idAt(0));
		QPopupMenu *popup = item->popup();
		p->removeItemAt(0);

		if(popup)
			delete popup;
	}
}


//*******************************************************
//  MainWin
//*******************************************************
MainWin::MainWin(bool _onTop, QWidget *parent, const char *name)
:QWidget(parent, name, _onTop ? WStyle_StaysOnTop: 0)
{
	wmdock[0] = QImage("./image/psiwmdock1.png");

	setIcon(status2pix(STATUS_OFFLINE));

	onTop = _onTop;
	nextAmount = 0;
	localStatus = STATUS_OFFLINE;
	userlist = 0;
	tray = 0;
	trayMenu = 0;
	statusTip = "";
	infoString = "";
	localJid = "";

	trayTimer = 0;
	animStep = 0;
	v_isActive = FALSE;

	vb_main = new QVBoxLayout(this, 2);
	QHBoxLayout *hb_tools = new QHBoxLayout(vb_main);

	tb_offline = new MToolButton(this);
	tb_offline->setToggleButton(TRUE);
	tb_offline->setOn(TRUE);
	hb_tools->addWidget(tb_offline);

	tb_away = new MToolButton(this);
	tb_away->setToggleButton(TRUE);
	tb_away->setOn(TRUE);
	hb_tools->addWidget(tb_away);

	tb_agents = new MToolButton(this);
	tb_agents->setToggleButton(TRUE);
	tb_agents->setOn(TRUE);
	hb_tools->addWidget(tb_agents);

	setToolBarIcons();

	hb_tools->addStretch(1);

	QToolTip::add(tb_offline, tr("Show Offline Contacts"));
	QToolTip::add(tb_away, tr("Show Away/XA/DnD"));
	QToolTip::add(tb_agents, tr("Show Agents/Transports"));

	cvlist = new ContactView(this);
	//connect(cvlist, SIGNAL(totalAlerts(int)), this, SLOT(totalAlerts(int)));
	connect(tb_offline, SIGNAL(toggled(bool)), cvlist, SLOT(setShowOffline(bool)));
	connect(tb_away, SIGNAL(toggled(bool)), cvlist, SLOT(setShowAway(bool)));
	connect(tb_agents, SIGNAL(toggled(bool)), cvlist, SLOT(setShowAgents(bool)));
	connect(cvlist, SIGNAL(showOffline(bool)), tb_offline, SLOT(setPressed(bool)));
	connect(cvlist, SIGNAL(showAway(bool)), tb_away, SLOT(setPressed(bool)));
	connect(cvlist, SIGNAL(showAgents(bool)), tb_agents, SLOT(setPressed(bool)));
	vb_main->addWidget(cvlist);

	QHBoxLayout *hb1 = new QHBoxLayout(vb_main);
	lb_info = new MLabel(this);
	connect(lb_info, SIGNAL(clicked(int)), SLOT(statusClicked(int)));
	connect(lb_info, SIGNAL(doubleClicked()), SLOT(doRecvNextEvent()));
	lb_info->setMinimumWidth(48);
	lb_info->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );
	lb_info->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	hb1->addWidget(lb_info);
	lb_ssl = new QLabel(this);
	lb_ssl->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setUsingSSL(FALSE);
	hb1->addWidget(lb_ssl);

	hb_status = new QHBoxLayout(vb_main);
	pb_options = new QPushButton(this);
	pb_options->setPixmap(*pix_main);
	pb_options->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed ) );
	hb_status->addWidget(pb_options);

	pb_status = new MPushButton(this);
	pb_status->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );
	decorateButton(STATUS_OFFLINE);
	hb_status->addWidget(pb_status);

	statusMenu = new QPopupMenu(this);
	optionsMenu = new QPopupMenu(this);
	buildStatusMenu();
	buildOptionsMenu();
	connect(statusMenu, SIGNAL(aboutToShow()), SLOT(buildStatusMenu()));
	connect(statusMenu, SIGNAL(activated(int)), SLOT(activatedStatusMenu(int)));
	connect(optionsMenu, SIGNAL(aboutToShow()), SLOT(buildOptionsMenu()));
	connect(optionsMenu, SIGNAL(activated(int)), SLOT(activatedOptionsMenu(int)));

	pb_options->setPopup(optionsMenu);
	pb_status->setPopup(statusMenu);

#ifdef Q_WS_MAC
	vb_main->addSpacing(16);
#endif

	updateCaption();
}

MainWin::~MainWin()
{
	if(tray) {
		delete tray;
		tray = 0;
		delete trayMenu;
		trayMenu = 0;
	}
}

void MainWin::setAlwaysOnTop(bool _onTop)
{
	if(_onTop == onTop)
		return;

	onTop = _onTop;
	QPoint p = pos();
	reparent(parentWidget(), onTop ? WStyle_StaysOnTop: 0, p, FALSE);
	move(p);
	show();
}

void MainWin::setUseDock(bool use)
{
	if(use == FALSE) {
		if(tray) {
			traySetAnim(0);
			delete tray;
			tray = 0;
			delete trayMenu;
			trayMenu = 0;
		}
		return;
	}

	if(tray)
		return;

	trayMenu = new QPopupMenu;
	connect(trayMenu, SIGNAL(aboutToShow()), SLOT(buildTrayMenu()));

	tray = new TrayIcon(makeTrayIcon(status2qim(localStatus)), "Psi", trayMenu);
	connect(tray, SIGNAL(clicked(const QPoint &, int)), SLOT(trayClicked(const QPoint &, int)));
	connect(tray, SIGNAL(doubleClicked(const QPoint &)), SLOT(trayDoubleClicked()));
	connect(tray, SIGNAL(closed()), SIGNAL(closeProgram()));
	tray->show();

	updateReadNext(nextType, nextAmount);
}

void MainWin::setInfo(const QString &str)
{
	infoString = str;

	if(nextAmount == 0)
		lb_info->setText(QString("<nobr>") + infoString + "</nobr>");
}

void MainWin::setUsingSSL(bool use)
{
	usingSSL = use;
	lb_ssl->setPixmap(usingSSL ? *pix_ssl_yes : *pix_ssl_no);
	QToolTip::add(lb_ssl, usingSSL ? tr("Connection is encrypted") : tr("Connection is not encrypted"));
}

void MainWin::buildStatusMenu()
{
	statusMenu->clear();

	statusMenu->insertItem(QIconSet(status2pix(STATUS_ONLINE)),  status2txt(STATUS_ONLINE),      STATUS_ONLINE);
	statusMenu->insertItem(QIconSet(status2pix(STATUS_AWAY)),    status2txt(STATUS_AWAY),        STATUS_AWAY);
	statusMenu->insertItem(QIconSet(status2pix(STATUS_XA)),      status2txt(STATUS_XA),          STATUS_XA);
	statusMenu->insertItem(QIconSet(status2pix(STATUS_DND)),     status2txt(STATUS_DND),         STATUS_DND);
	statusMenu->insertSeparator();
	statusMenu->insertItem(QIconSet(status2pix(STATUS_OFFLINE)), status2txt(STATUS_OFFLINE),     STATUS_OFFLINE);
}

void MainWin::activatedStatusMenu(int id)
{
	statusChanged(id);
}

void MainWin::buildOptionsMenu()
{
	// clear the menu and submenus
	qpopupmenuclear(optionsMenu);

	QPopupMenu *helpMenu = new QPopupMenu(optionsMenu);
	helpMenu->insertItem(tr("&ReadMe"), 13);
	helpMenu->insertItem(tr("&Hints"), 14);
	helpMenu->insertItem(tr("&License"), 11);
	helpMenu->insertItem(tr("&Warning"), 12);
	helpMenu->insertSeparator();
	helpMenu->insertItem(tr("&About"), 7);
	helpMenu->insertItem(tr("About &Qt"), 8);
	helpMenu->setItemEnabled(14, FALSE);
	connect(helpMenu, SIGNAL(activated(int)), SLOT(activatedOptionsMenu(int)));

	// options menu
	optionsMenu->insertItem(QIconSet(*pix_add),   tr("&Add a contact"),     0);
	optionsMenu->insertItem(QIconSet(*pix_send),  tr("New &blank message"), 1);
	optionsMenu->insertItem(QIconSet(transport2icon("", STATUS_ONLINE)), tr("Manage &services"), 15);
	optionsMenu->insertItem(tr("File sharing"), 4);
	optionsMenu->setItemEnabled(4, FALSE);
	optionsMenu->insertItem(QIconSet(*pix_account), tr("Account Setup"), 16);
	optionsMenu->insertItem(QIconSet(*pix_info), tr("Personal &info"), 6);
	optionsMenu->insertItem(tr("&Options"),             9);
	optionsMenu->insertItem(tr("&Log window"),          10);
	optionsMenu->insertItem(QIconSet(*pix_changeacc), tr("&Change profile"),3);
	optionsMenu->insertItem(tr("Play &sounds"), 2);
	optionsMenu->setItemChecked(2, useSound);
	optionsMenu->insertSeparator();
	optionsMenu->insertItem(tr("&Help"), helpMenu);
	optionsMenu->insertItem(tr("&Quit"),                 5);
}

void MainWin::activatedOptionsMenu(int id)
{
	QString dstr; dstr.sprintf("mainwin: id=%d\n", id);
	pdb(DEBUG_MAINWIN, dstr);

	if(id == 0)
		addUser();
	else if(id == 1)
		blankMessage();
	else if(id == 2) {
		if(useSound)
			useSound = FALSE;
		else
			useSound = TRUE;
	}
	else if(id == 3)
		changeProfile();
	else if(id == 4)
		doFileSharing();
	else if(id == 5) {
		tryCloseProgram();
	}
	else if(id == 6)
		accountInfo();
	else if(id == 7) {
		QString content = QString("<h3>%1 v%2</h3>\n").arg(PROG_NAME).arg(PROG_VERSION);
		content += "<br>\n";
		content += "Copyright (C) 2001,2002<br>\n";
		content += "By Justin Karneges<br>\n";
		content += "infiniti@affinix.com<br>\n";
		content += "http://psi.affinix.com/<br>\n";
		content += "<br>\n";
		content += "Psi is free software, covered by the GNU General Public License, and you are welcome to change it and/or distribute copies of it under certain conditions.  See Help->License for details.<br>\n";
		content += "<br>\n";
		content += "A capable Jabber client written in C++ using the Qt GUI Toolkit.<br>\n";
		content += "<br>\n";
//#ifdef Q_WS_MAC
		content += "Mac port contributed by Bill Myers.<br>\n";
//#endif
		content += "Graphics by Jason Kim, Justin Karneges, Hideaki Omuro, and other contributers.<br>\n";

		AboutDlg *w = new AboutDlg(*pix_icon_48, content, this);
		w->setCaption(tr("About"));
		//w->setIcon(*pix_online);
		w->exec();
		delete w;
		//QMessageBox::about(this, CAP("About"), content);
	}
	else if(id == 8) {
		QMessageBox::aboutQt(this);
	}
	else if(id == 9) {
		doOptions();
	}
	else if(id == 10)
		debug_window->show();
	else if(id == 11) {
		ShowTextDlg *w = new ShowTextDlg(g.pathBase + "/COPYING");
		w->setCaption(CAP(tr("License")));
		w->show();
	}
	else if(id == 12) {
		unfinishedSoftware();
	}
	else if(id == 13) {
		// readme
#ifdef Q_WS_WIN
		ShowTextDlg *w = new ShowTextDlg(g.pathBase + "/readme.txt");
#else
		ShowTextDlg *w = new ShowTextDlg(g.pathBase + "/README");
#endif
		w->setCaption(CAP(tr("ReadMe")));
		w->show();
	}
	else if(id == 14) {
		// hints
	}
	else if(id == 15) {
		doManageServices();

		return;
	}
	else if(id == 16) {
		doManageAccounts();
	}
}

void MainWin::buildTrayMenu()
{
	if(!trayMenu)
		return;
	trayMenu->clear();

	if(nextAmount > 0) {
		trayMenu->insertItem(tr("Receive next event"), this, SLOT(doRecvNextEvent()));
		trayMenu->insertSeparator();
	}

	if(isHidden())
		trayMenu->insertItem(tr("Un&hide"), this, SLOT(trayShow()));
	else
		trayMenu->insertItem(tr("&Hide"), this, SLOT(trayHide()));
	trayMenu->insertItem(tr("&Status"), statusMenu);
	trayMenu->insertSeparator();
	trayMenu->insertItem(tr("&Quit"), this, SLOT(tryCloseProgram()));
}

void MainWin::decorateButton(int status)
{
	setIcon(status2pix(status));
	if(tray && !v_isActive)
		tray->setIcon(makeTrayIcon(status2qim(status)));

	QIconSet icon;
	icon.setPixmap(status2pix(status), QIconSet::Small);

	pb_status->setIconSet(icon);
	pb_status->setText(status2txt(status));
}

bool MainWin::askQuit()
{
	if(localStatus != STATUS_OFFLINE) {
		int n = QMessageBox::information(0, tr("Warning"), tr("You are currently logged in.  Are you sure you want to close Psi?"), tr("&Yes"), tr("&No"));
		if(n != 0)
			return FALSE;
	}

	return TRUE;
}

void MainWin::tryCloseProgram()
{
	if(askQuit())
		closeProgram();
}

void MainWin::closeEvent(QCloseEvent *e)
{
	if(tray) {
		hide();
		return;
	}

	if(!askQuit())
		return;

        closeProgram();
	e->accept();
}

void MainWin::updateCaption()
{
	QString str = "";

	if(nextAmount > 0)
		str += "* ";

	if(localJid.isEmpty())
		str += PROG_NAME;
	else
		str += localJid;

	if(str == caption())
		return;

	setCaption(str);
}

void MainWin::localUpdate(const JabRosterEntry &e)
{
	localJid = e.jid;

	if(e.isAvailable())
		localStatus = e.local()->status;
	else
		localStatus = STATUS_OFFLINE;

	if(!localJid.isEmpty()) {
		statusTip = makeToolTip(e);
		QToolTip::add(lb_info, statusTip);
	}
	else {
		QToolTip::remove(lb_info);
	}

	if(tray)
		tray->setToolTip(status2txt(localStatus));

	updateCaption();
}

QString MainWin::makeToolTip(const JabRosterEntry &e)
{
	QString statusString = "";
	if(e.isAvailable())
		statusString = e.local()->statusString;

	QString jid = e.jid;
	QString nick = e.nick;

	QString str = QString("<qt>");
	str += QString("<nobr>%1: %2</nobr>").arg(jidnick(jid,nick)).arg(status2txt(localStatus));
	if(!nick.isEmpty())
		str += QString("<br>[%1]").arg(jid);

	if(e.isAvailable()) {
		JabResource *pr = e.res.priority();
		JabResource *r, *l;

		// current resource
		QString curres = "";
		l = e.res.local();
		if(l == pr)
			curres += "*";
		curres += l->name;
		str += QString("<br><nobr>") + QString(tr("Resource: %1")).arg(curres) + "</nobr>";

		// other resources
		QString resources;
		int n = 0;
		QPtrListIterator<JabResource> it(e.res);
		for(; (r = it.current()); ++it) {
			// skip the local resource
			if(l == r)
				continue;

			if(n > 0)
				resources += ", ";

			// priority?
			if(r == pr)
				resources += "*";
			resources += r->name;
			++n;
		}
		if(!resources.isEmpty())
			str += QString("<br><nobr>") + QString(tr("Other(s): %1")).arg(resources) + "</nobr>";
	}

	if(!statusString.isEmpty()) {
		QString head = tr("Status Message");
		str += QString("<br><u>%1</u><br>%2").arg(head).arg(plain2rich(statusString));
	}
	str += "</qt>";

	return str;
}

void MainWin::setToolBarIcons()
{
        tb_offline->setIconSet(QIconSet(*pix_offline));
	tb_away->setIconSet(QIconSet(status2pix(STATUS_AWAY)));
        tb_agents->setIconSet(QIconSet(transport2icon("", STATUS_ONLINE)));
}

void MainWin::optionsUpdate()
{
	decorateButton(localStatus);
	setToolBarIcons();

	// if the tray animation is active, reset it
	if(tray && v_isActive) {
		traySetAnim(messagetype2anim(nextType));
	}
}

QPixmap MainWin::makeTrayIcon(const QImage &_in)
{
#ifdef Q_WS_X11
	/*if(1) {
		QImage real = wmdock[0];
		real.detach();
		QImage in = _in;
		in.detach();

		// make sure it is no bigger than 16x16
		if(in.width() > 16 || in.height() > 16)
			in = in.smoothScale(16,16);

		int xo = 40;
		int yo = 40;

		int n, n2;

		// draw a border
		for(n = 0; n < 22; ++n) {
			real.setPixel(n + xo, yo, qRgb(0x80,0x80,0x80));
			real.setPixel(n + xo, yo + 21, qRgb(0x00,0x00,0x00));
			real.setPixel(xo, yo + n, qRgb(0x80,0x80,0x80));
			real.setPixel(xo + 21, yo + n, qRgb(0x00,0x00,0x00));
		}

		xo += 3;
		yo += 3;

		// draw a dropshadow
		for(n2 = 0; n2 < in.height(); ++n2) {
			for(n = 0; n < in.width(); ++n) {
				if(qAlpha(_in.pixel(n,n2))) {
					real.setPixel(n + xo + 2, n2 + yo + 2, qRgb(0x80,0x80,0x80));
				}
			}
		}
		for(n2 = 0; n2 < in.height(); ++n2) {
			for(n = 0; n < in.width(); ++n) {
				if(qAlpha(_in.pixel(n,n2))) {
					real.setPixel(n + xo, n2 + yo, _in.pixel(n,n2));
				}
			}
		}

		QPixmap icon;
		icon.convertFromImage(real);
		return icon;
	}
	else {*/
		// on X11, the KDE dock is 22x22.  let's make our icon "seem" bigger.
		QImage real(22,22,32);
		//QImage in = _in.convertToImage();
		QImage in = _in;
		in.detach();
		real.fill(0);
		real.setAlphaBuffer(TRUE);

		// make sure it is no bigger than 16x16
		if(in.width() > 16 || in.height() > 16)
			in = in.smoothScale(16,16);

		int xo = (real.width() - in.width()) / 2;
		int yo = (real.height() - in.height()) / 2;

		int n, n2;

		// draw a border
		for(n = 0; n < 22; ++n) {
			real.setPixel(n,  0, qRgb(0x80,0x80,0x80));
			real.setPixel(n, 21, qRgb(0x00,0x00,0x00));
			real.setPixel( 0, n, qRgb(0x80,0x80,0x80));
			real.setPixel(21, n, qRgb(0x00,0x00,0x00));
		}

		// draw a dropshadow
		for(n2 = 0; n2 < in.height(); ++n2) {
			for(n = 0; n < in.width(); ++n) {
				if(qAlpha(in.pixel(n,n2))) {
					int x = n + xo + 2;
					int y = n2 + yo + 2;
					real.setPixel(x, y, qRgba(0x80,0x80,0x80,0xff));
				}
			}
		}
		// draw the image
		for(n2 = 0; n2 < in.height(); ++n2) {
			for(n = 0; n < in.width(); ++n) {
				if(qAlpha(in.pixel(n,n2))) {
					QRgb c = in.pixel(n, n2);
					real.setPixel(n + xo, n2 + yo, qRgba(qRed(c), qGreen(c), qBlue(c), 0xff));
				}
			}
		}
		// create the alpha layer
		/*for(n2 = real.height()-2; n2 >= 0; --n2) {
			for(n = 0; n < real.width(); ++n) {
				uint c = real.pixel(n, n2);
				if(c > 0) {
					QRgb old = real.pixel(n, n2);
					real.setPixel(n, n2, qRgba(qRed(old), qGreen(old), qBlue(old), 0xff));
				}
			}
		}*/

		QPixmap icon;
		icon.convertFromImage(real);
		return icon;
	//}
#else
	QPixmap icon;
	icon.convertFromImage(_in);
	return icon;
#endif
}

void MainWin::trayClicked(const QPoint &, int button)
{
	if(option.dockDCstyle)
		return;

	if(button == MidButton) {
		doRecvNextEvent();
		return;
	}

	if(isHidden())
		trayShow();
	else
		trayHide();
}

void MainWin::trayDoubleClicked()
{
	if(!option.dockDCstyle)
		return;

	if(nextAmount > 0) {
		doRecvNextEvent();
		return;
	}

	trayShow();
}

void MainWin::trayShow()
{
	show();
	bringToFront(this);
}

void MainWin::trayHide()
{
	hide();
}

void MainWin::updateReadNext(int type, int amount)
{
	nextType = type;
	nextAmount = amount;

	if(nextAmount == 0)
		lb_info->setText(QString("<nobr>") + infoString + "</nobr>");
	else
		lb_info->setText(QString("<nobr><b>") + tr("%1 event(s) received").arg(nextAmount) + "</b></nobr>");

	if(tray) {
		if(nextAmount == 0)
			traySetAnim(0);
		else
			traySetAnim(messagetype2anim(nextType));
	}

#ifdef Q_WS_MAC
	if(nextAmount == 0)
		stopDockTileBounce();
	else
		bounceDockTile();
#endif

	updateCaption();
}

void MainWin::traySetAnim(Anim *_anim)
{
	if(_anim) {
		anim = _anim;
		animStep = 0;
		if(option.alertStyle == 0)
			tray->setIcon(makeTrayIcon(anim->qim_base()));
		if(!v_isActive) {
			v_isActive = TRUE;

			trayTimer = new QTimer(this);
			connect(trayTimer, SIGNAL(timeout()), SLOT(trayAnimate()));
			trayTimer->start(120);
		}
	}
	else {
		anim = 0;
		if(v_isActive) {
			v_isActive = FALSE;
			delete trayTimer;

			// change back to normal icon
			tray->setIcon(makeTrayIcon(status2qim(localStatus)));
		}
	}
}

void MainWin::trayAnimate()
{
	if(anim->isAnim() && option.alertStyle == 2) {
		tray->setIcon(makeTrayIcon(anim->qim_frame(animStep)));

		++animStep;
		if(animStep >= anim->numFrames()-1)
			animStep = 0;
	}
	else if(option.alertStyle != 0) {
		if(animStep == 0)
			tray->setIcon(makeTrayIcon(anim->qim_base()));
		else if(animStep == 4) {
			QImage blank(16,16,32);
			blank.fill(0);
			blank.setAlphaBuffer(TRUE);
			tray->setIcon(makeTrayIcon(blank));
		}

		++animStep;
		if(animStep == 8)
			animStep = 0;
	}
}

void MainWin::doRecvNextEvent()
{
	recvNextEvent();
}

void MainWin::statusClicked(int x)
{
	if(x == MidButton)
		recvNextEvent();
}


//*******************************************************
//  MPushButton
//*******************************************************
MPushButton::MPushButton(QWidget *parent, const char *name)
:QPushButton(parent, name)
{
	setMinimumWidth(48);
	setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed));

	hasTip = FALSE;
}

void MPushButton::setText(const QString &_text)
{
	if(hasTip) {
		QToolTip::remove(this);
		hasTip = FALSE;
	}

	QPushButton::setText(_text);
}

void MPushButton::drawButtonLabel(QPainter *p)
{
	// crazy code ahead!  watch out for potholes and deer.

	// this gets us the width of the "text area" on the button.
	// adapted from qt/src/styles/qcommonstyle.cpp and qt/src/widgets/qpushbutton.cpp
	QRect r = style().subRect(QStyle::SR_PushButtonContents, this);
	if(isMenuButton())
		r.setWidth(r.width() - style().pixelMetric(QStyle::PM_MenuButtonIndicator, this));
	if(iconSet() && !iconSet()->isNull())
		r.setWidth(r.width() - (iconSet()->pixmap(QIconSet::Small, QIconSet::Normal, QIconSet::Off).width() + 4));

	// font metrics
	QFontMetrics fm(font());

	// w1 = width of button text, w2 = width of text area
	int w1 = fm.width(text());
	int w2 = r.width();

	// backup original text
	QString oldtext = text();

	// button text larger than what will fit?
	if(w1 > w2) {
		if(!hasTip) {
			QToolTip::add(this, text());
			hasTip = TRUE;
		}

		// make a string that fits
		bool found = FALSE;
		QString newtext;
		int n;
		for(n = oldtext.length(); n > 0; --n) {
			if(fm.width(oldtext, n) < w2) {
				found = TRUE;
				break;
			}
		}
		if(found)
			newtext = oldtext.mid(0, n);
		else
			newtext = "";

		// set the new text that fits.  updates must be off, or we recurse.
		setUpdatesEnabled(FALSE);
		QButton::setText(newtext);
		setUpdatesEnabled(TRUE);
	}
	else {
		if(hasTip) {
			QToolTip::remove(this);
			hasTip = FALSE;
		}
	}

	// draw!
	QPushButton::drawButtonLabel(p);

	// restore original button text now that we are done drawing.
	setUpdatesEnabled(FALSE);
	QButton::setText(oldtext);
	setUpdatesEnabled(TRUE);
}


//*******************************************************
//  MToolButton
//*******************************************************
MToolButton::MToolButton(QWidget *parent, const char *name)
:QToolButton(parent, name)
{
}

void MToolButton::setPressed(bool x)
{
	setOn(x);
}


//*******************************************************
//  MLabel
//*******************************************************
MLabel::MLabel(QWidget *parent, const char *name)
:QLabel(parent, name)
{
}

void MLabel::mouseReleaseEvent(QMouseEvent *e)
{
	clicked(e->button());
	e->ignore();
}

void MLabel::mouseDoubleClickEvent(QMouseEvent *e)
{
	if(e->button() == LeftButton)
		doubleClicked();

	e->ignore();
}


//*******************************************************
//  AboutDlg
//*******************************************************
AboutDlg::AboutDlg(const QPixmap &icon, const QString &content, QWidget *par)
:QDialog(par, 0, TRUE)
{
	QLabel *l;
	QVBoxLayout *vb = new QVBoxLayout(this, 8);
	QHBoxLayout *hb = new QHBoxLayout(vb);
	QVBoxLayout *col;

	col = new QVBoxLayout(hb);
	l = new QLabel(this);
	l->setPixmap(icon);
	col->addWidget(l);
	col->addStretch(1);

	col = new QVBoxLayout(hb);
	l = new QLabel(this);
	l->setText(content);
	col->addWidget(l);
	col->addStretch(1);

	hb = new QHBoxLayout(vb);
	hb->addStretch(1);
	QPushButton *pb_ok = new QPushButton("&OK", this);
	connect(pb_ok, SIGNAL(clicked()), SLOT(close()));
	hb->addWidget(pb_ok);
	hb->addStretch(1);
}

