/****************************************************************************
** mainwin.h - the main window.  holds contactlist and buttons.
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef MAINWIN_H
#define MAINWIN_H

#include<qwidget.h>
#include<qpushbutton.h>
#include<qtoolbutton.h>
#include<qpopupmenu.h>
#include<qlayout.h>
#include<qlabel.h>
#include<qptrvector.h>
#include<qtooltip.h>
#include"jabcommon.h"
#include"contactview.h"
#include"userlist.h"
#include"trayicon.h"


class AboutDlg : public QDialog
{
	Q_OBJECT
public:
	AboutDlg(const QPixmap &icon, const QString &content, QWidget *par=0);
};

class MPushButton : public QPushButton
{
	Q_OBJECT
public:
	MPushButton(QWidget *parent=0, const char *name=0);

	void setText(const QString &);

protected:
	// reimplemented
	void drawButtonLabel(QPainter *);

private:
	bool hasTip;
};


class MToolButton : public QToolButton
{
	Q_OBJECT
public:
	MToolButton(QWidget *parent=0, const char *name=0);

public slots:
	void setPressed(bool);
};


class MLabel : public QLabel
{
	Q_OBJECT
public:
	MLabel(QWidget *parent=0, const char *name=0);

protected:
	// reimplemented
	void mouseReleaseEvent(QMouseEvent *);
	void mouseDoubleClickEvent(QMouseEvent *);

signals:
	void clicked(int);
	void doubleClicked();
};


class MainWin : public QWidget
{
	Q_OBJECT
public:
	MainWin(bool onTop, QWidget *parent=0, const char *name=0);
	~MainWin();

	void setAlwaysOnTop(bool);
	void setUseDock(bool);
	void setInfo(const QString &);
	void setUsingSSL(bool);

	QVBoxLayout *vb_main;
	QHBoxLayout *hb_status;

	ContactView *cvlist;
	MLabel *lb_info;
	QLabel *lb_ssl;
	bool usingSSL;
	QPushButton *pb_options;
	MPushButton *pb_status;

	int nextType, nextAmount;

	UserList *userlist;

private:
	bool onTop;
	QPopupMenu *statusMenu, *optionsMenu;
	int localStatus;
	QString localJid;
	MToolButton *tb_offline, *tb_away, *tb_agents;
	TrayIcon *tray;
	QPopupMenu *trayMenu;
	QString statusTip;

	bool askQuit();

	void updateCaption();
	void setToolBarIcons();
	QString makeToolTip(const JabRosterEntry &e);
	QPixmap makeTrayIcon(const QImage &);

	QString infoString;

	// tray animation
	QTimer *trayTimer;
	Anim *anim;
	bool v_isActive;
	int animStep;
	void traySetAnim(Anim *_anim);

	QImage wmdock[2];

protected:
	virtual void closeEvent(QCloseEvent *);

signals:
	void statusChanged(int);
	void changeProfile();
	void blankMessage();
	void closeProgram();
	void doOptions();
	void doManageServices();
	void doManageAccounts();
	void doFileSharing();
	void accountInfo();
	void addUser();
	void recvNextEvent();

private slots:
	void buildStatusMenu();
	void activatedStatusMenu(int);
	void buildOptionsMenu();
	void activatedOptionsMenu(int);
	void buildTrayMenu();
	void trayClicked(const QPoint &, int);
	void trayDoubleClicked();
	void trayAnimate();
	void doRecvNextEvent();
	void statusClicked(int);
	void trayShow();
	void trayHide();
	void tryCloseProgram();

public slots:
	void decorateButton(int);
	void localUpdate(const JabRosterEntry &);
	void updateReadNext(int nextType, int amount);

	void optionsUpdate();
};

#endif
