/****************************************************************************
** msgmle.cpp - subclass of QTextEdit to handle various hotkeys
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"msgmle.h"
#include"common.h"
#include<qiconset.h>
#include<qpopupmenu.h>
#include<qapplication.h>
#include<qclipboard.h>


MsgMle::MsgMle(QWidget *parent, const char *name)
:QTextEdit(parent, name)
{
	setWordWrap(QTextEdit::WidgetWidth);
}

bool MsgMle::focusNextPrevChild(bool next)
{
	return QWidget::focusNextPrevChild(next);
}

void MsgMle::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Key_Escape)
		e->ignore();
	else if(e->key() == Key_Return && ((e->state() & ControlButton) || (e->state() & AltButton)) )
		e->ignore();
	else if(e->key() == Key_H && (e->state() & ControlButton))
		e->ignore();
	else
		QTextEdit::keyPressEvent(e);
}

QPopupMenu *MsgMle::createPopupMenu(const QPoint& pos)
{
	lastLink = anchorAt(pos);
	if(lastLink.isEmpty())
		return QTextEdit::createPopupMenu(pos);

	QString txt = lastLink.left(7) == "mailto:" ? tr("Open mail composer") : tr("Open web browser");

	QPopupMenu *m = new QPopupMenu(this);
	m->insertItem(QIconSet(*pix_url), txt, this, SLOT(menuURL()));
	m->insertItem(tr("Copy location"), this, SLOT(menuCopy()));
	return m;
}

#include<stdio.h>
void MsgMle::emitLinkClicked(const QString &s)
{
	linkClicked(s);
}

void MsgMle::menuURL()
{
	linkClicked(lastLink);
}

void MsgMle::menuCopy()
{
	QString str = lastLink;

	if(str.left(7) == "mailto:")
		str.remove(0, 7);

	QApplication::clipboard()->setText(str);
}


ChatMle::ChatMle(QWidget *parent, const char *name)
:QTextEdit(parent, name)
{
	setWordWrap(QTextEdit::WidgetWidth);
}

bool ChatMle::focusNextPrevChild(bool next)
{
	return QWidget::focusNextPrevChild(next);
}

void ChatMle::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Key_Escape)
		e->ignore();
	else if(e->key() == Key_Return && ((e->state() & ControlButton) || (e->state() & AltButton)) )
		e->ignore();
	else if(e->key() == Key_M && (e->state() & ControlButton))
		insert("\n");
	else if(e->key() == Key_H && (e->state() & ControlButton))
		e->ignore();
	else if(e->key() == Key_S && (e->state() & AltButton))
		e->ignore();
	else if((e->key() == Key_Return) && !(e->state() & ShiftButton) /*&& !option.chatSoftReturn */)
		e->ignore();
	else if((e->key() == Key_PageUp || e->key() == Key_PageDown) && (e->state() & ShiftButton))
		e->ignore();
	else
		QTextEdit::keyPressEvent(e);
}
