#
# Psi qmake profile
#

# Configuration.  Remove the word 'thread' to build against non-threaded Qt
CONFIG    += qt thread


# Executable name
TARGET    = psi

# Header files
HEADERS   =  sslfilter.h \
	jabstream.h \
	jabcommon.h \
	jabio.h \
	jabtasks.h \
	jabber.h \
	profiles.h \
	main.h \
	jabsess.h \
	jabcon.h \
	userlist.h \
	mainwin.h \
	contactview.h \
	msgmle.h \
	eventdlg.h \
	adduserdlg.h \
	common.h \
	anim.h \
	historydlg.h \
	message.h \
	logwindow.h \
	showtextdlg.h \
	uniquewindow.h \
	statusdlg.h \
	optionsdlg.h \
	chatdlg.h \
	varlist.h \
	servicesdlg.h \
	browsedb.h \
	busywidget.h \
	infodlg.h \
	info.h \
	searchdlg.h \
	idle.h \
	filetrans.h \
	offermaindlg.h \
	trayicon.h \
	profiledlg.h \
	accountdlg.h

# Source files
SOURCES   =  sslfilter.cpp \
	jabstream.cpp \
	jabcommon.cpp \
	jabio.cpp \
	jabtasks.cpp \
	jabber.cpp \
	profiles.cpp \
	main.cpp \
	jabsess.cpp \
	jabcon.cpp \
	userlist.cpp \
	mainwin.cpp \
	contactview.cpp \
	msgmle.cpp \
	eventdlg.cpp \
	adduserdlg.cpp \
	common.cpp \
	anim.cpp \
	historydlg.cpp \
	message.cpp \
	logwindow.cpp \
	showtextdlg.cpp \
	uniquewindow.cpp \
	statusdlg.cpp \
	optionsdlg.cpp \
	chatdlg.cpp \
	varlist.cpp \
	servicesdlg.cpp \
	browsedb.cpp \
	busywidget.cpp \
	infodlg.cpp \
	info.cpp \
	searchdlg.cpp \
	idle.cpp \
	filetrans.cpp \
	offermaindlg.cpp \
	trayicon.cpp \
	profiledlg.cpp \
	accountdlg.cpp

# Qt Designer interfaces
INTERFACES = ui_options.ui ui_services.ui ui_info.ui ui_search.ui ui_offermain.ui ui_adduser.ui ui_profileopen.ui ui_profilemanage.ui ui_profilenew.ui ui_accountmanage.ui ui_accountmodify.ui

# Translations
TRANSLATIONS = psi_jp.ts psi_de.ts psi_zh.ts psi_pl.ts


# System-specific build settings
unix:!mac {
	INCLUDEPATH  += /usr/X11R6/include
	LIBS         += -lXss
	SOURCES      += trayicon_x11.cpp
}

win32: {
	LIBS         += win32/idleui.lib
	SOURCES      += trayicon_win.cpp
	RC_FILE      = win32/psi_win32.rc
}

mac: {
	SOURCES      += trayicon_mac.cpp
	QMAKE_LFLAGS += -framework Carbon -lz
}

