/****************************************************************************
** uniquewindow.h - helps keep track of unique windows
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef UNIQUEWINDOW_H
#define UNIQUEWINDOW_H

#include<qstring.h>
#include<qdict.h>
#include<qptrlist.h>

class UniqueWindow
{
public:
        UniqueWindow(bool isUnique, const QString &type, void *p, const QString &key);
        ~UniqueWindow();

        QString & key() { return v_key; }
        QString & type() { return v_type; }

private:
        bool v_isUnique;
        QString v_key;
        QString v_type;
};


struct UniqueWindowBankItem
{
        QString type;
        QDict<void> *dict;
};

class UniqueWindowBank
{
public:
        UniqueWindowBank();
        ~UniqueWindowBank();

        void add(const QString &type, void *p, const QString &);
        void remove(const QString &type, const QString &);

        void * finditem(const QString &type, const QString &key);
        static void * find(const QString &type, const QString &key);

private:
        QPtrList<UniqueWindowBankItem> list;
};

#endif
