# a mail sendy thing using smtp
from gtk import *

import smtplib
import string
from ptk.big_edit_box import *
import pynei18n

def get_connection(conf):
	"""
	return a connection object thingy.
	"""
	return smtplib.SMTP(conf["server"], conf["port"])

def fix_defaults(conf):
	conf["port"] = 25

def post_message(connection, msg):
	"""
	Post message 'msg'.
	"""
	# make list of target addresses
	adds = string.split(msg.headers["to"], ",")
	if msg.headers.has_key("cc"):
		adds = adds + string.split(msg.headers["cc"], ",")
	if msg.headers.has_key("bcc"):
		adds = adds + string.split(msg.headers["bcc"], ",")
	# clean up
	for i in range(0, len(adds)):
		adds[i] = string.strip(adds[i])
	connection.sendmail(msg.headers["from"], adds, msg.body)

def setup(parent_mailbox, conf):
	"""
	Open a configuration dialog box.
	"""
	win = GtkWindow()
	win.set_title(_("%s SMTP Settings") % parent_mailbox.name)

	box = GtkVBox()
	box.set_border_width(5)
	win.add(box)
	box.show()

	# dummy class object for settings
	class _dummy:
		pass
	settings = _dummy()
	settings.__dict__ = conf

	settings_box0 = big_edit_box( settings,
	      ( ("server", _("SMTP server:"), VAR_TYPE_STRING, 0, 0),
		("port", _("Port:"), VAR_TYPE_INTEGER, 0, 25) )
		#("username", "Username:", VAR_TYPE_STRING, 0, 0),
		#("password", "Password:", VAR_TYPE_STRING, MOD_HIDE, 0) )
	)
	box.pack_start(settings_box0, expand=FALSE)
	settings_box0.show()

	# separator between entry boxes and buttons
	separator = GtkHSeparator()
	box.pack_start(separator, expand=FALSE)
	separator.show()

	def save_changes(_button, win=win, settings=settings, settings_box0=settings_box0):
		# Extract info
		settings_box0.apply_changes()
		win.destroy()

	# boootons
	buttonbox = GtkHBox(spacing=5)
	buttonbox.set_border_width(5)
	box.pack_start(buttonbox, expand=FALSE)
	buttonbox.show()

	cancel_button = GtkButton(" "+_("Cancel")+" ")
	cancel_button.connect("clicked", win.destroy)
	buttonbox.pack_end(cancel_button, expand=FALSE)
	cancel_button.show()

	ok_button = GtkButton(" "+_("Ok")+" ")
	ok_button.connect("clicked", save_changes)
	buttonbox.pack_end(ok_button, expand=FALSE)
	ok_button.show()

	win.show()

	
