def Dump(tree):
    for t in tree:
        DumpNode(t, 0)


def DumpNode(node, indent, drawBranches=1):
    print '%s' % node['TYPE']
    indent = indent + 1
    keys = node.keys()[:]
    keys.sort()
    for key in keys:
        if key == 'TYPE':
            continue
        elif type(node[key]) == type({}):
            if drawBranches:
                print '|  ' * indent + '+  non-terminal %s: ' % key,
            else:
                print '  ' * indent + 'non-terminal %s: ' % key,
            DumpNode(node[key], indent)
        else:
            if drawBranches:
                print '|  ' * indent + '   terminal %s = %s' % (key, repr(node[key]))
            else:
                print '  ' * indent + 'terminal %s = %s' % (key, repr(node[key]))

