#Demonstrates some basic programming

from xml.xslt.Processor import Processor

#This is a rather dumb version.  It can only handle trees of width 11
#And the trees are deformed.  It does, however, demonstrate  one approach

sheet_str_1 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:template match="/">
  <xsl:variable name='width' select='number(*)'/>
  <xsl:text>'****Merry Xmas!****'&#10;&#10;</xsl:text>
  <xsl:call-template name='print_row'>
    <xsl:with-param name="curr_width" select="$width"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="print_row">
  <xsl:param name="curr_width"/>
  <xsl:choose>
    <xsl:when test='$curr_width = 11'>
      <xsl:text>***********&#10;</xsl:text>
    </xsl:when>
    <xsl:when test='$curr_width = 9'>
      <xsl:text>*********&#10;</xsl:text>
    </xsl:when>
    <xsl:when test='$curr_width = 7'>
      <xsl:text>*******&#10;</xsl:text>
    </xsl:when>
    <xsl:when test='$curr_width = 5'>
      <xsl:text>*****&#10;</xsl:text>
    </xsl:when>
    <xsl:when test='$curr_width = 3'>
      <xsl:text>***&#10;</xsl:text>
    </xsl:when>
    <xsl:when test='$curr_width = 1'>
      <xsl:text>*&#10;</xsl:text>
    </xsl:when>
  </xsl:choose>
  <xsl:if test='$curr_width != 1'>
  <xsl:call-template name='print_row'>
    <xsl:with-param name="curr_width" select="$curr_width - 2"/>
  </xsl:call-template>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>"""


#Much smarter version.  It should theoretically accept trees of arbitrary
#width

sheet_str_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>

<xsl:template match="/">
  <xsl:variable name='width' select='number(*)'/>
  <xsl:text>'****Merry Xmas!****'&#10;&#10;</xsl:text>
  <xsl:call-template name='print_row'>
    <xsl:with-param name="curr_width" select="$width"/>
    <xsl:with-param name="total_width" select="$width"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="print_row">
  <xsl:param name="curr_width"/>
  <xsl:param name="total_width"/>
  <xsl:call-template name='spacer'>
    <xsl:with-param name="counter" select="$curr_width div 2"/>
  </xsl:call-template>
  <xsl:call-template name='next_in_row'>
    <xsl:with-param name="counter" select="$total_width - $curr_width"/>
  </xsl:call-template>
  <xsl:if test='$curr_width != 1'>
  <xsl:call-template name='print_row'>
    <xsl:with-param name="curr_width" select="$curr_width - 2"/>
    <xsl:with-param name="total_width" select="$total_width"/>
  </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="next_in_row">
  <xsl:param name="counter"/>
  <xsl:text>*</xsl:text>
  <xsl:choose>
    <xsl:when test='$counter != 0'>
      <xsl:call-template name='next_in_row'>
        <xsl:with-param name="counter" select="$counter - 1"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>&#10;</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="spacer">
  <xsl:param name="counter"/>
  <xsl:text> </xsl:text>
    <xsl:if test='floor($counter) != 0'>
      <xsl:call-template name='spacer'>
        <xsl:with-param name="counter" select="$counter - 1"/>
      </xsl:call-template>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>"""

xml_source = """<tree-width>15</tree-width>"""

def MerryXmas():
    processor = Processor()
    processor.appendStylesheetString(sheet_str_2)
    result = processor.runString(xml_source)
    print 
    print result


if __name__ == '__main__':
    MerryXmas()
