'''An introduction to 4RDF'''

import xml.dom.ext
from xml.dom.ext.reader import PyExpat
reader = PyExpat.Reader()

def MemoryDemo():
    #With the memory driver, the model is not persistent
    from Ft.Rdf.Drivers import Memory
    #Note that the name is not significant for the memory driver
    db = Memory.CreateDb('mydemo')
    db.begin()

    from Ft.Rdf import Model
    #Create a model
    m = Model.Model(db)

    #The model is empty, as we illustrate
    print m.complete(None, None, None)
    
    #Read an RDF serialization into the model from DOM
    doc = reader.fromUri('w3c1.rdf')

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, doc, '')

    #Now we have goodies.  See!
    print m.complete(None, None, None)
    
    #Change the language to french
    from Ft.Rdf import Statement
    #First check the status
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)
    
    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'en')
    m.remove(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'fr')
    m.add(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    #Now write it all back out in XML
    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)

    #Clean up
    db.commit()
    reader.releaseNode(outdoc)
    reader.releaseNode(doc)

    return


#Shelve driver for simple persistence
def ShelveDemo():
    from Ft.Rdf.Drivers import Shelve
    #The shelve database name is the name of the DB or DBM file
    db = Shelve.GetDb('mydemo.dbm')

    db.begin()
    from Ft.Rdf import Model
    #Create a handle to the persistent model
    m = Model.Model(db)

    #The model is empty, as we illustrate
    print m.complete(None, None, None)
    
    #Read an RDF serialization into the model from DOM
    doc = reader.fromUri('w3c1.rdf')

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, doc, '')

    #Now we have goodies.  See!
    print m.complete(None, None, None)
    
    #Change the language to french
    from Ft.Rdf import Statement
    #First check the status
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)
    
    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'en')
    m.remove(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'fr')
    m.add(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    #Now write it all back out in XML
    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)

    #Clean up
    reader.releaseNode(outdoc)
    reader.releaseNode(doc)

    #Make changes permanent
    db.commit()
    return


#Note: Oracle driver is pretty much the same.
#Just search and replace "Postgres" with "Oracle"
def PostgresDemo():
    from Ft.Rdf.Drivers import Postgres
    #Set up to use the Postgres database of the given instance name
    db = Postgres.GetDb('mydemo')

    db.begin()
    from Ft.Rdf import Model
    #Create a handle to the persistent model
    m = Model.Model(db)

    #The model is empty, as we illustrate
    print m.complete(None, None, None)
    
    #Read an RDF serialization into the model from DOM
    doc = reader.fromUri('w3c1.rdf')

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    serializer.deserialize(m, doc, '')

    #Now we have goodies.  See!
    print m.complete(None, None, None)
    
    #Change the language to french
    from Ft.Rdf import Statement
    #First check the status
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)
    
    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'en')
    m.remove(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'fr')
    m.add(ns)
    #Check again
    print m.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    #Now write it all back out in XML
    outdoc = serializer.serialize(m)
    xml.dom.ext.PrettyPrint(outdoc)

    #Clean up
    reader.releaseNode(outdoc)
    reader.releaseNode(doc)

    #Make changes permanent
    db.commit()
    return


if __name__ == '__main__':
    print "Run the demo using the memory driver"
    MemoryDemo()
    print "Demo completed\n"
    ShelveDemo()
    print "Demo completed\n"
    try:
        print "Attempt to run the demo using the Postgres driver"
        from Ft.Rdf.Drivers import Postgres
        #Create the database
        Postgres.CreateDb('mydemo')
        PostgresDemo()
        print "Demo completed\n"
    except:
        print "Postgres demo could not be completed.\n"

