
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import ConstOperand
from Ft.Ods.MetaData import Constant
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.MetaData import Constant
from Ft.Ods.MetaData import Literal
from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import Enumeration
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_metaobject
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    try:
        test_metaobject.Test(tester,db,Constant.Constant)


        tester.startGroup("Constant Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,Constant.Constant,'the_Value',Literal.Literal)
        test_metadata_util.test_form_drop(tester,db,Constant.Constant,'type',Interface.Interface)
        test_metadata_util.test_form_drop(tester,db,Constant.Constant,'referenced_by',ConstOperand.ConstOperand,nSided=1)
        test_metadata_util.test_form_drop(tester,db,Constant.Constant,'enumeration',Enumeration.Enumeration)

        tester.startTest("value function")

        tx = db.new()
        tx.begin()

        l = Literal.Literal(db,None)
        l.literal_value = 1
        c = Constant.Constant(db,None)
        c.form_the_Value(l)

        tester.testResults(1,c.value(),done=0,msg="value function")

        tx.abort()

        tester.testDone()

        tester.groupDone()
    finally:
        db.close()




