# Just for flag constants
from Ft.Rdf import Model

import os

class FakeCompiledObject:
    def __init__(self):
        self._id = 1
        pass
    def __cmp__(self,other):
        return cmp(self._id,other._id)


DATABASE_NAME = os.environ.get('RDF_TEST_DB','test')

SOURCE_URI = 'http://localhost'

def Test(tester):

    driver = tester.test_data['driver']

    tester.startTest("Database functions")
    if driver.ExistsDb(DATABASE_NAME):
        driver.DestroyDb(DATABASE_NAME)
    
    tester.compare(0,driver.ExistsDb(DATABASE_NAME))
    driver.CreateDb(DATABASE_NAME)
    #tester.compare(1,driver.ExistsDb(DATABASE_NAME))
    db = driver.DbAdapter(DATABASE_NAME)

    tester.testDone()

    tester.startTest("Begin")
    db.begin()
    tester.testDone()

    tester.startTest("Add Statements")
    db.add([('Book','Author','Mike Olson','uri', SOURCE_URI),
            ('Book','Publisher','AWL','uri', SOURCE_URI),
            ('Book','Printer','Free Press','uri', SOURCE_URI),
            ])
    tester.testDone()

    tester.startTest("Remove Statement")
    db.remove([('Book','Printer','Free Press','uri',SOURCE_URI)])
    tester.testDone()

    tester.startTest("Test Complete with Parameters 1,2,3,4,5")
    rt = db.complete('Book','Author','Mike Olson', 'uri', SOURCE_URI,{})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()

    tester.startTest("Test Complete with parameters 1,2,3,4")
    rt = db.complete('Book', 'Author', 'Mike Olson', 'uri', None,
                     {})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()

    tester.startTest("Test Complete with parameters 1,2,3")
    rt = db.complete('Book', 'Publisher', 'AWL', None, None,
                     {})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Publisher',rt[0][1])
    tester.compare('AWL',rt[0][2])
    tester.testDone()


    tester.startTest("Test Complete with parameters 1,2")
    rt = db.complete('Book', 'Publisher', None, None, None,
                     {})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Publisher',rt[0][1])
    tester.compare('AWL',rt[0][2])
    tester.testDone()

    tester.startTest("Test Complete with parameters 1")
    rt = db.complete('Book', None, None, None, None,
                     {})
    tester.compare(2,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compareIn(['Author','Publisher'],rt[0][1])
    tester.compareIn(['AWL','Mike Olson'],rt[0][2])
    tester.compare('Book',rt[1][0])
    tester.compareIn(['Author','Publisher'],rt[1][1])
    tester.compareIn(['AWL','Mike Olson'],rt[1][2])
    tester.testDone()

    tester.startTest("Test Complete with parameters 2")
    rt = db.complete(None, 'Author', None, None, None,
                     {})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()

    tester.startTest("Test Complete with parameters 2,3 (empty results)")
    rt = db.complete('', 'Author', 'Jimmy', None, None,
                     {})
    tester.compare(0,len(rt))
    tester.testDone()

    tester.startTest("Test Complete with parameters 3")
    rt = db.complete('','','AWL',None, None, {})
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Publisher',rt[0][1])
    tester.compare('AWL',rt[0][2])
    tester.testDone()


    tester.startTest("Test Complete with no parameters")
    rt = db.complete('','',None,None, None, {})
    tester.compare(2,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compareIn(['Author','Publisher'],rt[0][1])
    tester.compareIn(['AWL','Mike Olson'],rt[0][2])
    tester.compare('Book',rt[1][0])
    tester.compareIn(['Author','Publisher'],rt[1][1])
    tester.compareIn(['AWL','Mike Olson'],rt[1][2])
    tester.testDone()


    tester.startTest("Test complete (with REGEX flag)")
    rt = db.complete('','','Mike.*',None,None,
                          {'objectFlags' : Model.REGEX,
                           })
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()

    tester.startTest("Test complete (with IGNORE_CASE)")
    rt = db.complete('','AUTHOR','',None,None,
                     {'predicateFlags' : Model.IGNORE_CASE,
                      })
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()


    tester.startTest("Test complete (with REGEX and IGNORE_CASE)")
    rt = db.complete('','','MIKE.*',None,None,
                     {'objectFlags' : Model.REGEX + Model.IGNORE_CASE,
                      })
    tester.compare(1,len(rt))
    tester.compare('Book',rt[0][0])
    tester.compare('Author',rt[0][1])
    tester.compare('Mike Olson',rt[0][2])
    tester.testDone()


    tester.startTest("Test Size")
    tester.compare(2,db.size(SOURCE_URI))
    tester.testDone()

    tester.startTest("Test Contains with expected result")
    has = db.contains('Book', 'Author', 'Mike Olson', 'uri', SOURCE_URI,{})
    tester.compare(1, has)
    tester.testDone()

        
    tester.startTest("Test Contains without expected result")
    has = db.contains('Book', 'Author', 'John', 'uri', SOURCE_URI,{})
    tester.compare(0, has)
    tester.testDone()

    tester.startTest("Test removeAll")
    db.removePattern('','','','',SOURCE_URI, {})
    rt = db.complete('','','','','', {})
    tester.compare(0,len(rt))
    tester.testDone()


    fco = FakeCompiledObject()

    tester.startTest("Test Bind")
    db.bind(fco, "TEST", SOURCE_URI)
    tester.testDone()

    tester.startTest("Test Lookup")
    tester.compare(fco,db.lookup("TEST",SOURCE_URI))
    tester.testDone()

    tester.startTest("Test has_keys")
    tester.compare(1,db.has_key("TEST",SOURCE_URI))
    tester.testDone()

    tester.startTest("Test keys")
    tester.compareIn(db.keys(SOURCE_URI),'TEST')
    tester.testDone()



    tester.startTest("Test Lookup (no results)")
    tester.compare(None,db.lookup("TEST2", SOURCE_URI))
    tester.testDone()

    tester.startTest("Test UnBind")
    db.unbind("TEST", SOURCE_URI)
    tester.compare(None,db.lookup("TEST", SOURCE_URI))
    tester.testDone()
    

    tester.startTest("Test Commit")
    db.commit()
    tester.testDone()
