import xml.dom.ext
from xml.dom.ext.reader import PyExpat
from Ft.Rdf import Model
from Ft.Rdf.Serializers.Dom import Serializer

doc1s = """<r:RDF
    xmlns:r="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
     xmlns:d="http://purl.org/dc/elements/1.1/"  
     xmlns:sm="http://xmlns.4suite.org/www/software-map"
     xmlns:f="http://xmlns.4suite.org/www/faq"
     xmlns="http://xmlns.4suite.org/www/platforms">


  <Platform r:ID="Linux">
    <d:Title>Linux</d:Title>
    <Version>6.2</Version>
    <Version>7.0</Version>
    <OsBase>UNIX</OsBase>
    <f:Entry r:resource='FAQ1'/>
  </Platform>

  <Platform r:ID="UNIX">
    <d:Title>UNIX</d:Title>
    <OsBase>UNIX</OsBase>
    <f:Entry r:resource='FAQ1'/>
  </Platform>

  <Platform r:ID="Windows">
    <d:Title>Windows</d:Title>
    <Version>3.1</Version>
    <Version>98</Version>
    <Version>2000</Version>
    <f:Entry r:resource='FAQ1'/>
  </Platform>

</r:RDF>
"""

doc2s = """<rdf:RDF xml:lang="en"
                     xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                     xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">

                  <rdf:Description ID="biologicalParent">
                   <rdf:type resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"/>
                  </rdf:Description>

                  <rdf:Description ID="biologicalFather">
                   <rdf:type resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Property"/>
                   <rdfs:subPropertyOf rdf:resource="#biologicalParent"/>
                  </rdf:Description>
                  </rdf:RDF>
"""


##doc2s = """<rdf:RDF
##            xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
##            xmlns:a="http://description.org/schema/">
##            <rdf:Description>
##              <rdf:subject resource="http://www.w3.org/Home/Lassila" />
##              <rdf:predicate resource="http://description.org/schema/Creator" />
##              <rdf:object>Ora Lassila</rdf:object>
##              <rdf:type resource="http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement" />
##              <a:attributedTo>Ralph Swick</a:attributedTo>
##              <a:attributedTime>1999-02-22</a:attributedTime>
##            </rdf:Description>
##          </rdf:RDF>
##"""


def test(driver):
    reader = PyExpat.Reader()
    if driver.ExistsDb('test'):
        driver.DestroyDb('test')
    db = driver.CreateDb('test')
    db.begin()
    m = Model.Model(db)

    doc1 = reader.fromString(doc1s)
    doc2 = reader.fromString(doc2s)

    serializer = Serializer()    
    #serializer.deserialize(m, doc1, 'http://spam.com')
    serializer.deserialize(m, doc1, None)
    serializer.deserialize(m, doc2, 'http://eggs.com')

    #print m.complete(None, None, None)
    print m.size()
    
    outdoc1 = serializer.serialize(m)
    db.commit()
    
    xml.dom.ext.PrettyPrint(outdoc1)

    db.begin()
    m.removePattern(None, None, None, sourceUri='http://eggs.com')

    #print m.complete(None, None, None)
    print m.size()

    outdoc2 = serializer.serialize(m)
    db.commit()
    xml.dom.ext.PrettyPrint(outdoc2)

    reader.releaseNode(outdoc1)
    reader.releaseNode(outdoc2)
    reader.releaseNode(doc1)
    reader.releaseNode(doc2)

    return

if __name__ == '__main__':
    from Ft.Rdf.Drivers import Memory, Postgres
    test(Memory)
    test(Postgres)
