def Test(tester):

    tester.startGroup('Location path expressions')

    tester.startTest('Creating test environment')
    from xml.xpath.ParsedAbbreviatedAbsoluteLocationPath import ParsedAbbreviatedAbsoluteLocationPath
    from xml.xpath.ParsedAbbreviatedRelativeLocationPath import ParsedAbbreviatedRelativeLocationPath
    from xml.xpath.ParsedAbsoluteLocationPath import ParsedAbsoluteLocationPath
    from xml.xpath.ParsedRelativeLocationPath import ParsedRelativeLocationPath
    from xml.xpath import ParsedStep
    from xml.xpath import ParsedNodeTest
    from xml.xpath import ParsedAxisSpecifier
    from xml.xpath import Context

    DomTree = tester.test_data['tree']

    nt = ParsedNodeTest.ParsedNameTest('*')
    as = ParsedAxisSpecifier.ParsedAxisSpecifier('child')
    step = ParsedStep.ParsedStep(as,nt,None)
    # [(expression, context, expected)...]
    tests = [(ParsedAbbreviatedAbsoluteLocationPath(step),
              Context.Context(DomTree.CHILD2, 1, 1),
              # all element children
              [DomTree.ROOT, DomTree.CHILD1] + DomTree.GCHILDREN1 +
              [DomTree.CHILD2] + DomTree.GCHILDREN2 + [DomTree.CHILD3]),
             (ParsedAbbreviatedRelativeLocationPath(step, step),
              Context.Context(DomTree.ROOT, 1, 1),
              # all element grand children
              DomTree.GCHILDREN1 + DomTree.GCHILDREN2),
             (ParsedAbsoluteLocationPath(None),
              Context.Context(DomTree.CHILD1, 1, 1),
              [DomTree.DOM]),
             (ParsedAbsoluteLocationPath(step),
              Context.Context(DomTree.CHILD1, 1, 1),
              [DomTree.ROOT]),
             (ParsedRelativeLocationPath(step, step),
              Context.Context(DomTree.ROOT, 1, 1),
              DomTree.GCHILDREN1 + DomTree.GCHILDREN2),
             ]
    tester.testDone()

    for (location, context, expected) in tests:
        tester.startTest(repr(location))
        actual = location.select(context)
        tester.compare(expected, actual)
        tester.testDone()

    return tester.groupDone()
