#Thomas Guettler <guettli@thomas-guettler.de> wants to use XInclude in his stylesheets

from Xslt import test_harness

sheet_1 = """\
<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xinclude="http://www.w3.org/2001/XInclude">

<xsl:output method="html" indent="yes" encoding="iso-8859-1"/>

<!-- copy source nodes to result nodes -->
<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="body">
  <body bgcolor="#ffbf00">
    <xsl:apply-templates/>
    <xinclude:include href="Xslt/Borrowed/tg_20010628-include.xml"/> 
  </body>
</xsl:template>

</xsl:stylesheet>
"""

source_1 = """\
<?xml version="1.0" encoding="iso-8859-1"?>
<html xmlns:xinclude="http://www.w3.org/2001/XInclude">
<head>
<title>MyTitle</title>
</head>
<body>
<xinclude:include href="Xslt/Borrowed/tg_20010628-include.xml"/>
</body>
</html>"""


expected_1 = """\
<html>
  <head>
    <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>
    <title>MyTitle</title>
  </head>
  <body bgcolor='#ffbf00'>
    <p>
 some text
</p>
    <p>
 some text
</p>
  </body>
</html>"""


def Test(tester):
    tester.startGroup("XInclude in source and stylesheet")
    source = test_harness.FileInfo(string=source_1, xinclude=1)
    sty = test_harness.FileInfo(string=sheet_1, xinclude=1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()

    return
