from Xslt import test_harness

import cStringIO, sys

sheet_str = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:template match="/">
    <HTML>
    <HEAD><TITLE>Address Book</TITLE>
    </HEAD>
    <BODY>
    <TABLE><xsl:apply-templates/></TABLE>
    </BODY>
    </HTML>
  </xsl:template>

  <xsl:template match="ENTRY">
        <xsl:element name='TR'>
        <xsl:apply-templates select='NAME'/>
        </xsl:element>
  </xsl:template>

  <xsl:template match="NAME">
    <xsl:element name='TD'>
    <xsl:attribute name='ALIGN'>CENTER</xsl:attribute>
      <xsl:message>We're in the thick of processing NAME elements</xsl:message>
      <B><xsl:apply-templates/></B>
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>
"""

expected = """<HTML>
  <HEAD>
    <META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'>
    <TITLE>Address Book</TITLE>
  </HEAD>
  <BODY>
    <TABLE>
      <TR>
        <TD ALIGN='CENTER'>
          <B>Pieter Aaron</B>
        </TD>
      </TR>
      <TR>
        <TD ALIGN='CENTER'>
          <B>Emeka Ndubuisi</B>
        </TD>
      </TR>
      <TR>
        <TD ALIGN='CENTER'>
          <B>Vasia Zhugenev</B>
        </TD>
      </TR>
    </TABLE>
  </BODY>
</HTML>"""

msg_results="""STYLESHEET MESSAGE:
We're in the thick of processing NAME elements
END STYLESHEET MESSAGE
"""

def Test(tester):


    tester.startGroup("Test 1")

    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml",nsAware=0)
    sty = test_harness.FileInfo(string=sheet_str)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected,
                                    )

    sys.stderr = cStringIO.StringIO()
    try:
        xtest.test(tester)
    except:
        sys.stderr = sys.__stderr__
        raise

    result = sys.stderr.getvalue()
    sys.stderr = sys.__stderr__

    tester.startTest("Verify message output")
    tester.compare(msg_results*3, result)
    tester.testDone()

    tester.groupDone()
    return
