# Tamito KAJIYAMA <2 March 2002>

import basetests

def test(encoding):
    file = "text.shift_jis"
    basetests.roundrobin_tests(file, encoding)
    basetests.test_stream(file, encoding)
    basetests.test_error_handling(encoding, (
        # invalid bytes
        ("abc\x80\x80\x82\xa0", "strict",  None),
        ("abc\x80\x80\x82\xa0", "replace", u"abc\ufffd\u3042"),
        ("abc\x80\x80\x82\xa0", "ignore",  u"abc\u3042"),
        # a character that has no corresponding character in Shift_JIS
        (u"abc\ufffd\u3042", "strict",  None),
        (u"abc\ufffd\u3042", "replace", "abc\x81\xac\x82\xa0"),
        (u"abc\ufffd\u3042", "ignore",  "abc\x82\xa0"),
        ))

def sanity():
    for h in range(0x81, 0xa0):
        for l in range(0x40, 0xed):
            if l in (0x7e, 0x7f):
                continue

            u1=u2="***"
            c = chr(h) + chr(l)
            u1 = unicode(c, "mbcs", "strict")
            try:
                u2 = unicode(c, "japanese.ms932", "strict")
            except UnicodeError:
                if ord(u1) <> 0x30fb:
                    raise
                else:
                    continue
            assert u1 == u2

            u1=u2="***"
            c = chr(h) + chr(l)
            u1 = unicode(c, "mbcs", "strict")
            try:
                u2 = unicode(c, "japanese.ms932", "strict")
            except UnicodeError:
                if ord(u1) <> 0x30fb:
                    raise
                else:
                    continue
            assert u1 == u2

    for h in range(0xe0, 0xfd):
        for l in range(0x40, 0xed):
            if l in (0x7e, 0x7f):
                continue
            u1=u2="***"
            c = chr(h) + chr(l)
            u1 = unicode(c, "mbcs", "strict")
            try:
                u2 = unicode(c, "japanese.ms932", "strict")
            except UnicodeError:
                if ord(u1) <> 0x30fb:
                    raise
                else:
                    continue
            assert u1 == u2

            u1=u2="***"
            c = chr(h) + chr(l)
            u1 = unicode(c, "mbcs", "strict")
            try:
                u2 = unicode(c, "japanese.ms932", "strict")
            except UnicodeError:
                if ord(u1) <> 0x30fb:
                    raise
                else:
                    continue
            assert u1 == u2

test("japanese.c.ms932")
#import sys
#if sys.platform == "win32":
#    sanity()

