#!/usr/bin/env python

from OpenGL.GL import *
from OpenGL.Tk import *
try:
    from Numeric import *
except:
    import sys
    print "This demo requires the Numeric extension, sorry."
    sys.exit()

n=50
a=arange(0,n)
x,y = cos(2*pi*a/n), sin(3*2*pi*a/n)

colors=ones((n, 3))
colors[0]=[1,0,0]
colors[25]=[1,1,0]

def redraw(o):
	glClearColor(0.5, 0.5, 0.5, 0)
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
	glOrtho(-1,1,-1,1,-1,1)
	glDisable(GL_LIGHTING)
	glBegin(GL_LINE_LOOP)
	glColorVertex2(x,y, colors)
	glEnd()
	glEnable(GL_LIGHTING)

def main():
	o = Opengl(width = 400, height = 400, double = 1)
	o.redraw = redraw
	o.autospin_allowed = 1
	o.pack(side = 'top', expand = 1, fill = 'both')
	o.mainloop()

main()
